/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets.internal;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.zest.core.widgets.IStyleableFigure;
import org.eclipse.zest.core.widgets.internal.CachedLabel;

public class GraphLabel
extends CachedLabel
implements IStyleableFigure {
    private Color borderColor;
    private int borderWidth;
    private int arcWidth;
    private final boolean painting = false;

    public GraphLabel(boolean cacheLabel) {
        this("", cacheLabel);
    }

    public GraphLabel(String text, boolean cacheLabel) {
        this(text, null, cacheLabel);
    }

    public GraphLabel(Image i, boolean cacheLabel) {
        this("", i, cacheLabel);
    }

    public GraphLabel(String text, Image i, boolean cacheLabel) {
        super(cacheLabel);
        this.initLabel();
        this.setText(text);
        this.setIcon(i);
        this.adjustBoundsToFit();
    }

    protected void initLabel() {
        super.setFont(Display.getDefault().getSystemFont());
        this.borderColor = ColorConstants.black;
        this.borderWidth = 0;
        this.arcWidth = 8;
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.setBorder((Border)new MarginBorder(1));
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.adjustBoundsToFit();
    }

    protected void adjustBoundsToFit() {
        Font font;
        String text = this.getText();
        if (text != null && (font = this.getFont()) != null) {
            Dimension minSize = FigureUtilities.getTextExtents((String)text, (Font)font);
            if (this.getIcon() != null) {
                Rectangle imageRect = this.getIcon().getBounds();
                int expandHeight = Math.max(imageRect.height - minSize.height, 0);
                minSize.expand(imageRect.width + 4, expandHeight);
            }
            minSize.expand(10 + 2 * this.borderWidth, 4 + 2 * this.borderWidth);
            this.setBounds(new org.eclipse.draw2d.geometry.Rectangle(this.getLocation(), minSize));
        }
    }

    public void paint(Graphics graphics) {
        int blue = this.getBackgroundColor().getBlue();
        blue = (blue = (int)((double)blue - (double)blue * 0.2)) > 0 ? blue : 0;
        int red = this.getBackgroundColor().getRed();
        red = (int)((double)red - (double)red * 0.2);
        red = red > 0 ? red : 0;
        int green = this.getBackgroundColor().getGreen();
        green = (int)((double)green - (double)green * 0.2);
        green = green > 0 ? green : 0;
        Color lightenColor = new Color((Device)Display.getCurrent(), new RGB(red, green, blue));
        graphics.setForegroundColor(lightenColor);
        graphics.setBackgroundColor(this.getBackgroundColor());
        graphics.pushState();
        org.eclipse.draw2d.geometry.Rectangle bounds = this.getBounds().getCopy();
        bounds.shrink(1, 1);
        Path p = new Path((Device)Display.getCurrent());
        p.addArc((float)bounds.left(), (float)bounds.top(), (float)this.arcWidth, (float)this.arcWidth, 90.0f, 90.0f);
        p.addArc((float)bounds.left(), (float)(bounds.bottom() - this.arcWidth), (float)this.arcWidth, (float)this.arcWidth, 180.0f, 90.0f);
        p.addArc((float)(bounds.right() - this.arcWidth), (float)(bounds.bottom() - this.arcWidth), (float)this.arcWidth, (float)this.arcWidth, 270.0f, 90.0f);
        p.addArc((float)(bounds.right() - this.arcWidth), (float)bounds.top(), (float)this.arcWidth, (float)this.arcWidth, 0.0f, 90.0f);
        graphics.clipPath(p);
        graphics.setBackgroundColor(lightenColor);
        graphics.setForegroundColor(this.getBackgroundColor());
        graphics.fillGradient(bounds, true);
        if (this.borderWidth > 0) {
            graphics.setClip(this.getBounds());
            graphics.setForegroundColor(this.borderColor);
            graphics.setBackgroundColor(this.borderColor);
            graphics.setLineWidth(this.borderWidth);
            graphics.drawRoundRectangle(bounds, this.arcWidth, this.arcWidth);
        }
        graphics.restoreState();
        p.dispose();
        super.paint(graphics);
        graphics.popState();
        lightenColor.dispose();
    }

    @Override
    protected Color getBackgroundTextColor() {
        return this.getBackgroundColor();
    }

    public void invalidate() {
        super.invalidate();
    }

    @Override
    public void setText(String s) {
        super.setText(s);
        this.adjustBoundsToFit();
    }

    @Override
    public void setIcon(Image image) {
        super.setIcon(image);
        this.adjustBoundsToFit();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    @Override
    public void setBorderColor(Color c) {
        this.borderColor = c;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    @Override
    public void setBorderWidth(int width) {
        this.borderWidth = width;
    }

    public int getArcWidth() {
        return this.arcWidth;
    }

    public void setArcWidth(int arcWidth) {
        this.arcWidth = arcWidth;
    }
}

