/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.layouts.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutObserver;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentDimension;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentPoint;
import org.eclipse.zest.layouts.dataStructures.DisplayIndependentRectangle;
import org.eclipse.zest.layouts.interfaces.ContextListener;
import org.eclipse.zest.layouts.interfaces.ExpandCollapseManager;
import org.eclipse.zest.layouts.interfaces.LayoutContext;
import org.eclipse.zest.layouts.interfaces.LayoutListener;
import org.eclipse.zest.layouts.interfaces.NodeLayout;
import org.eclipse.zest.layouts.interfaces.SubgraphLayout;

public class SpaceTreeLayoutAlgorithm
extends AbstractLayoutAlgorithm {
    public static final int TOP_DOWN = 1;
    public static final int BOTTOM_UP = 2;
    public static final int LEFT_RIGHT = 3;
    public static final int RIGHT_LEFT = 4;
    private final TreeLayoutObserver.TreeNodeFactory spaceTreeNodeFactory = new TreeLayoutObserver.TreeNodeFactory(){

        @Override
        public TreeLayoutObserver.TreeNode createTreeNode(NodeLayout nodeLayout, TreeLayoutObserver observer) {
            return new SpaceTreeNode(nodeLayout, observer);
        }
    };
    private final SpaceTreeExpandCollapseManager expandCollapseManager = new SpaceTreeExpandCollapseManager();
    private final ContextListener contextListener = new ContextListener.Stub(){

        @Override
        public boolean boundsChanged(LayoutContext context) {
            boolean previousBoundsWrong = SpaceTreeLayoutAlgorithm.this.bounds == null || SpaceTreeLayoutAlgorithm.this.bounds.width * SpaceTreeLayoutAlgorithm.this.bounds.height <= 0.0;
            SpaceTreeLayoutAlgorithm.this.bounds = context.getBounds();
            if (SpaceTreeLayoutAlgorithm.this.bounds.width * SpaceTreeLayoutAlgorithm.this.bounds.height > 0.0 && previousBoundsWrong) {
                SpaceTreeLayoutAlgorithm.this.expandCollapseManager.maximizeExpansion((SpaceTreeNode)SpaceTreeLayoutAlgorithm.this.treeObserver.getSuperRoot());
                SpaceTreeLayoutAlgorithm.this.refreshLayout(false);
            }
            return false;
        }
    };
    private final LayoutListener layoutListener = new LayoutListener(){

        @Override
        public boolean subgraphResized(LayoutContext context, SubgraphLayout subgraph) {
            return this.defaultSubgraphHandle(context, subgraph);
        }

        @Override
        public boolean subgraphMoved(LayoutContext context, SubgraphLayout subgraph) {
            return this.defaultSubgraphHandle(context, subgraph);
        }

        @Override
        public boolean nodeResized(LayoutContext context, NodeLayout node) {
            SpaceTreeLayoutAlgorithm.this.setAvailableSpace(SpaceTreeLayoutAlgorithm.this.getAvailableSpace() + ((SpaceTreeNode)SpaceTreeLayoutAlgorithm.this.treeObserver.getTreeNode(node)).spaceRequiredForNode());
            boolean result = this.defaultNodeHandle(context, node);
            SpaceTreeLayoutAlgorithm.this.setAvailableSpace(0.0);
            return result;
        }

        @Override
        public boolean nodeMoved(LayoutContext context, NodeLayout node) {
            return this.defaultNodeHandle(context, node);
        }

        private boolean defaultSubgraphHandle(LayoutContext context, SubgraphLayout subgraph) {
            SpaceTreeNode node = (SpaceTreeNode)SpaceTreeLayoutAlgorithm.this.treeObserver.getTreeNode(subgraph.getNodes()[0]);
            while (node != null && node.node != null && node.node.getSubgraph() == subgraph) {
                node = node.getParent();
            }
            if (node != null && node.subgraph == subgraph) {
                node.adjustPosition(subgraph.getLocation());
                if (context.isBackgroundLayoutEnabled()) {
                    ((SpaceTreeNode)SpaceTreeLayoutAlgorithm.this.treeObserver.getSuperRoot()).flushLocationChanges(0.0);
                    node.refreshSubgraphLocation();
                    context.flushChanges(false);
                }
            }
            return false;
        }

        private boolean defaultNodeHandle(LayoutContext context, NodeLayout node) {
            if (SpaceTreeLayoutAlgorithm.this.bounds.width * SpaceTreeLayoutAlgorithm.this.bounds.height <= 0.0) {
                return false;
            }
            SpaceTreeNode spaceTreeNode = (SpaceTreeNode)SpaceTreeLayoutAlgorithm.this.treeObserver.getTreeNode(node);
            spaceTreeNode.adjustPosition(node.getLocation());
            if (context.isBackgroundLayoutEnabled()) {
                ((SpaceTreeNode)SpaceTreeLayoutAlgorithm.this.treeObserver.getSuperRoot()).flushLocationChanges(0.0);
                spaceTreeNode.refreshSubgraphLocation();
                context.flushChanges(false);
            }
            return false;
        }
    };
    private int direction = 1;
    private final double leafGap = 15.0;
    private final double branchGap = 20.0;
    private final double layerGap = 20.0;
    private boolean directionChanged = false;
    private DisplayIndependentRectangle bounds;
    private TreeLayoutObserver treeObserver;
    private double availableSpace;
    private final List<SpaceTreeLayer> spaceTreeLayers = new ArrayList<SpaceTreeLayer>();
    private SpaceTreeNode protectedNode = null;

    public SpaceTreeLayoutAlgorithm() {
    }

    public SpaceTreeLayoutAlgorithm(int direction) {
        this.setDirection(direction);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        if (direction == this.direction) {
            return;
        }
        if (direction != 1 && direction != 2 && direction != 3 && direction != 4) {
            throw new IllegalArgumentException("Invalid direction: " + direction);
        }
        this.direction = direction;
        this.directionChanged = true;
        if (this.context.isBackgroundLayoutEnabled()) {
            this.checkPendingChangeDirection();
        }
    }

    @Override
    public void applyLayout(boolean clean) {
        this.bounds = this.context.getBounds();
        if (this.bounds.width * this.bounds.height == 0.0) {
            return;
        }
        if (clean) {
            this.treeObserver.recomputeTree();
            this.expandCollapseManager.maximizeExpansion((SpaceTreeNode)this.treeObserver.getSuperRoot());
        }
        SpaceTreeNode superRoot = (SpaceTreeNode)this.treeObserver.getSuperRoot();
        superRoot.flushExpansionChanges();
        superRoot.flushLocationChanges(0.0);
        this.checkPendingChangeDirection();
    }

    @Override
    public void setLayoutContext(LayoutContext context) {
        if (this.context != null) {
            this.context.removeContextListener(this.contextListener);
            this.context.removeLayoutListener(this.layoutListener);
            this.treeObserver.stop();
        }
        super.setLayoutContext(context);
        context.addContextListener(this.contextListener);
        context.addLayoutListener(this.layoutListener);
        this.treeObserver = new TreeLayoutObserver(context, this.spaceTreeNodeFactory);
        this.bounds = context.getBounds();
    }

    public ExpandCollapseManager getExpandCollapseManager() {
        return this.expandCollapseManager;
    }

    private void checkPendingChangeDirection() {
        if (this.directionChanged) {
            SubgraphLayout[] subgraphs = this.context.getSubgraphs();
            int subgraphDirection = this.getSubgraphDirection();
            SubgraphLayout[] subgraphLayoutArray = subgraphs;
            int n = subgraphs.length;
            int n2 = 0;
            while (n2 < n) {
                SubgraphLayout subgraph = subgraphLayoutArray[n2];
                subgraph.setDirection(subgraphDirection);
                ++n2;
            }
            this.directionChanged = false;
        }
    }

    private int getSubgraphDirection() {
        switch (this.direction) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        throw new RuntimeException();
    }

    protected void refreshLayout(boolean animation) {
        if (!this.context.isBackgroundLayoutEnabled()) {
            return;
        }
        SpaceTreeNode superRoot = (SpaceTreeNode)this.treeObserver.getSuperRoot();
        if (animation && superRoot.flushCollapseChanges()) {
            this.context.flushChanges(true);
        }
        if (superRoot.flushLocationChanges(0.0) && animation) {
            this.context.flushChanges(true);
        }
        superRoot.flushExpansionChanges();
        superRoot.flushLocationChanges(0.0);
        this.context.flushChanges(animation);
    }

    private double getAvailableSpace() {
        double result = this.direction == 1 || this.direction == 2 ? this.bounds.width : this.bounds.height;
        result = Math.max(result, this.availableSpace);
        Iterator<SpaceTreeLayer> iterator = this.spaceTreeLayers.iterator();
        while (iterator.hasNext()) {
            SpaceTreeLayer spaceTreeLayer;
            SpaceTreeLayer layer = spaceTreeLayer = iterator.next();
            if (layer.nodes.isEmpty()) break;
            SpaceTreeNode first = layer.nodes.get(0);
            SpaceTreeNode last = layer.nodes.get(layer.nodes.size() - 1);
            result = Math.max(result, last.positionInLayer - first.positionInLayer + (first.spaceRequiredForNode() + last.spaceRequiredForNode()) / 2.0);
        }
        return result;
    }

    private void setAvailableSpace(double availableSpace) {
        this.availableSpace = availableSpace;
    }

    private double expectedDistance(SpaceTreeNode node, SpaceTreeNode neighbor) {
        double expectedDistance = (node.spaceRequiredForNode() + neighbor.spaceRequiredForNode()) / 2.0;
        return expectedDistance += node.parent == neighbor.parent ? 15.0 : 20.0;
    }

    private NodeSnapshot[][] takeSnapShot() {
        NodeSnapshot[][] result = new NodeSnapshot[this.spaceTreeLayers.size()][];
        int i = 0;
        while (i < result.length) {
            SpaceTreeLayer layer = this.spaceTreeLayers.get(i);
            result[i] = new NodeSnapshot[layer.nodes.size()];
            int j = 0;
            while (j < result[i].length) {
                result[i][j] = new NodeSnapshot();
                result[i][j].node = layer.nodes.get(j);
                result[i][j].position = result[i][j].node.positionInLayer;
                result[i][j].expanded = result[i][j].node.expanded;
                ++j;
            }
            ++i;
        }
        return result;
    }

    private void revertToShanpshot(NodeSnapshot[][] snapShot) {
        int i = 0;
        while (i < snapShot.length) {
            SpaceTreeLayer layer = this.spaceTreeLayers.get(i);
            layer.nodes.clear();
            int j = 0;
            while (j < snapShot[i].length) {
                snapShot[i][j].node.positionInLayer = snapShot[i][j].position;
                snapShot[i][j].node.expanded = snapShot[i][j].expanded;
                layer.nodes.add(snapShot[i][j].node);
                ++j;
            }
            ++i;
        }
    }

    private class NodeSnapshot {
        SpaceTreeNode node;
        double position;
        boolean expanded;

        private NodeSnapshot() {
        }
    }

    private class SpaceTreeExpandCollapseManager
    implements ExpandCollapseManager {
        private SpaceTreeExpandCollapseManager() {
        }

        @Override
        public void initExpansion(LayoutContext context) {
        }

        @Override
        public void setExpanded(LayoutContext context, NodeLayout node, boolean expanded) {
            SpaceTreeNode spaceTreeNode = (SpaceTreeNode)SpaceTreeLayoutAlgorithm.this.treeObserver.getTreeNode(node);
            if (expanded) {
                this.maximizeExpansion(spaceTreeNode);
                SpaceTreeLayoutAlgorithm.this.refreshLayout(true);
            } else if (spaceTreeNode.expanded) {
                spaceTreeNode.expanded = false;
                SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(spaceTreeNode.depth + 1).removeNodes(spaceTreeNode.getChildren());
                SpaceTreeLayoutAlgorithm.this.refreshLayout(true);
            }
        }

        @Override
        public boolean canExpand(LayoutContext context, NodeLayout node) {
            SpaceTreeNode spaceTreeNode = (SpaceTreeNode)SpaceTreeLayoutAlgorithm.this.treeObserver.getTreeNode(node);
            if (spaceTreeNode != null) {
                return !spaceTreeNode.children.isEmpty();
            }
            return false;
        }

        @Override
        public boolean canCollapse(LayoutContext context, NodeLayout node) {
            SpaceTreeNode spaceTreeNode = (SpaceTreeNode)SpaceTreeLayoutAlgorithm.this.treeObserver.getTreeNode(node);
            if (spaceTreeNode != null) {
                return spaceTreeNode.expanded && !spaceTreeNode.children.isEmpty();
            }
            return false;
        }

        public void maximizeExpansion(SpaceTreeNode nodeToExpand) {
            SpaceTreeLayoutAlgorithm.this.protectedNode = nodeToExpand;
            double availableSpace = SpaceTreeLayoutAlgorithm.this.getAvailableSpace();
            double requiredSpace = 0.0;
            SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(nodeToExpand.depth + 1).removeNodes(nodeToExpand.getChildren());
            ArrayList<SpaceTreeNode> nodesInThisLayer = null;
            ArrayList<SpaceTreeNode> nodesInNextLayer = new ArrayList<SpaceTreeNode>();
            nodesInNextLayer.add(nodeToExpand);
            double spaceRequiredInNextLayer = nodeToExpand.spaceRequiredForNode();
            int layer = 0;
            while (!nodesInNextLayer.isEmpty()) {
                NodeSnapshot[][] snapShot = SpaceTreeLayoutAlgorithm.this.takeSnapShot();
                requiredSpace = Math.max(requiredSpace, spaceRequiredInNextLayer);
                spaceRequiredInNextLayer = 0.0;
                nodesInThisLayer = nodesInNextLayer;
                nodesInNextLayer = new ArrayList();
                int numOfNodesWithChildren = 0;
                Iterator iterator = nodesInThisLayer.iterator();
                while (iterator.hasNext()) {
                    SpaceTreeNode element;
                    SpaceTreeNode node = element = (SpaceTreeNode)iterator.next();
                    if (node.children.isEmpty()) continue;
                    node.expanded = true;
                    spaceRequiredInNextLayer += node.spaceRequiredForChildren();
                    nodesInNextLayer.addAll(node.getChildren());
                    ++numOfNodesWithChildren;
                }
                for (SpaceTreeNode node : nodesInNextLayer) {
                    node.expanded = false;
                }
                if (numOfNodesWithChildren == 0) break;
                boolean addedNewLayer = false;
                if (((spaceRequiredInNextLayer += 20.0 * (double)(numOfNodesWithChildren - 1)) <= requiredSpace || spaceRequiredInNextLayer <= availableSpace || layer < 1 && nodeToExpand.depth + layer < 1) && !nodesInNextLayer.isEmpty()) {
                    SpaceTreeLayer childLayer = SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(nodeToExpand.depth + layer + 1);
                    childLayer.addNodes(nodesInNextLayer);
                    SpaceTreeNode firstChild = (SpaceTreeNode)nodesInNextLayer.get(0);
                    SpaceTreeNode lastChild = (SpaceTreeNode)nodesInNextLayer.get(nodesInNextLayer.size() - 1);
                    double boundsWidth = spaceRequiredInNextLayer - firstChild.spaceRequiredForNode() / 2.0 - lastChild.spaceRequiredForNode() / 2.0;
                    double startPosition = Math.max((availableSpace - boundsWidth) / 2.0, firstChild.spaceRequiredForNode() / 2.0);
                    SpaceTreeLayoutAlgorithm.this.setAvailableSpace(spaceRequiredInNextLayer);
                    childLayer.fitNodesWithinBounds(nodesInNextLayer, startPosition, startPosition + boundsWidth);
                    SpaceTreeLayoutAlgorithm.this.setAvailableSpace(0.0);
                    if (nodeToExpand.childrenPositionsOK(nodesInThisLayer) || layer == 0 || nodeToExpand.depth + layer < 1) {
                        addedNewLayer = true;
                    }
                }
                if (!addedNewLayer) {
                    SpaceTreeLayoutAlgorithm.this.revertToShanpshot(snapShot);
                    break;
                }
                ++layer;
            }
            nodeToExpand.centerParentsBottomUp();
            nodeToExpand.centerParentsTopDown();
        }
    }

    private class SpaceTreeLayer {
        public List<SpaceTreeNode> nodes = new ArrayList<SpaceTreeNode>();
        private final int depth;
        public double thickness = 0.0;

        public SpaceTreeLayer(int depth) {
            this.depth = depth;
        }

        public void addNodes(List<SpaceTreeNode> nodesToAdd) {
            ListIterator<SpaceTreeNode> layerIterator = this.nodes.listIterator();
            SpaceTreeNode previousNode = null;
            for (SpaceTreeNode nodeToAdd : nodesToAdd) {
                SpaceTreeNode nodeInLayer = null;
                while (layerIterator.hasNext()) {
                    nodeInLayer = layerIterator.next();
                    if (nodeInLayer.order >= nodeToAdd.order) break;
                    double expectedPostion = previousNode == null ? 0.0 : previousNode.positionInLayer + SpaceTreeLayoutAlgorithm.this.expectedDistance(previousNode, nodeInLayer);
                    nodeInLayer.positionInLayer = Math.max(nodeInLayer.positionInLayer, expectedPostion);
                    previousNode = nodeInLayer;
                }
                if (nodeInLayer == null) {
                    layerIterator.add(nodeToAdd);
                } else if (nodeInLayer.order == nodeToAdd.order) {
                    layerIterator.set(nodeToAdd);
                } else {
                    if (nodeInLayer.order > nodeToAdd.order) {
                        layerIterator.previous();
                    }
                    layerIterator.add(nodeToAdd);
                }
                layerIterator.previous();
            }
            while (layerIterator.hasNext()) {
                SpaceTreeNode nodeInLayer = layerIterator.next();
                double expectedPostion = previousNode == null ? 0.0 : previousNode.positionInLayer + SpaceTreeLayoutAlgorithm.this.expectedDistance(previousNode, nodeInLayer);
                nodeInLayer.positionInLayer = Math.max(nodeInLayer.positionInLayer, expectedPostion);
                previousNode = nodeInLayer;
            }
            this.refreshThickness();
        }

        public void removeNode(SpaceTreeNode node) {
            if (this.nodes.remove(node)) {
                SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth + 1).removeNodes(node.getChildren());
                this.refreshThickness();
            }
        }

        public void removeNodes(List<SpaceTreeNode> nodesToRemove) {
            if (this.nodes.removeAll(nodesToRemove)) {
                SpaceTreeLayer nextLayer = SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth + 1);
                for (SpaceTreeNode nodeToRemove : nodesToRemove) {
                    nextLayer.removeNodes(nodeToRemove.getChildren());
                }
                this.refreshThickness();
            }
        }

        public void checkThickness(SpaceTreeNode node) {
            double nodeThickness = 0.0;
            DisplayIndependentDimension size = node.node.getSize();
            double d = nodeThickness = SpaceTreeLayoutAlgorithm.this.direction == 1 || SpaceTreeLayoutAlgorithm.this.direction == 2 ? size.height : size.width;
            if (node.subgraph != null && node.subgraph.isGraphEntity()) {
                size = node.subgraph.getSize();
                nodeThickness += SpaceTreeLayoutAlgorithm.this.direction == 1 || SpaceTreeLayoutAlgorithm.this.direction == 2 ? size.height : size.width;
            }
            this.thickness = Math.max(this.thickness, nodeThickness);
        }

        public void refreshThickness() {
            this.thickness = 0.0;
            for (SpaceTreeNode node : this.nodes) {
                this.checkThickness(node);
            }
        }

        public void fitNodesWithinBounds(List<SpaceTreeNode> nodeList, double startPosition, double endPosition) {
            double expectedDistance;
            SpaceTreeNode previousNode;
            NodeSnapshot[][] snapShot = SpaceTreeLayoutAlgorithm.this.takeSnapShot();
            SpaceTreeNode[] nodes = nodeList.toArray(new SpaceTreeNode[nodeList.size()]);
            double initialStartPosition = nodes[0].positionInLayer;
            double initialNodesBredth = nodes[nodes.length - 1].positionInLayer - initialStartPosition;
            double[] desiredPositions = new double[nodes.length];
            int i = 0;
            while (i < nodes.length) {
                double initialPositionAsPercent = initialNodesBredth > 0.0 ? (nodes[i].positionInLayer - initialStartPosition) / initialNodesBredth : 0.0;
                desiredPositions[i] = initialPositionAsPercent * (endPosition - startPosition);
                ++i;
            }
            i = 1;
            while (i < nodes.length) {
                previousNode = nodes[i - 1];
                SpaceTreeNode node = nodes[i];
                expectedDistance = SpaceTreeLayoutAlgorithm.this.expectedDistance(previousNode, node);
                if (desiredPositions[i] - desiredPositions[i - 1] < expectedDistance) {
                    desiredPositions[i] = desiredPositions[i - 1] + expectedDistance;
                }
                ++i;
            }
            if (desiredPositions[nodes.length - 1] > endPosition - startPosition) {
                desiredPositions[nodes.length - 1] = endPosition - startPosition;
                i = nodes.length - 1;
                while (i > 0) {
                    previousNode = nodes[i - 1];
                    SpaceTreeNode node = nodes[i];
                    expectedDistance = SpaceTreeLayoutAlgorithm.this.expectedDistance(previousNode, node);
                    if (desiredPositions[i] - desiredPositions[i - 1] >= expectedDistance) break;
                    desiredPositions[i - 1] = desiredPositions[i] - expectedDistance;
                    --i;
                }
            }
            i = 0;
            while (i < nodeList.size()) {
                SpaceTreeNode node = nodeList.get(i);
                double desiredPosition = startPosition + desiredPositions[i];
                this.moveNode(node, desiredPosition);
                if (Math.abs(node.positionInLayer - desiredPosition) > 0.5) {
                    startPosition += node.positionInLayer - desiredPosition;
                    i = -1;
                    SpaceTreeLayoutAlgorithm.this.revertToShanpshot(snapShot);
                }
                ++i;
            }
        }

        public void moveNode(SpaceTreeNode node, double newPosition) {
            Collections.sort(this.nodes, (arg0, arg1) -> arg0.order - arg1.order);
            double positionInLayerAtStart = node.positionInLayer;
            if (newPosition >= positionInLayerAtStart) {
                this.moveNodeForward(node, newPosition);
            }
            if (newPosition <= positionInLayerAtStart) {
                this.moveNodeBackward(node, newPosition);
            }
        }

        private void moveNodeForward(SpaceTreeNode nodeToMove, double newPosition) {
            int nodeIndex = this.nodes.indexOf(nodeToMove);
            if (nodeIndex == -1) {
                throw new IllegalArgumentException("node not on this layer");
            }
            NodeSnapshot[][] snapShot = SpaceTreeLayoutAlgorithm.this.takeSnapShot();
            boolean firstRun = true;
            block0: while (firstRun || nodeToMove.positionInLayer < newPosition) {
                firstRun = false;
                double requiredSpace = 0.0;
                SpaceTreeNode previousNode = nodeToMove;
                int i = nodeIndex + 1;
                while (i < this.nodes.size()) {
                    SpaceTreeNode nextNode = this.nodes.get(i);
                    requiredSpace += SpaceTreeLayoutAlgorithm.this.expectedDistance(previousNode, nextNode);
                    previousNode = nextNode;
                    ++i;
                }
                if ((requiredSpace += previousNode.spaceRequiredForNode() / 2.0) > SpaceTreeLayoutAlgorithm.this.getAvailableSpace() - newPosition) {
                    boolean removed = false;
                    int i2 = nodeIndex;
                    while (i2 < this.nodes.size()) {
                        SpaceTreeNode nextNode = this.nodes.get(i2);
                        if (SpaceTreeLayoutAlgorithm.this.protectedNode == null || !SpaceTreeLayoutAlgorithm.this.protectedNode.isAncestorOf(nextNode) && !nextNode.parent.isAncestorOf(SpaceTreeLayoutAlgorithm.this.protectedNode)) {
                            this.collapseNode(nextNode.getParent());
                            if (nextNode.parent == nodeToMove.parent) break block0;
                            removed = true;
                            break;
                        }
                        ++i2;
                    }
                    if (!removed) {
                        newPosition = SpaceTreeLayoutAlgorithm.this.getAvailableSpace() - requiredSpace;
                        SpaceTreeLayoutAlgorithm.this.revertToShanpshot(snapShot);
                        continue;
                    }
                }
                SpaceTreeNode currentNodeToMove = nodeToMove;
                double newPositionForCurrent = newPosition;
                int i3 = nodeIndex;
                while (i3 < this.nodes.size()) {
                    currentNodeToMove.positionInLayer = newPositionForCurrent;
                    if (currentNodeToMove.firstChild) {
                        SpaceTreeNode parent = currentNodeToMove.getParent();
                        if (this.depth > 0 && parent.positionInLayer <= newPositionForCurrent) {
                            SpaceTreeLayer parentLayer = SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth - 1);
                            parentLayer.moveNodeForward(parent, newPositionForCurrent);
                            if (parent.positionInLayer < newPositionForCurrent) {
                                double delta = newPositionForCurrent - parent.positionInLayer;
                                newPosition -= delta;
                                SpaceTreeLayoutAlgorithm.this.revertToShanpshot(snapShot);
                                continue block0;
                            }
                        }
                    }
                    if (currentNodeToMove.expanded && !currentNodeToMove.children.isEmpty()) {
                        SpaceTreeNode lastChild = currentNodeToMove.getChildren().get(currentNodeToMove.children.size() - 1);
                        if (lastChild.positionInLayer < newPositionForCurrent) {
                            SpaceTreeNode firstChild = currentNodeToMove.getChildren().get(0);
                            SpaceTreeLayer childLayer = SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth + 1);
                            double expectedDistanceBetweenChildren = currentNodeToMove.spaceRequiredForChildren() - firstChild.spaceRequiredForNode() / 2.0 - lastChild.spaceRequiredForNode() / 2.0;
                            childLayer.moveNodeForward(firstChild, newPositionForCurrent - expectedDistanceBetweenChildren);
                            if (currentNodeToMove.expanded && lastChild.positionInLayer < newPositionForCurrent) {
                                childLayer.moveNodeForward(lastChild, newPositionForCurrent);
                                if (lastChild.positionInLayer < newPositionForCurrent) {
                                    double delta = newPositionForCurrent - lastChild.positionInLayer;
                                    newPosition -= delta;
                                    SpaceTreeLayoutAlgorithm.this.revertToShanpshot(snapShot);
                                    continue block0;
                                }
                            }
                        }
                    }
                    if (i3 < this.nodes.size() - 1) {
                        SpaceTreeNode nextNode = this.nodes.get(i3 + 1);
                        currentNodeToMove = nextNode;
                        if (currentNodeToMove.positionInLayer > (newPositionForCurrent += SpaceTreeLayoutAlgorithm.this.expectedDistance(currentNodeToMove, nextNode))) continue block0;
                    }
                    ++i3;
                }
            }
        }

        private void moveNodeBackward(SpaceTreeNode nodeToMove, double newPosition) {
            int nodeIndex = this.nodes.indexOf(nodeToMove);
            if (nodeIndex == -1) {
                throw new IllegalArgumentException("node not on this layer");
            }
            NodeSnapshot[][] snapShot = SpaceTreeLayoutAlgorithm.this.takeSnapShot();
            boolean firstRun = true;
            block0: while (firstRun || nodeToMove.positionInLayer > newPosition) {
                firstRun = false;
                double requiredSpace = 0.0;
                SpaceTreeNode previousNode = nodeToMove;
                int i = nodeIndex - 1;
                while (i >= 0) {
                    SpaceTreeNode nextNode = this.nodes.get(i);
                    requiredSpace += SpaceTreeLayoutAlgorithm.this.expectedDistance(previousNode, nextNode);
                    previousNode = nextNode;
                    --i;
                }
                if ((requiredSpace += previousNode.spaceRequiredForNode() / 2.0) > newPosition) {
                    boolean removed = false;
                    int i2 = nodeIndex;
                    while (i2 >= 0) {
                        SpaceTreeNode nextNode = this.nodes.get(i2);
                        if (SpaceTreeLayoutAlgorithm.this.protectedNode == null || !SpaceTreeLayoutAlgorithm.this.protectedNode.isAncestorOf(nextNode) && !nextNode.parent.isAncestorOf(SpaceTreeLayoutAlgorithm.this.protectedNode)) {
                            this.collapseNode(nextNode.getParent());
                            if (nextNode.parent == nodeToMove.parent) break block0;
                            nodeIndex -= nextNode.parent.children.size();
                            removed = true;
                            break;
                        }
                        --i2;
                    }
                    if (!removed) {
                        newPosition = requiredSpace;
                        SpaceTreeLayoutAlgorithm.this.revertToShanpshot(snapShot);
                        continue;
                    }
                }
                SpaceTreeNode currentNodeToMove = nodeToMove;
                double newPositionForCurrent = newPosition;
                int i3 = nodeIndex;
                while (i3 >= 0) {
                    currentNodeToMove.positionInLayer = newPositionForCurrent;
                    if (currentNodeToMove.lastChild) {
                        SpaceTreeNode parent = currentNodeToMove.getParent();
                        if (this.depth > 0 && parent.positionInLayer >= newPositionForCurrent) {
                            SpaceTreeLayer parentLayer = SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth - 1);
                            parentLayer.moveNodeBackward(parent, newPositionForCurrent);
                            if (parent.positionInLayer > newPositionForCurrent) {
                                double delta = parent.positionInLayer - newPositionForCurrent;
                                newPosition += delta;
                                SpaceTreeLayoutAlgorithm.this.revertToShanpshot(snapShot);
                                continue block0;
                            }
                        }
                    }
                    if (currentNodeToMove.expanded && !currentNodeToMove.children.isEmpty()) {
                        SpaceTreeNode firstChild = currentNodeToMove.getChildren().get(0);
                        if (firstChild.positionInLayer > newPositionForCurrent) {
                            SpaceTreeNode lastChild = currentNodeToMove.getChildren().get(currentNodeToMove.children.size() - 1);
                            SpaceTreeLayer childLayer = SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth + 1);
                            double expectedDistanceBetweenChildren = currentNodeToMove.spaceRequiredForChildren() - firstChild.spaceRequiredForNode() / 2.0 - lastChild.spaceRequiredForNode() / 2.0;
                            childLayer.moveNodeBackward(lastChild, newPositionForCurrent + expectedDistanceBetweenChildren);
                            if (currentNodeToMove.expanded && firstChild.positionInLayer > newPositionForCurrent) {
                                childLayer.moveNodeBackward(firstChild, newPositionForCurrent);
                                if (firstChild.positionInLayer > newPositionForCurrent) {
                                    double delta = firstChild.positionInLayer - newPositionForCurrent;
                                    newPosition += delta;
                                    SpaceTreeLayoutAlgorithm.this.revertToShanpshot(snapShot);
                                    continue block0;
                                }
                            }
                        }
                    }
                    if (i3 > 0) {
                        SpaceTreeNode nextNode = this.nodes.get(i3 - 1);
                        currentNodeToMove = nextNode;
                        if (currentNodeToMove.positionInLayer < (newPositionForCurrent -= SpaceTreeLayoutAlgorithm.this.expectedDistance(currentNodeToMove, nextNode))) continue block0;
                    }
                    --i3;
                }
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Layer ").append(this.depth).append(": ");
            for (SpaceTreeNode node : this.nodes) {
                buffer.append(node.node).append(", ");
            }
            return buffer.toString();
        }

        private void collapseNode(SpaceTreeNode node) {
            node.expanded = false;
            SpaceTreeLayer layer = SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(node.depth + 1);
            layer.removeNodes(node.getChildren());
            for (SpaceTreeNode child : node.getChildren()) {
                if (!child.expanded) continue;
                this.collapseNode(child);
            }
        }
    }

    private class SpaceTreeNode
    extends TreeLayoutObserver.TreeNode {
        public SubgraphLayout subgraph;
        public boolean expanded;
        public double positionInLayer;

        public SpaceTreeNode(NodeLayout node, TreeLayoutObserver owner) {
            super(node, owner);
            this.subgraph = null;
            this.expanded = false;
        }

        @Override
        protected void addChild(TreeLayoutObserver.TreeNode child2) {
            super.addChild(child2);
            SpaceTreeNode child = (SpaceTreeNode)child2;
            child.expanded = false;
            child.setSubgraph(null);
            if (child.depth >= 0) {
                SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(child.depth).removeNode(child);
            }
            if (this.expanded) {
                SpaceTreeLayer childLayer;
                child.depth = this.depth + 1;
                if (child.depth < SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.size()) {
                    childLayer = SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(child.depth);
                } else {
                    childLayer = new SpaceTreeLayer(child.depth);
                    SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.add(childLayer);
                }
                child.order = childLayer.nodes.isEmpty() ? 0 : childLayer.nodes.get((int)(childLayer.nodes.size() - 1)).order + 1;
                childLayer.addNodes(Arrays.asList(child));
            }
        }

        @Override
        public void precomputeTree() {
            super.precomputeTree();
            if (this == this.owner.getSuperRoot()) {
                this.expanded = true;
                while (SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.size() <= this.height) {
                    SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.add(new SpaceTreeLayer(SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.size()));
                }
                if (SpaceTreeLayoutAlgorithm.this.treeObserver != null) {
                    SpaceTreeLayoutAlgorithm.this.refreshLayout(true);
                }
            }
        }

        public SubgraphLayout collapseAllChildrenIntoSubgraph(SubgraphLayout subgraph, boolean includeYourself) {
            this.expanded = false;
            ArrayList<NodeLayout> allChildren = new ArrayList<NodeLayout>();
            LinkedList<SpaceTreeNode> nodesToVisit = new LinkedList<SpaceTreeNode>();
            nodesToVisit.addLast(this);
            while (!nodesToVisit.isEmpty()) {
                SpaceTreeNode currentNode = (SpaceTreeNode)nodesToVisit.removeFirst();
                for (SpaceTreeNode child : currentNode.getChildren()) {
                    allChildren.add(child.node);
                    child.setSubgraph(null);
                    child.expanded = false;
                    nodesToVisit.addLast(child);
                }
            }
            if (includeYourself) {
                allChildren.add(this.node);
            }
            if (allChildren.isEmpty()) {
                this.setSubgraph(null);
                return null;
            }
            NodeLayout[] childrenArray = allChildren.toArray(new NodeLayout[allChildren.size()]);
            if (subgraph == null) {
                subgraph = SpaceTreeLayoutAlgorithm.this.context.createSubgraph(childrenArray);
                subgraph.setDirection(SpaceTreeLayoutAlgorithm.this.getSubgraphDirection());
            } else {
                subgraph.addNodes(childrenArray);
            }
            if (!includeYourself) {
                this.setSubgraph(subgraph);
            }
            return subgraph;
        }

        public void setSubgraph(SubgraphLayout subgraph) {
            if (this.subgraph != subgraph) {
                this.subgraph = subgraph;
                this.refreshSubgraphLocation();
            }
        }

        public void adjustPosition(DisplayIndependentPoint preferredLocation) {
            double newPositionInLayer;
            SpaceTreeLayoutAlgorithm.this.protectedNode = (SpaceTreeNode)this.owner.getSuperRoot();
            double d = newPositionInLayer = SpaceTreeLayoutAlgorithm.this.direction == 2 || SpaceTreeLayoutAlgorithm.this.direction == 1 ? preferredLocation.x : preferredLocation.y;
            if (this.getParent().expanded) {
                SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth).moveNode(this, newPositionInLayer);
                this.centerParentsTopDown();
            }
        }

        public void refreshSubgraphLocation() {
            if (this.subgraph != null && this.subgraph.isGraphEntity()) {
                DisplayIndependentPoint nodeLocation = this.node.getLocation();
                DisplayIndependentDimension nodeSize = this.node.getSize();
                DisplayIndependentDimension subgraphSize = this.subgraph.getSize();
                double x = 0.0;
                double y = 0.0;
                switch (SpaceTreeLayoutAlgorithm.this.direction) {
                    case 1: {
                        x = nodeLocation.x;
                        y = nodeLocation.y + (nodeSize.height + subgraphSize.height) / 2.0;
                        break;
                    }
                    case 2: {
                        x = nodeLocation.x;
                        y = nodeLocation.y - (nodeSize.height + subgraphSize.height) / 2.0;
                        break;
                    }
                    case 3: {
                        x = nodeLocation.x + (nodeSize.width + subgraphSize.width) / 2.0;
                        y = nodeLocation.y;
                        break;
                    }
                    case 4: {
                        x = nodeLocation.x - (nodeSize.width + subgraphSize.height) / 2.0;
                        y = nodeLocation.y;
                    }
                }
                this.subgraph.setLocation(x, y);
            }
            SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth).refreshThickness();
        }

        public double spaceRequiredForNode() {
            if (this.node == null) {
                return 0.0;
            }
            switch (SpaceTreeLayoutAlgorithm.this.direction) {
                case 1: 
                case 2: {
                    return this.node.getSize().width;
                }
                case 3: 
                case 4: {
                    return this.node.getSize().height;
                }
            }
            throw new RuntimeException("invalid direction");
        }

        public double spaceRequiredForChildren() {
            if (this.children.isEmpty()) {
                return 0.0;
            }
            double result = 0.0;
            for (SpaceTreeNode child : this.getChildren()) {
                result += child.spaceRequiredForNode();
            }
            return result += 15.0 * (double)(this.children.size() - 1);
        }

        public boolean childrenPositionsOK(List<SpaceTreeNode> nodesToCheck) {
            for (SpaceTreeNode node : nodesToCheck) {
                if (node.depth < 0 || node.children.isEmpty()) continue;
                SpaceTreeNode child = node.getChildren().get(0);
                if (child.positionInLayer > node.positionInLayer) {
                    SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(node.depth).moveNode(node, child.positionInLayer);
                    if (child.positionInLayer > node.positionInLayer) {
                        SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(child.depth).moveNode(child, node.positionInLayer);
                        if (child.positionInLayer > node.positionInLayer) {
                            return false;
                        }
                    }
                }
                child = node.getChildren().get(node.children.size() - 1);
                if (!(child.positionInLayer < node.positionInLayer)) continue;
                SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(node.depth).moveNode(node, child.positionInLayer);
                if (!(child.positionInLayer < node.positionInLayer)) continue;
                SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(child.depth).moveNode(child, node.positionInLayer);
                if (!(child.positionInLayer < node.positionInLayer)) continue;
                return false;
            }
            return true;
        }

        public void centerParentsBottomUp() {
            if (!this.children.isEmpty() && this.expanded) {
                for (SpaceTreeNode child : this.getChildren()) {
                    child.centerParentsBottomUp();
                }
                if (this.depth >= 0) {
                    SpaceTreeNode firstChild = this.getChildren().get(0);
                    SpaceTreeNode lastChild = this.getChildren().get(this.children.size() - 1);
                    SpaceTreeLayer layer = SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth);
                    layer.moveNode(this, (firstChild.positionInLayer + lastChild.positionInLayer) / 2.0);
                }
            }
        }

        public void centerParentsTopDown() {
            if (this == this.owner.getSuperRoot()) {
                this.positionInLayer = SpaceTreeLayoutAlgorithm.this.getAvailableSpace() / 2.0;
            }
            if (!this.children.isEmpty() && this.expanded) {
                SpaceTreeNode firstChild = this.getChildren().get(0);
                SpaceTreeNode lastChild = this.getChildren().get(this.children.size() - 1);
                double offset = this.positionInLayer - (firstChild.positionInLayer + lastChild.positionInLayer) / 2.0;
                if (firstChild.positionInLayer - firstChild.spaceRequiredForNode() / 2.0 + offset < 0.0) {
                    offset = -firstChild.positionInLayer + firstChild.spaceRequiredForNode() / 2.0;
                }
                double availableSpace = SpaceTreeLayoutAlgorithm.this.getAvailableSpace();
                if (lastChild.positionInLayer + lastChild.spaceRequiredForNode() / 2.0 + offset > availableSpace) {
                    offset = availableSpace - lastChild.positionInLayer - lastChild.spaceRequiredForNode() / 2.0;
                }
                SpaceTreeLayer layer = SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth + 1);
                layer.fitNodesWithinBounds(this.getChildren(), firstChild.positionInLayer + offset, lastChild.positionInLayer + offset);
                for (SpaceTreeNode child : this.getChildren()) {
                    child.centerParentsTopDown();
                }
            }
        }

        public void flushExpansionChanges() {
            if (this.node != null) {
                this.node.prune(null);
            }
            if (this.expanded) {
                this.setSubgraph(null);
                for (SpaceTreeNode child : this.getChildren()) {
                    child.flushExpansionChanges();
                }
            }
            if (!this.expanded && this.subgraph == null) {
                this.collapseAllChildrenIntoSubgraph(null, false);
            }
        }

        public boolean flushCollapseChanges() {
            if (!this.expanded) {
                int newNumberOfChildrenInSubgraph;
                int numberOfChildrenInSubgraph = this.subgraph == null ? 0 : this.subgraph.countNodes();
                this.collapseAllChildrenIntoSubgraph(this.subgraph, false);
                int n = newNumberOfChildrenInSubgraph = this.subgraph == null ? 0 : this.subgraph.countNodes();
                if (numberOfChildrenInSubgraph != newNumberOfChildrenInSubgraph && newNumberOfChildrenInSubgraph > 0) {
                    this.refreshSubgraphLocation();
                }
                return numberOfChildrenInSubgraph != newNumberOfChildrenInSubgraph;
            }
            if (this.expanded && this.subgraph == null) {
                boolean madeChagnes = false;
                for (SpaceTreeNode child : this.getChildren()) {
                    boolean bl = madeChagnes = child.flushCollapseChanges() || madeChagnes;
                }
                return madeChagnes;
            }
            return false;
        }

        public boolean flushLocationChanges(double thicknessSoFar) {
            boolean madeChanges = false;
            if (this.node != null) {
                DisplayIndependentDimension nodeSize = this.node.getSize();
                double x = 0.0;
                double y = 0.0;
                switch (SpaceTreeLayoutAlgorithm.this.direction) {
                    case 1: {
                        x = SpaceTreeLayoutAlgorithm.this.bounds.x + this.positionInLayer;
                        y = thicknessSoFar + nodeSize.height / 2.0;
                        break;
                    }
                    case 2: {
                        x = SpaceTreeLayoutAlgorithm.this.bounds.x + this.positionInLayer;
                        y = SpaceTreeLayoutAlgorithm.this.bounds.y + SpaceTreeLayoutAlgorithm.this.bounds.height - thicknessSoFar - nodeSize.height / 2.0;
                        break;
                    }
                    case 3: {
                        x = thicknessSoFar + nodeSize.height / 2.0;
                        y = SpaceTreeLayoutAlgorithm.this.bounds.y + this.positionInLayer;
                        break;
                    }
                    case 4: {
                        x = SpaceTreeLayoutAlgorithm.this.bounds.x + SpaceTreeLayoutAlgorithm.this.bounds.width - thicknessSoFar - nodeSize.height / 2.0;
                        y = SpaceTreeLayoutAlgorithm.this.bounds.y + this.positionInLayer;
                    }
                }
                DisplayIndependentPoint currentLocation = this.node.getLocation();
                if (currentLocation.x != x || currentLocation.y != y) {
                    this.node.setLocation(x, y);
                    this.refreshSubgraphLocation();
                    madeChanges = true;
                }
            }
            if (this.expanded && this.subgraph == null) {
                thicknessSoFar += (this.depth >= 0 ? SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get((int)this.depth).thickness : 0.0) + 20.0;
                for (SpaceTreeNode child : this.getChildren()) {
                    boolean bl = madeChanges = child.flushLocationChanges(thicknessSoFar) || madeChanges;
                }
            }
            return madeChanges;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.depth) {
                sb.append(" ");
                ++i;
            }
            if (this.node != null) {
                sb.append(this.node.toString());
            }
            sb.append("|" + this.order);
            sb.append('\n');
            for (SpaceTreeNode child : this.getChildren()) {
                sb.append(child.toString());
            }
            return sb.toString();
        }

        public List<SpaceTreeNode> getChildren() {
            return super.getChildren();
        }

        @Override
        public SpaceTreeNode getParent() {
            return (SpaceTreeNode)super.getParent();
        }
    }
}

