/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.SpanningTreeVisitor;

class TightSpanningTreeSolver
extends SpanningTreeVisitor {
    protected DirectedGraph graph;
    protected CandidateList candidates = new CandidateList();
    protected NodeList members = new NodeList();

    TightSpanningTreeSolver() {
    }

    @Override
    public void visit(DirectedGraph graph) {
        this.graph = graph;
        this.init();
        this.solve();
    }

    Node addEdge(Edge edge) {
        Node node;
        int delta = edge.getSlack();
        edge.tree = true;
        if (edge.target.flag) {
            delta = -delta;
            node = edge.source;
            this.setParentEdge(node, edge);
            this.getSpanningTreeChildren(edge.target).add(edge);
        } else {
            node = edge.target;
            this.setParentEdge(node, edge);
            this.getSpanningTreeChildren(edge.source).add(edge);
        }
        this.members.adjustRank(delta);
        this.addNode(node);
        return node;
    }

    private static boolean isNodeReachable(Node node) {
        return node.flag;
    }

    private static void setNodeReachable(Node node) {
        node.flag = true;
    }

    private static boolean isCandidate(Edge e) {
        return e.flag;
    }

    private static void setCandidate(Edge e) {
        e.flag = true;
    }

    void addNode(Node node) {
        TightSpanningTreeSolver.setNodeReachable(node);
        for (Edge e : node.incoming) {
            if (!TightSpanningTreeSolver.isNodeReachable(e.source)) {
                if (TightSpanningTreeSolver.isCandidate(e)) continue;
                TightSpanningTreeSolver.setCandidate(e);
                this.candidates.add(e);
                continue;
            }
            this.candidates.remove(e);
        }
        for (Edge e : node.outgoing) {
            if (!TightSpanningTreeSolver.isNodeReachable(e.target)) {
                if (TightSpanningTreeSolver.isCandidate(e)) continue;
                TightSpanningTreeSolver.setCandidate(e);
                this.candidates.add(e);
                continue;
            }
            this.candidates.remove(e);
        }
        this.members.add(node);
    }

    void init() {
        this.graph.edges.resetFlags(true);
        this.graph.nodes.resetFlags();
        for (Node node : this.graph.nodes) {
            node.workingData[0] = new EdgeList();
        }
    }

    protected void solve() {
        Node root = (Node)this.graph.nodes.get(0);
        this.setParentEdge(root, null);
        this.addNode(root);
        while (this.members.size() < this.graph.nodes.size()) {
            if (this.candidates.size() == 0) {
                throw new RuntimeException("graph is not fully connected");
            }
            int minSlack = Integer.MAX_VALUE;
            Edge minEdge = null;
            int i = 0;
            while (i < this.candidates.size() && minSlack > 0) {
                Edge edge = this.candidates.getEdge(i);
                int slack = edge.getSlack();
                if (slack < minSlack) {
                    minSlack = slack;
                    minEdge = edge;
                }
                ++i;
            }
            this.addEdge(minEdge);
        }
        this.graph.nodes.normalizeRanks();
    }

    static final class CandidateList {
        private Edge[] edges = new Edge[10];
        private int size;

        CandidateList() {
        }

        public void add(Edge edge) {
            if (this.size == this.edges.length - 1) {
                Edge[] newEdges = new Edge[this.edges.length * 2];
                System.arraycopy(this.edges, 0, newEdges, 0, this.edges.length);
                this.edges = newEdges;
            }
            this.edges[this.size++] = edge;
        }

        public Edge getEdge(int index) {
            return this.edges[index];
        }

        public void remove(Edge edge) {
            int i = 0;
            while (i < this.size) {
                if (this.edges[i] == edge) {
                    this.edges[i] = this.edges[this.size - 1];
                    --this.size;
                    return;
                }
                ++i;
            }
            throw new RuntimeException("Remove called on invalid Edge");
        }

        public int size() {
            return this.size;
        }
    }
}

