/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.gist;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.github.ui.gist.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentModel;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class GistAttachmentPage
extends WizardPage {
    private final TaskAttachmentMapper mapper;
    private final TaskAttachmentModel model;
    private Text nameText;

    protected GistAttachmentPage(TaskAttachmentModel model) {
        super("gistAttachmentPage");
        this.setTitle(Messages.GistAttachmentPage_Title);
        this.setDescription(Messages.GistAttachmentPage_Description);
        model.setAttachContext(false);
        this.mapper = TaskAttachmentMapper.createFrom((TaskAttribute)model.getAttribute());
        this.model = model;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(displayArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)displayArea);
        new Label(displayArea, 0).setText(Messages.GistAttachmentPage_LabelFile);
        this.nameText = new Text(displayArea, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nameText);
        this.nameText.addModifyListener(e -> this.updateFilename());
        Label binaryLabel = new Label(displayArea, 64);
        binaryLabel.setText(Messages.GistAttachmentPage_LabelBinaryWarning);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)binaryLabel);
        this.setControl((Control)displayArea);
    }

    private void updateFilename() {
        this.mapper.setFileName(this.nameText.getText().trim());
        this.mapper.applyTo(this.model.getAttribute());
        this.validate();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            String current = this.mapper.getFileName();
            if (current == null) {
                current = this.model.getSource().getName();
            }
            if (current != null) {
                this.nameText.setText(current);
            }
            this.nameText.selectAll();
            this.nameText.setFocus();
            this.updateFilename();
        }
    }

    private void validate() {
        this.setPageComplete(!"".equals(this.nameText.getText().trim()));
    }
}

