/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename.logic;

import org.eclipse.core.resources.IFile;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.refactoring.core.PHPRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.rename.logic.AbstractRename;

public class RenameFunction
extends AbstractRename {
    private static final String RENAME_FUNCTION = PHPRefactoringCoreMessages.getString("RenameFunctionName.0");

    public RenameFunction(IFile file, String oldName, String newName, boolean searchTextual) {
        super(file, oldName, newName, searchTextual);
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        Block body = methodDeclaration.getFunction().getBody();
        if (body != null) {
            body.accept((Visitor)this);
        }
        return false;
    }

    public boolean visit(FunctionDeclaration functionDeclaration) {
        assert (functionDeclaration.getParent().getType() != 42);
        if (this.oldName.equalsIgnoreCase(functionDeclaration.getFunctionName().getName())) {
            this.addChange(functionDeclaration.getFunctionName());
        }
        return true;
    }

    public boolean visit(FunctionInvocation functionInvocation) {
        Identifier identifier;
        Expression functionName = functionInvocation.getFunctionName().getName();
        int invocationParent = functionInvocation.getParent().getType();
        if (functionName instanceof Identifier && invocationParent != 43 && invocationParent != 53 && this.oldName.equalsIgnoreCase((identifier = (Identifier)functionName).getName())) {
            this.addChange(identifier);
        }
        return true;
    }

    @Override
    public String getRenameDescription() {
        return RENAME_FUNCTION;
    }
}

