/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.net4j.db.BatchedStatement;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.IDBConnectionProvider2;
import org.eclipse.net4j.db.IDBDatabase;
import org.eclipse.net4j.db.IDBRowHandler;
import org.eclipse.net4j.db.ddl.IDBElement;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBNamedElement;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.internal.db.BatchedStatementImpl;
import org.eclipse.net4j.internal.db.DBConnection;
import org.eclipse.net4j.internal.db.DBDatabase;
import org.eclipse.net4j.internal.db.DataSourceConnectionProvider;
import org.eclipse.net4j.internal.db.bundle.OM;
import org.eclipse.net4j.internal.db.ddl.DBIndex;
import org.eclipse.net4j.internal.db.ddl.DBNamedElement;
import org.eclipse.net4j.internal.db.ddl.DBSchema;
import org.eclipse.net4j.spi.db.DBAdapter;
import org.eclipse.net4j.spi.db.ddl.InternalDBIndex;
import org.eclipse.net4j.util.ConsumerWithException;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.IUserAware;

public final class DBUtil {
    public static final String QUOTE = "\"";
    public static final int MAX_BATCH_SIZE = OMPlatform.INSTANCE.getProperty("org.eclipse.net4j.db.MAX_BATCH_SIZE", 2000);
    public static final boolean DISABLE_QUOTED_NAMES = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.db.DISABLE_QUOTED_NAMES");
    public static final String PROP_ENABLE_NOISY_CLOSE = "org.eclipse.net4j.db.close.noisy";
    public static final String[] ALL_TABLE_NAME_TYPES = new String[]{"TABLE"};
    private static final boolean IS_NOISY_CLOSE_ENABLED = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.db.close.noisy");
    private static final String DEFAULT_SCOPE = OMPlatform.INSTANCE.getProperty("org.eclipse.net4j.db.DEFAULT_SCOPE", "org.eclipse.net4j.db.NAME");
    private static final boolean DEBUG = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.db.DEBUG");
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SQL, DBUtil.class);

    private DBUtil() {
    }

    public static String dumpToString(IDBNamedElement namedElement) {
        return ((DBNamedElement)namedElement).dumpToString();
    }

    public static void dump(IDBNamedElement namedElement) {
        ((DBNamedElement)namedElement).dump();
    }

    public static void dump(IDBNamedElement namedElement, Writer writer) throws IOException {
        ((DBNamedElement)namedElement).dump(writer);
    }

    public static IDBDatabase openDatabase(IDBAdapter adapter, IDBConnectionProvider connectionProvider, String schemaName) {
        return DBUtil.openDatabase(adapter, connectionProvider, schemaName, false);
    }

    public static IDBDatabase openDatabase(IDBAdapter adapter, IDBConnectionProvider connectionProvider, String schemaName, boolean fixNullableIndexColumns) {
        return DBUtil.openDatabase(adapter, connectionProvider, schemaName, fixNullableIndexColumns, false);
    }

    public static IDBDatabase openDatabase(IDBAdapter adapter, IDBConnectionProvider connectionProvider, String schemaName, boolean fixNullableIndexColumns, boolean qualifiedTableNames) {
        return new DBDatabase((DBAdapter)adapter, connectionProvider, schemaName, fixNullableIndexColumns, qualifiedTableNames);
    }

    public static IDBSchema createSchema(String name) {
        return DBUtil.createSchema(name, false, false);
    }

    public static IDBSchema createSchema(String name, boolean caseSensitive, boolean qualifiedTableNames) {
        return new DBSchema(name, caseSensitive, qualifiedTableNames);
    }

    public static void readSchema(IDBAdapter adapter, Connection connection, IDBSchema schema) {
        adapter.readSchema(connection, schema);
    }

    public static IDBSchema readSchema(IDBAdapter adapter, Connection connection, String name) {
        return DBUtil.readSchema(adapter, connection, name, false);
    }

    public static IDBSchema readSchema(IDBAdapter adapter, Connection connection, String name, boolean fixNullableIndexColumns) {
        return DBUtil.readSchema(adapter, connection, name, fixNullableIndexColumns, false);
    }

    public static IDBSchema readSchema(IDBAdapter adapter, Connection connection, String name, boolean fixNullableIndexColumns, boolean qualifiedTableNames) {
        boolean caseSensitive = adapter.isCaseSensitive();
        DBSchema schema = new DBSchema(name, caseSensitive, qualifiedTableNames);
        if (fixNullableIndexColumns) {
            DBIndex.FIX_NULLABLE_INDEX_COLUMNS.set(true);
        }
        try {
            DBUtil.readSchema(adapter, connection, schema);
        }
        finally {
            if (fixNullableIndexColumns) {
                try {
                    Set<IDBField> nullableIndexFields = DBIndex.NULLABLE_INDEX_FIELDS.get();
                    if (nullableIndexFields != null && !nullableIndexFields.isEmpty()) {
                        DBUtil.fixNullableIndexFields(adapter, connection, nullableIndexFields);
                    }
                }
                finally {
                    DBIndex.NULLABLE_INDEX_FIELDS.remove();
                    DBIndex.FIX_NULLABLE_INDEX_COLUMNS.remove();
                }
            }
        }
        return schema;
    }

    private static void fixNullableIndexFields(IDBAdapter adapter, Connection connection, Set<IDBField> nullableIndexFields) {
        StringBuilder builder = new StringBuilder();
        builder.append("The internal schema migration has fixed the following nullable index columns:");
        builder.append(StringUtil.NL);
        boolean oldAutoCommit = false;
        Statement statement = null;
        try {
            try {
                oldAutoCommit = DBUtil.setAutoCommit(connection, false);
                statement = connection.createStatement();
                for (IDBField field : nullableIndexFields) {
                    field.setNotNull(true);
                    String sql = adapter.sqlModifyField(field);
                    statement.execute(sql);
                    builder.append("- ");
                    builder.append(sql);
                    builder.append(StringUtil.NL);
                }
                connection.commit();
                OM.LOG.info(builder.toString());
            }
            catch (SQLException ex) {
                OM.LOG.error((Throwable)ex);
                DBUtil.rollbackSilently(connection);
                throw new DBException(ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(statement);
            DBUtil.setAutoCommit(connection, oldAutoCommit);
            throw throwable;
        }
        DBUtil.close(statement);
        DBUtil.setAutoCommit(connection, oldAutoCommit);
    }

    public static IDBSchema copySchema(IDBSchema source) {
        return new DBSchema(source);
    }

    public static DataSource createDataSource(Map<Object, Object> properties) {
        return DBUtil.createDataSource(properties, null);
    }

    public static DataSource createDataSource(Map<Object, Object> properties, String namespace) {
        return DBUtil.createDataSource(properties, namespace, "class");
    }

    public static DataSource createDataSource(Map<Object, Object> properties, String namespace, String driverClassKey) {
        try {
            return (DataSource)ReflectUtil.instantiate(properties, (String)namespace, (String)driverClassKey, (ClassLoader)OM.class.getClassLoader());
        }
        catch (Exception ex) {
            throw new DBException(ex);
        }
    }

    public static IDBConnectionProvider createConnectionProvider(DataSource dataSource) {
        return DBUtil.createConnectionProvider(dataSource, null);
    }

    public static IDBConnectionProvider2 createConnectionProvider(DataSource dataSource, String user) {
        return new DataSourceConnectionProvider(dataSource, user);
    }

    public static IDBAdapter getDBAdapter(String adapterName) {
        return (IDBAdapter)IDBAdapter.REGISTRY.get((Object)adapterName);
    }

    public static BatchedStatement batched(PreparedStatement delegate, int batchSize) throws DBException {
        return new BatchedStatementImpl(delegate, batchSize);
    }

    public static Exception close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                Statement statement = resultSet.getStatement();
                if (statement != null && statement.getMaxRows() != 0) {
                    statement.setMaxRows(0);
                }
            }
            catch (Exception statement) {
                // empty catch block
            }
            try {
                resultSet.close();
            }
            catch (Exception ex) {
                if (IS_NOISY_CLOSE_ENABLED) {
                    throw new DBException(ex);
                }
                OM.LOG.error((Throwable)ex);
                return ex;
            }
        }
        return null;
    }

    public static Exception close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception ex) {
                if (IS_NOISY_CLOSE_ENABLED) {
                    throw new DBException(ex);
                }
                OM.LOG.error((Throwable)ex);
                return ex;
            }
        }
        return null;
    }

    public static Exception close(Connection connection) {
        if (connection != null) {
            try {
                if (!connection.getAutoCommit()) {
                    DBUtil.rollbackSilently(connection);
                }
                connection.close();
            }
            catch (Exception ex) {
                if (IS_NOISY_CLOSE_ENABLED) {
                    throw new DBException(ex);
                }
                OM.LOG.error((Throwable)ex);
                return ex;
            }
        }
        return null;
    }

    public static boolean isOptional(IDBElement element) {
        if (element instanceof InternalDBIndex) {
            InternalDBIndex index = (InternalDBIndex)element;
            return index.isOptional();
        }
        return false;
    }

    public static boolean setOptional(IDBElement element, boolean optional) {
        if (element instanceof InternalDBIndex) {
            InternalDBIndex index = (InternalDBIndex)element;
            index.setOptional(optional);
            return true;
        }
        return false;
    }

    public static boolean setAutoCommit(Connection connection, boolean autoCommit) {
        try {
            if (connection.getAutoCommit() != autoCommit) {
                connection.setAutoCommit(autoCommit);
                return !autoCommit;
            }
            return autoCommit;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static Exception rollbackSilently(Connection connection) {
        try {
            if (!connection.getAutoCommit()) {
                connection.rollback();
            }
            return null;
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
            return ex;
        }
    }

    public static String quoted(String name) {
        if (name != null && !DISABLE_QUOTED_NAMES) {
            name = QUOTE + name + QUOTE;
        }
        return name;
    }

    public static String name(String name, String scope) {
        if (name != null) {
            String property;
            String overrideName;
            if (scope == null) {
                scope = DEFAULT_SCOPE;
            }
            if ((overrideName = OMPlatform.INSTANCE.getProperty(property = scope.length() == 0 ? name : String.valueOf(scope) + '.' + name)) != null) {
                name = overrideName;
            }
        }
        return name;
    }

    public static String name(String name, Class<?> scope) {
        return DBUtil.name(name, scope.getName().replace('$', '.'));
    }

    public static String name(String name) {
        return DBUtil.name(name, null);
    }

    public static boolean equalNames(String name1, String name2, boolean caseSensitive) {
        if (caseSensitive || name1 == null) {
            return Objects.equals(name1, name2);
        }
        return name1.equalsIgnoreCase(name2);
    }

    public static boolean containsName(Set<String> names, String name, boolean caseSensitive) {
        if (caseSensitive || name == null) {
            return names.contains(name);
        }
        for (String n : names) {
            if (!name.equalsIgnoreCase(n)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getAllSchemaNames(Connection connection) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            return new ArrayList<String>(DBUtil.getAllSchemaNames(metaData));
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static Set<String> getAllSchemaNames(DatabaseMetaData metaData) {
        HashSet<String> hashSet;
        ResultSet schemas = null;
        try {
            HashSet<String> names = new HashSet<String>();
            String catalog = metaData.getConnection().getCatalog();
            try {
                schemas = metaData.getSchemas(catalog, null);
            }
            catch (AbstractMethodError ex) {
                schemas = metaData.getSchemas();
            }
            while (schemas.next()) {
                String name = schemas.getString(1);
                names.add(name);
            }
            hashSet = names;
        }
        catch (SQLException ex) {
            try {
                throw new DBException(ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(schemas);
                throw throwable;
            }
        }
        DBUtil.close(schemas);
        return hashSet;
    }

    public static List<String> getAllTableNames(Connection connection, String schemaName) {
        return DBUtil.getAllTableNames(connection, schemaName, false);
    }

    public static List<String> getAllTableNames(Connection connection, String schemaName, boolean caseSensitive) {
        ArrayList<String> names = new ArrayList<String>();
        DBUtil.forEachTable(connection, schemaName, caseSensitive, (ConsumerWithException<String, SQLException>)((ConsumerWithException)names::add));
        return names;
    }

    public static void forEachTable(Connection connection, String schemaName, boolean caseSensitive, ConsumerWithException<String, SQLException> tableNameConsumer) {
        if (schemaName == null && connection instanceof IUserAware) {
            schemaName = ((IUserAware)connection).getUserID();
        }
        ResultSet tables = null;
        try {
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                String catalog = connection.getCatalog();
                tables = metaData.getTables(catalog, null, null, ALL_TABLE_NAME_TYPES);
                while (tables.next()) {
                    String tableSchemaName;
                    if (schemaName != null && !DBUtil.equalNames(tableSchemaName = tables.getString(2), schemaName, caseSensitive)) continue;
                    String name = tables.getString(3);
                    tableNameConsumer.accept((Object)name);
                }
            }
            catch (SQLException ex) {
                throw new DBException(ex);
            }
        }
        catch (Throwable throwable) {
            DBUtil.close(tables);
            throw throwable;
        }
        DBUtil.close(tables);
    }

    public static List<Exception> dropAllTables(Connection connection, String schemaName) {
        return DBUtil.dropAllTables(connection, schemaName, false);
    }

    public static List<Exception> dropAllTables(Connection connection, String schemaName, boolean caseSensitive) {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ArrayList<Exception> exceptions = new ArrayList<Exception>();
            for (String tableName : DBUtil.getAllTableNames(connection, schemaName, caseSensitive)) {
                String sql = DBUtil.trace("DROP TABLE " + DBUtil.quoted(tableName));
                try {
                    statement.execute(sql);
                }
                catch (SQLException ex) {
                    exceptions.add(ex);
                }
            }
            ArrayList<Exception> arrayList = exceptions;
            return arrayList;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
        finally {
            DBUtil.close(statement);
        }
    }

    public static int asInt(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return 0;
    }

    public static long asLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return 0L;
    }

    public static int selectMinimumInt(Connection connection, IDBField field, String ... where) throws DBException {
        Number number = DBUtil.getFunctionResult(connection, field, "MIN", where);
        return DBUtil.asInt(number);
    }

    public static long selectMinimumLong(Connection connection, IDBField field, String ... where) throws DBException {
        Number number = DBUtil.getFunctionResult(connection, field, "MIN", where);
        return DBUtil.asLong(number);
    }

    public static int selectMaximumInt(Connection connection, IDBField field, String ... where) throws DBException {
        Number number = DBUtil.getFunctionResult(connection, field, "MAX", where);
        return DBUtil.asInt(number);
    }

    public static long selectMaximumLong(Connection connection, IDBField field, String ... where) throws DBException {
        Number number = DBUtil.getFunctionResult(connection, field, "MAX", where);
        return DBUtil.asLong(number);
    }

    /*
     * Exception decompiling
     */
    private static Number getFunctionResult(Connection connection, IDBField field, String function, String ... where) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> T execute(IDBConnectionProvider connectionProvider, RunnableWithConnection<T> runnable) {
        Connection connection = null;
        try {
            connection = connectionProvider.getConnection();
            T result = runnable.run(connection);
            connection.commit();
            T t = result;
            return t;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
        finally {
            DBUtil.close(connection);
        }
    }

    public static void execute(Connection connection, CharSequence sql) {
        String string = DBUtil.trace(sql.toString());
        Statement statement = null;
        try {
            try {
                statement = connection.createStatement();
                statement.execute(string);
            }
            catch (SQLException ex) {
                throw new DBException(String.valueOf(ex.getMessage()) + " --> " + sql, ex);
            }
        }
        finally {
            DBUtil.close(statement);
        }
    }

    public static void executeBatch(PreparedStatement stmt, int counter) {
        DBUtil.executeBatch(stmt, counter, true);
    }

    public static void executeBatch(PreparedStatement stmt, int counter, boolean checkExactlyOne) {
        try {
            try {
                int[] results = stmt.executeBatch();
                if (results.length != counter) {
                    throw new DBException("Statement has " + results.length + " results (expected: " + counter + ")");
                }
                int i = 0;
                while (i < results.length) {
                    int result = results[i];
                    if (result != -2) {
                        if (result < 0) {
                            throw new DBException("Result " + i + " is not successful: " + result);
                        }
                        if (checkExactlyOne && result != 1) {
                            throw new DBException("Result " + i + " did not affect exactly one row: " + result);
                        }
                    }
                    ++i;
                }
            }
            catch (SQLException ex) {
                throw new DBException(ex);
            }
        }
        finally {
            try {
                stmt.clearBatch();
            }
            catch (SQLException ex) {
                OM.LOG.warn((Throwable)ex);
            }
        }
    }

    public static int update(Connection connection, String sql) {
        DBUtil.trace(sql);
        Statement statement = null;
        try {
            statement = connection.createStatement();
            int n = statement.executeUpdate(sql);
            return n;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
        finally {
            DBUtil.close(statement);
        }
    }

    public static int update(PreparedStatement stmt, boolean exactlyOne) throws SQLException {
        if (DBUtil.isTracerEnabled()) {
            TRACER.trace(stmt.toString());
        }
        int result = stmt.executeUpdate();
        if (exactlyOne && result != 1) {
            throw new IllegalStateException(String.valueOf(stmt.toString()) + " returned Update count " + result + " (expected: 1)");
        }
        if (result == -3) {
            throw new IllegalStateException(String.valueOf(stmt.toString()) + " returned EXECUTE_FAILED");
        }
        return result;
    }

    public static int clearTable(Connection connection, IDBTable table) {
        return DBUtil.clearTable(connection, table.getName());
    }

    public static int clearTable(Connection connection, String tableName) {
        String sql = "DELETE FROM " + DBUtil.quoted(tableName);
        return DBUtil.update(connection, sql);
    }

    public static int select(Connection connection, IDBRowHandler rowHandler, String where, IDBField ... fields) throws DBException {
        IDBTable table = fields[0].getTable();
        int i = 1;
        while (i < fields.length) {
            if (fields[i].getTable() != table) {
                throw new IllegalArgumentException("Multiple tables not allowed: " + Arrays.asList(fields));
            }
            ++i;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        int i2 = 0;
        while (i2 < fields.length) {
            if (i2 > 0) {
                builder.append(", ");
            }
            builder.append(fields[i2]);
            ++i2;
        }
        builder.append(" FROM ");
        builder.append(table);
        if (!StringUtil.isEmpty((String)where)) {
            builder.append(" WHERE ");
            builder.append(where);
        }
        String sql = DBUtil.trace(builder.toString());
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            int n;
            statement = connection.createStatement();
            try {
                int rows = 0;
                boolean proceed = true;
                Object[] values = new Object[fields.length];
                resultSet = statement.executeQuery(sql);
                while (proceed && resultSet.next()) {
                    int i3 = 0;
                    while (i3 < fields.length) {
                        long length;
                        values[i3] = resultSet.getObject(i3 + 1);
                        if (values[i3] instanceof Blob) {
                            Blob blob = (Blob)values[i3];
                            length = blob.length();
                            if (length > Integer.MAX_VALUE) {
                                throw new IllegalStateException("byte[] too long: " + length);
                            }
                            values[i3] = blob.getBytes(1L, (int)length);
                        } else if (values[i3] instanceof Clob) {
                            Clob clob = (Clob)values[i3];
                            length = clob.length();
                            if (length > Integer.MAX_VALUE) {
                                throw new IllegalStateException("String too long: " + length);
                            }
                            values[i3] = clob.getSubString(1L, (int)length);
                        }
                        ++i3;
                    }
                    proceed = rowHandler.handle(rows++, values);
                }
                n = rows;
            }
            catch (SQLException ex) {
                try {
                    try {
                        throw new DBException(ex);
                    }
                    catch (Throwable throwable) {
                        DBUtil.close(resultSet);
                        throw throwable;
                    }
                }
                catch (SQLException ex2) {
                    throw new DBException(ex2);
                }
            }
            DBUtil.close(resultSet);
            return n;
        }
        finally {
            DBUtil.close(statement);
        }
    }

    public static int select(Connection connection, IDBRowHandler rowHandler, IDBField ... fields) throws DBException {
        return DBUtil.select(connection, rowHandler, null, fields);
    }

    public static Object[] select(Connection connection, String where, IDBField ... fields) throws DBException {
        final Object[][] result = new Object[1][];
        IDBRowHandler rowHandler = new IDBRowHandler(){

            @Override
            public boolean handle(int row, Object ... values) {
                result[0] = values;
                return false;
            }
        };
        DBUtil.select(connection, rowHandler, where, fields);
        return result[0];
    }

    public static int getRowCount(ResultSet resultSet) throws DBException {
        DBUtil.reset(resultSet);
        try {
            resultSet.last();
            int n = resultSet.getRow();
            return n;
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
        finally {
            DBUtil.reset(resultSet);
        }
    }

    /*
     * Exception decompiling
     */
    public static int getRowCount(Connection connection, String tableName) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void reset(ResultSet resultSet) throws DBException {
        try {
            resultSet.beforeFirst();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }

    public static void serializeTable(ExtendedDataOutput out, Connection connection, IDBTable table, String tableAlias, String sqlSuffix) throws DBException, IOException {
        DBUtil.serializeTable(out, connection, table, tableAlias, sqlSuffix, null);
    }

    public static void serializeTable(ExtendedDataOutput out, Connection connection, IDBTable table, String tableAlias, String sqlSuffix, SerializeRowHandler handler) throws DBException, IOException {
        IDBField[] fields = table.getFields();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        int i = 0;
        while (i < fields.length) {
            if (i > 0) {
                builder.append(", ");
            }
            if (tableAlias != null) {
                builder.append(tableAlias);
                builder.append(".");
            }
            builder.append(fields[i]);
            ++i;
        }
        builder.append(" FROM ");
        builder.append(table);
        if (tableAlias != null) {
            builder.append(" ");
            builder.append(tableAlias);
        }
        if (sqlSuffix != null) {
            builder.append(sqlSuffix);
        }
        String sql = DBUtil.trace(builder.toString());
        Statement statement = null;
        ResultSet resultSet = null;
        boolean successful = false;
        try {
            block34: {
                statement = connection.createStatement(1004, 1007);
                resultSet = statement.executeQuery(sql);
                int size = DBUtil.getRowCount(resultSet);
                out.writeInt(size);
                if (size != 0) break block34;
                DBUtil.close(resultSet);
                return;
            }
            try {
                try {
                    try {
                        Object[] values = handler != null ? new Object[fields.length] : null;
                        while (resultSet.next()) {
                            int i2 = 0;
                            while (i2 < fields.length) {
                                IDBField field = fields[i2];
                                DBType type = field.getType();
                                boolean canBeNull = !field.isNotNull();
                                Object value = type.writeValueWithResult(out, resultSet, i2 + 1, canBeNull);
                                if (values != null) {
                                    values[i2] = value;
                                }
                                ++i2;
                            }
                            if (handler == null) continue;
                            handler.handleRow(out, connection, fields, values);
                        }
                        successful = true;
                    }
                    catch (SQLException ex) {
                        throw new DBException(ex);
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    DBUtil.close(resultSet);
                }
            }
            catch (SQLException ex) {
                throw new DBException(ex);
            }
        }
        finally {
            try {
                try {
                    if (handler != null) {
                        handler.done(successful);
                    }
                }
                catch (SQLException ex) {
                    throw new DBException(ex);
                }
            }
            finally {
                DBUtil.close(statement);
            }
        }
    }

    public static void deserializeTable(ExtendedDataInput in, Connection connection, IDBTable table, OMMonitor monitor) throws IOException {
        DBUtil.deserializeTable(in, connection, table, monitor, null);
    }

    public static void deserializeTable(ExtendedDataInput in, Connection connection, IDBTable table, OMMonitor monitor, DeserializeRowHandler handler) throws IOException {
        int size = in.readInt();
        if (size == 0) {
            return;
        }
        IDBField[] fields = table.getFields();
        StringBuilder builder = new StringBuilder();
        StringBuilder params = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(table);
        builder.append("(");
        int i = 0;
        while (i < fields.length) {
            if (i > 0) {
                builder.append(", ");
                params.append(", ");
            }
            builder.append(fields[i]);
            params.append("?");
            ++i;
        }
        builder.append(") VALUES (");
        builder.append(params.toString());
        builder.append(")");
        String sql = DBUtil.trace(builder.toString());
        PreparedStatement statement = null;
        boolean successful = false;
        monitor.begin((double)(1 + 2 * size));
        try {
            try {
                statement = connection.prepareStatement(sql);
                monitor.worked();
                Object[] values = handler != null ? new Object[fields.length] : null;
                int batchSize = 0;
                int row = 0;
                while (row < size) {
                    int i2 = 0;
                    while (i2 < fields.length) {
                        IDBField field = fields[i2];
                        DBType type = field.getType();
                        boolean canBeNull = !field.isNotNull();
                        Object value = type.readValueWithResult(in, statement, i2 + 1, canBeNull);
                        if (values != null) {
                            values[i2] = value;
                        }
                        ++i2;
                    }
                    statement.addBatch();
                    if (handler != null) {
                        handler.handleRow(in, connection, fields, values);
                    }
                    monitor.worked();
                    if (++batchSize == MAX_BATCH_SIZE) {
                        DBUtil.executeBatch(statement, batchSize, monitor);
                        batchSize = 0;
                    }
                    ++row;
                }
                if (batchSize != 0) {
                    DBUtil.executeBatch(statement, batchSize, monitor);
                }
                successful = true;
            }
            catch (SQLException ex) {
                throw new DBException(ex);
            }
        }
        finally {
            try {
                try {
                    if (handler != null) {
                        handler.done(successful);
                    }
                }
                catch (SQLException ex) {
                    throw new DBException(ex);
                }
            }
            finally {
                DBUtil.close(statement);
                monitor.done();
            }
        }
    }

    private static void executeBatch(PreparedStatement statement, int batchSize, OMMonitor monitor) throws SQLException {
        OMMonitor.Async async = monitor.forkAsync((double)batchSize);
        try {
            statement.executeBatch();
        }
        finally {
            async.stop();
        }
    }

    public static String trace(String sql) {
        if (DBUtil.isTracerEnabled()) {
            TRACER.trace(sql);
        }
        return sql;
    }

    public static boolean isTracerEnabled() {
        return DEBUG || TRACER.isEnabled();
    }

    @Deprecated
    private static void avoidResourceLeakWarning() throws SQLException {
        DBConnection connection = new DBConnection(null, null);
        Statement statement = connection.createStatement();
        DBUtil.close(statement);
    }

    @Deprecated
    public static void sqlDump(Connection conn, String sql) {
        block10: {
            ResultSet rs = null;
            try {
                try {
                    TRACER.format("Dumping output of {0}", new Object[]{sql});
                    rs = conn.createStatement().executeQuery(sql);
                    int numCol = rs.getMetaData().getColumnCount();
                    StringBuilder row = new StringBuilder();
                    int c = 1;
                    while (c <= numCol) {
                        row.append(String.format("%10s | ", rs.getMetaData().getColumnLabel(c)));
                        ++c;
                    }
                    TRACER.trace(row.toString());
                    row = new StringBuilder();
                    c = 1;
                    while (c <= numCol) {
                        row.append("-----------+--");
                        ++c;
                    }
                    TRACER.trace(row.toString());
                    while (rs.next()) {
                        row = new StringBuilder();
                        c = 1;
                        while (c <= numCol) {
                            row.append(String.format("%10s | ", rs.getString(c)));
                            ++c;
                        }
                        TRACER.trace(row.toString());
                    }
                    row = new StringBuilder();
                    c = 1;
                    while (c <= numCol) {
                        row.append("-----------+-");
                        ++c;
                    }
                    TRACER.trace(row.toString());
                }
                catch (SQLException sQLException) {
                    DBUtil.close(rs);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(rs);
                throw throwable;
            }
            DBUtil.close(rs);
        }
    }

    @Deprecated
    public static void sqlDump(IDBConnectionProvider connectionProvider, String sql) {
        Connection connection = connectionProvider.getConnection();
        try {
            DBUtil.sqlDump(connection, sql);
        }
        finally {
            DBUtil.close(connection);
        }
    }

    @Deprecated
    public static List<String> getAllSchemaTableNames(Connection connection) {
        return DBUtil.getAllSchemaNames(connection);
    }

    @Deprecated
    public static List<String> getAllSchemaTableNames(DatabaseMetaData metaData) {
        return new ArrayList<String>(DBUtil.getAllSchemaNames(metaData));
    }

    public static interface DeserializeRowHandler
    extends RowHandler {
        public void handleRow(ExtendedDataInput var1, Connection var2, IDBField[] var3, Object[] var4) throws SQLException, IOException;
    }

    @FunctionalInterface
    public static interface RowHandler {
        public void done(boolean var1) throws SQLException, IOException;
    }

    @FunctionalInterface
    public static interface RunnableWithConnection<T> {
        public T run(Connection var1) throws SQLException;
    }

    public static interface SerializeRowHandler
    extends RowHandler {
        public void handleRow(ExtendedDataOutput var1, Connection var2, IDBField[] var3, Object[] var4) throws SQLException, IOException;
    }
}

