/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.base;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.emf.common.EMFPlugin;

public final class I18N {
    private I18N() {
    }

    public static void initializeMessages(final Class<?> messagesClass, final EMFPlugin plugin) {
        if (System.getSecurityManager() == null) {
            I18N.load(plugin, messagesClass);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                I18N.load(plugin, messagesClass);
                return null;
            }
        });
    }

    private static void load(EMFPlugin plugin, Class<?> messagesClass) {
        Field[] fieldArray = messagesClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (I18N.isMessageField(field)) {
                I18N.initialize(field, plugin);
            }
            ++n2;
        }
    }

    private static boolean isMessageField(Field field) {
        boolean modsOK;
        int mods = field.getModifiers();
        boolean bl = modsOK = Modifier.isPublic(mods) && Modifier.isStatic(mods) && !Modifier.isFinal(mods);
        return modsOK && field.isAnnotationPresent(TranslatableMessage.class) && field.getType() == String.class;
    }

    private static void initialize(Field field, EMFPlugin plugin) {
        String key = I18N.getKey(field);
        String value = plugin.getString(key);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            field.set(null, value);
        }
        catch (IllegalArgumentException e) {
            plugin.log((Object)e);
        }
        catch (IllegalAccessException e) {
            plugin.log((Object)e);
        }
    }

    private static String getKey(Field field) {
        TranslatableMessage annot = field.getAnnotation(TranslatableMessage.class);
        String[] key = annot.value();
        if (key == null || key.length == 0) {
            key = new String[]{field.getName()};
        }
        return key[0];
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface TranslatableMessage {
        public String[] value() default {};
    }
}

