/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.artifact.resolve.internal;

import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.artifact.resolve.internal.Invoker;
import org.apache.maven.shared.transfer.artifact.resolve.internal.Maven31ArtifactResult;
import org.apache.maven.shared.transfer.artifact.resolve.internal.MavenArtifactResolver;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;

class Maven31ArtifactResolver
implements MavenArtifactResolver {
    private final RepositorySystem repositorySystem;
    private final List<RemoteRepository> aetherRepositories;
    private final RepositorySystemSession session;

    Maven31ArtifactResolver(RepositorySystem repositorySystem, List<RemoteRepository> aetherRepositories, RepositorySystemSession session) {
        this.repositorySystem = repositorySystem;
        this.aetherRepositories = aetherRepositories;
        this.session = session;
    }

    @Override
    public ArtifactResult resolveArtifact(org.apache.maven.artifact.Artifact mavenArtifact) throws ArtifactResolverException {
        Artifact aetherArtifact = (Artifact)Invoker.invoke(RepositoryUtils.class, "toArtifact", org.apache.maven.artifact.Artifact.class, mavenArtifact);
        return this.resolveArtifact(aetherArtifact);
    }

    @Override
    public ArtifactResult resolveArtifact(ArtifactCoordinate coordinate) throws ArtifactResolverException {
        DefaultArtifact aetherArtifact = new DefaultArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getClassifier(), coordinate.getExtension(), coordinate.getVersion());
        return this.resolveArtifact((Artifact)aetherArtifact);
    }

    private ArtifactResult resolveArtifact(Artifact aetherArtifact) throws ArtifactResolverException {
        try {
            ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest(aetherArtifact, this.aetherRepositories, null);
            ArtifactDescriptorResult descriptorResult = this.repositorySystem.readArtifactDescriptor(this.session, descriptorRequest);
            ArtifactRequest request = new ArtifactRequest(descriptorResult.getArtifact(), this.aetherRepositories, null);
            return new Maven31ArtifactResult(this.repositorySystem.resolveArtifact(this.session, request));
        }
        catch (ArtifactDescriptorException | ArtifactResolutionException e) {
            throw new ArtifactResolverException(e.getMessage(), (Exception)e);
        }
    }
}

