/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.actions.ITeamRunnableContext;
import org.eclipse.ui.IWorkbenchSite;

public class JobRunnableContext
implements ITeamRunnableContext {
    private final IJobChangeListener listener;
    private final IWorkbenchSite site;
    private final String jobName;
    private ISchedulingRule schedulingRule;
    private boolean postponeBuild;

    public JobRunnableContext(String jobName, IJobChangeListener listener, IWorkbenchSite site) {
        this.jobName = jobName;
        this.listener = listener;
        this.site = site;
    }

    @Override
    public void run(IRunnableWithProgress runnable) {
        IContextJob job = this.schedulingRule == null && !this.postponeBuild ? new BasicJob(this.jobName, runnable) : new ResourceJob(this.jobName, runnable);
        if (this.listener != null) {
            job.addJobChangeListener(this.listener);
        }
        this.configureJob((Job)job);
        Utils.schedule((Job)job, this.site);
    }

    protected void configureJob(Job job) {
        if (this.schedulingRule != null) {
            job.setRule(this.schedulingRule);
        }
        job.setUser(this.isUser());
    }

    public void setPostponeBuild(boolean postponeBuild) {
        this.postponeBuild = postponeBuild;
    }

    protected boolean isUser() {
        return true;
    }

    public void setSchedulingRule(ISchedulingRule schedulingRule) {
        this.schedulingRule = schedulingRule;
    }

    IStatus run(IRunnableWithProgress runnable, IProgressMonitor monitor) {
        try {
            runnable.run(monitor);
        }
        catch (InvocationTargetException e) {
            return TeamException.asTeamException((InvocationTargetException)e).getStatus();
        }
        catch (InterruptedException e) {
            return Status.CANCEL_STATUS;
        }
        return this.getCompletionStatus();
    }

    protected IStatus getCompletionStatus() {
        return Status.OK_STATUS;
    }

    protected boolean belongsTo(IContextJob job, Object family) {
        return false;
    }

    private class BasicJob
    extends Job
    implements IContextJob {
        private final IRunnableWithProgress runnable;

        public BasicJob(String name, IRunnableWithProgress runnable) {
            super(name);
            this.runnable = runnable;
        }

        public IStatus run(IProgressMonitor monitor) {
            return JobRunnableContext.this.run(this.runnable, monitor);
        }

        public boolean belongsTo(Object family) {
            return JobRunnableContext.this.belongsTo(this, family);
        }

        @Override
        public IRunnableWithProgress getRunnable() {
            return this.runnable;
        }
    }

    public static interface IContextJob {
        public IRunnableWithProgress getRunnable();
    }

    private class ResourceJob
    extends WorkspaceJob
    implements IContextJob {
        private final IRunnableWithProgress runnable;

        public ResourceJob(String name, IRunnableWithProgress runnable) {
            super(name);
            this.runnable = runnable;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            return JobRunnableContext.this.run(this.runnable, monitor);
        }

        public boolean belongsTo(Object family) {
            return JobRunnableContext.this.belongsTo(this, family);
        }

        @Override
        public IRunnableWithProgress getRunnable() {
            return this.runnable;
        }
    }
}

