/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.nekohtml.sax;

public class HTMLStringBuffer {
    public char[] ch;
    public int offset;
    public int length;

    public HTMLStringBuffer() {
        this(128);
    }

    public HTMLStringBuffer(int size) {
        this.ch = new char[size];
        this.offset = 0;
        this.length = 0;
    }

    public HTMLStringBuffer(String s) {
        this(s.length());
        this.append(s);
    }

    public HTMLStringBuffer(char[] ch, int offset, int length) {
        this(length);
        this.append(ch, offset, length);
    }

    public void clear() {
        this.offset = 0;
        this.length = 0;
    }

    public void append(char c) {
        this.ensureCapacity(this.length + 1);
        this.ch[this.offset + this.length] = c;
        ++this.length;
    }

    public void append(String s) {
        if (s != null && s.length() > 0) {
            int slen = s.length();
            this.ensureCapacity(this.length + slen);
            s.getChars(0, slen, this.ch, this.offset + this.length);
            this.length += slen;
        }
    }

    public void append(char[] ch, int offset, int length) {
        if (length > 0) {
            this.ensureCapacity(this.length + length);
            System.arraycopy(ch, offset, this.ch, this.offset + this.length, length);
            this.length += length;
        }
    }

    public void append(HTMLStringBuffer s) {
        this.append(s.ch, s.offset, s.length);
    }

    private void ensureCapacity(int newLength) {
        if (this.offset + newLength > this.ch.length) {
            int newSize = this.ch.length * 2;
            if (newSize < this.offset + newLength) {
                newSize = this.offset + newLength;
            }
            char[] newch = new char[newSize];
            System.arraycopy(this.ch, this.offset, newch, 0, this.length);
            this.ch = newch;
            this.offset = 0;
        }
    }

    public String toString() {
        return this.length > 0 ? new String(this.ch, this.offset, this.length) : "";
    }

    public Object[] toSAXCharacters() {
        return new Object[]{this.ch, this.offset, this.length};
    }
}

