/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class DataDrivenValueEventField
extends DataDrivenValue {
    private final String fFieldName;

    public DataDrivenValueEventField(@Nullable String mappingGroupId, ITmfStateValue.Type forcedType, String fieldName) {
        super(mappingGroupId, forcedType);
        this.fFieldName = fieldName;
    }

    @Override
    protected @Nullable Object resolveValue(int baseQuark, IAnalysisDataContainer container) {
        throw new IllegalArgumentException("Event field state value should only be called with an event");
    }

    @Override
    protected @Nullable Object resolveValue(ITmfEvent event, int baseQuark, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
        ITmfEventField field = event.getContent().getField(new String[]{this.fFieldName});
        Object fieldValue = null;
        if (field == null) {
            ITmfEventField splitFieldName = event.getContent().getField(this.fFieldName.split("\\."));
            if (splitFieldName != null) {
                fieldValue = splitFieldName.getValue();
                if (fieldValue != null) {
                    return fieldValue;
                }
            } else if (this.fFieldName.equalsIgnoreCase("cpu")) {
                Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
                if (cpu != null) {
                    return cpu;
                }
            } else {
                if (this.fFieldName.equalsIgnoreCase("timestamp")) {
                    return event.getTimestamp().getValue();
                }
                if (this.fFieldName.equalsIgnoreCase("hostId")) {
                    return event.getTrace().getHostId();
                }
            }
            fieldValue = TmfTraceUtils.resolveAspectOfNameForEvent((ITmfTrace)event.getTrace(), (String)this.fFieldName, (ITmfEvent)event);
        } else {
            fieldValue = field.getValue();
        }
        return fieldValue;
    }

    @Override
    public String toString() {
        return "DataDrivenValueEventField: " + this.fFieldName;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fFieldName);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DataDrivenValueEventField)) {
            return false;
        }
        DataDrivenValueEventField other = (DataDrivenValueEventField)obj;
        return Objects.equals(this.fFieldName, other.fFieldName);
    }
}

