/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.breakpoints;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint2;
import org.eclipse.cdt.debug.core.model.ICDynamicPrintf;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint2;
import org.eclipse.cdt.debug.core.model.ICTracepoint;
import org.eclipse.cdt.debug.internal.ui.breakpoints.CBreakpointContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class CBreakpointPreferenceStore
implements IPersistentPreferenceStore {
    private HashMap<String, Object> fProperties = new HashMap();
    private HashMap<String, Object> fOriginalValues = new HashMap();
    private boolean fIsDirty = false;
    private boolean fIsCanceled = false;
    private ListenerList<IPropertyChangeListener> fListeners = new ListenerList(1);
    private final CBreakpointContext fContext;

    public CBreakpointPreferenceStore() {
        this(null, null);
    }

    public CBreakpointPreferenceStore(CBreakpointContext context, Map<String, Object> attributes) {
        IMarker marker;
        this.fContext = context;
        this.fOriginalValues.clear();
        this.fProperties.clear();
        if (context != null && (marker = context.getBreakpoint().getMarker()) != null) {
            Map bpAttrs = Collections.emptyMap();
            try {
                bpAttrs = marker.getAttributes();
                this.fOriginalValues.putAll(bpAttrs);
                this.fProperties.putAll(bpAttrs);
            }
            catch (CoreException e) {
                DebugPlugin.log((Throwable)e);
            }
        }
        if (attributes != null) {
            this.fProperties.putAll(attributes);
            this.fIsDirty = true;
        }
    }

    public Map<String, Object> getAttributes() {
        return this.fProperties;
    }

    public void setCanceled(boolean canceled) {
        this.fIsCanceled = canceled;
    }

    public void save() throws IOException {
        if (!this.fIsCanceled && this.fContext != null && this.fContext.getBreakpoint() != null) {
            ICBreakpoint bp = this.fContext.getBreakpoint();
            if (bp.getMarker() != null && this.fIsDirty) {
                this.saveToExistingMarker(bp, bp.getMarker());
            } else {
                IResource resolved = this.getResource(this.fContext.getResource());
                if (resolved != null) {
                    this.saveToNewMarker(bp, resolved);
                } else {
                    throw new IOException("Unable to create breakpoint: no resource specified.");
                }
            }
        }
    }

    private IResource getResource(IResource preferred) {
        Object resolved = null;
        String source = this.getString("org.eclipse.cdt.debug.core.sourceHandle");
        if (!"".equals(source)) {
            IPath rawLocation = preferred.getRawLocation();
            if (rawLocation != null) {
                File file = rawLocation.toFile();
                File sourceFile = new File(source);
                if (file.getAbsoluteFile().equals(sourceFile.getAbsoluteFile())) {
                    resolved = preferred;
                }
            }
            if (resolved == null) {
                IPath path = Path.fromOSString((String)source);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IFile file = root.getFileForLocation(path);
                resolved = file == null ? root : file;
            }
        }
        if (resolved == null) {
            resolved = preferred;
        }
        return resolved;
    }

    private void saveToExistingMarker(final ICBreakpoint breakpoint, final IMarker marker) throws IOException {
        final ArrayList<String> changedProperties = new ArrayList<String>(5);
        Set<String> valueNames = this.fProperties.keySet();
        for (String name : valueNames) {
            if (!this.fProperties.containsKey(name)) continue;
            Object originalObject = this.fOriginalValues.get(name);
            Object currentObject = this.fProperties.get(name);
            if (originalObject == null) {
                changedProperties.add(name);
                continue;
            }
            if (originalObject.equals(currentObject)) continue;
            changedProperties.add(name);
        }
        if (!changedProperties.isEmpty()) {
            IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    for (String property : changedProperties) {
                        if (property.equals("org.eclipse.debug.core.enabled")) {
                            breakpoint.setEnabled(CBreakpointPreferenceStore.this.getBoolean("org.eclipse.debug.core.enabled"));
                            continue;
                        }
                        if (property.equals("org.eclipse.cdt.debug.core.ignoreCount")) {
                            breakpoint.setIgnoreCount(CBreakpointPreferenceStore.this.getInt("org.eclipse.cdt.debug.core.ignoreCount"));
                            continue;
                        }
                        if (breakpoint instanceof ICTracepoint && property.equals("org.eclipse.cdt.debug.core.passCount")) {
                            ((ICTracepoint)breakpoint).setPassCount(CBreakpointPreferenceStore.this.getInt("org.eclipse.cdt.debug.core.passCount"));
                            continue;
                        }
                        if (breakpoint instanceof ICDynamicPrintf && property.equals("org.eclipse.cdt.debug.core.printf_string")) {
                            ((ICDynamicPrintf)breakpoint).setPrintfString(CBreakpointPreferenceStore.this.getString("org.eclipse.cdt.debug.core.printf_string"));
                            continue;
                        }
                        if (property.equals("org.eclipse.cdt.debug.core.condition")) {
                            breakpoint.setCondition(CBreakpointPreferenceStore.this.getString("org.eclipse.cdt.debug.core.condition"));
                            continue;
                        }
                        if (property.equals("lineNumber")) {
                            if (breakpoint instanceof ICLineBreakpoint2) {
                                ((ICLineBreakpoint2)breakpoint).setRequestedLine(CBreakpointPreferenceStore.this.getInt("lineNumber"));
                                breakpoint.getMarker().setAttribute("lineNumber", CBreakpointPreferenceStore.this.getInt("lineNumber"));
                                ((ICBreakpoint2)breakpoint).refreshMessage();
                                continue;
                            }
                            breakpoint.getMarker().setAttribute("lineNumber", CBreakpointPreferenceStore.this.getInt("lineNumber"));
                            breakpoint.getMarker().setAttribute("requestedLine", CBreakpointPreferenceStore.this.getInt("lineNumber"));
                            continue;
                        }
                        Object value = CBreakpointPreferenceStore.this.fProperties.get(property);
                        if (value == null) continue;
                        marker.setAttribute(property, value);
                        if (!(breakpoint instanceof ICBreakpoint2)) continue;
                        ((ICBreakpoint2)breakpoint).refreshMessage();
                    }
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(wr, null);
            }
            catch (CoreException ce) {
                throw new IOException("Cannot save properties to breakpoint.", ce);
            }
        }
    }

    private void saveToNewMarker(ICBreakpoint breakpoint, IResource resource) throws IOException {
        try {
            if (this.fProperties.containsKey("requestedSourceHandle")) {
                this.fProperties.put("requestedSourceHandle", this.fProperties.get("org.eclipse.cdt.debug.core.sourceHandle"));
            }
            if (this.fProperties.containsKey("requestedLine")) {
                this.fProperties.put("requestedLine", this.fProperties.get("lineNumber"));
            }
            if (this.fProperties.containsKey("requestedCharStart")) {
                this.fProperties.put("requestedCharStart", this.fProperties.get("charStart"));
            }
            if (this.fProperties.containsKey("requestedCharEnd")) {
                this.fProperties.put("requestedCharEnd", this.fProperties.get("charEnd"));
            }
            CDIDebugModel.createBreakpointMarker((ICBreakpoint)breakpoint, (IResource)resource, this.fProperties, (boolean)true);
        }
        catch (CoreException ce) {
            throw new IOException("Cannot save properties to new breakpoint.", ce);
        }
    }

    public boolean needsSaving() {
        return this.fIsDirty && !this.fIsCanceled;
    }

    public boolean contains(String name) {
        return this.fProperties.containsKey(name);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        Object[] listeners = this.fListeners.getListeners();
        if (!(listeners.length <= 0 || oldValue != null && oldValue.equals(newValue))) {
            PropertyChangeEvent pe = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            int i = 0;
            while (i < listeners.length) {
                IPropertyChangeListener l = (IPropertyChangeListener)listeners[i];
                l.propertyChange(pe);
                ++i;
            }
        }
    }

    public boolean getBoolean(String name) {
        boolean retVal = false;
        Object o = this.fProperties.get(name);
        if (o instanceof Boolean) {
            retVal = (Boolean)o;
        }
        return retVal;
    }

    public int getInt(String name) {
        int retVal = 0;
        Object o = this.fProperties.get(name);
        if (o instanceof Integer) {
            retVal = (Integer)o;
        }
        return retVal;
    }

    public String getString(String name) {
        String retVal = "";
        Object o = this.fProperties.get(name);
        if (o instanceof String) {
            retVal = (String)o;
        }
        return retVal;
    }

    public double getDouble(String name) {
        return 0.0;
    }

    public float getFloat(String name) {
        return 0.0f;
    }

    public long getLong(String name) {
        return 0L;
    }

    public boolean isDefault(String name) {
        return false;
    }

    public boolean getDefaultBoolean(String name) {
        return false;
    }

    public double getDefaultDouble(String name) {
        return 0.0;
    }

    public float getDefaultFloat(String name) {
        return 0.0f;
    }

    public int getDefaultInt(String name) {
        return 0;
    }

    public long getDefaultLong(String name) {
        return 0L;
    }

    public String getDefaultString(String name) {
        return null;
    }

    public void putValue(String name, String value) {
        Object oldValue = this.fProperties.get(name);
        if (oldValue == null || !oldValue.equals(value)) {
            this.fProperties.put(name, value);
            this.setDirty(true);
        }
    }

    public void setDefault(String name, double value) {
    }

    public void setDefault(String name, float value) {
    }

    public void setDefault(String name, int value) {
    }

    public void setDefault(String name, long value) {
    }

    public void setDefault(String name, String defaultObject) {
    }

    public void setDefault(String name, boolean value) {
    }

    public void setToDefault(String name) {
    }

    public void setValue(String name, boolean value) {
        boolean oldValue = this.getBoolean(name);
        if (oldValue != value) {
            this.fProperties.put(name, value);
            this.setDirty(true);
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(String name, int value) {
        int oldValue = this.getInt(name);
        if (oldValue != value) {
            this.fProperties.put(name, value);
            this.setDirty(true);
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(String name, String value) {
        Object oldValue = this.fProperties.get(name);
        if (oldValue == null && value != null || oldValue != null && !oldValue.equals(value)) {
            this.fProperties.put(name, value);
            this.setDirty(true);
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(String name, float value) {
    }

    public void setValue(String name, double value) {
    }

    public void setValue(String name, long value) {
    }

    private void setDirty(boolean isDirty) {
        this.fIsDirty = isDirty;
    }
}

