/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IMultiTextSelection;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;

public class TextSelection
implements IMultiTextSelection {
    private static final boolean ASSERT_INVLID_SELECTION_NULL = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jface.text/assert/TextSelection/validConstructorArguments"));
    private static final ITextSelection NULL = new TextSelection();
    private final IDocument fDocument;
    private final int fOffset;
    private final int fLength;

    public static ITextSelection emptySelection() {
        return NULL;
    }

    private TextSelection() {
        this.fOffset = -1;
        this.fLength = -1;
        this.fDocument = null;
    }

    public TextSelection(int offset, int length) {
        this(null, offset, length);
    }

    public TextSelection(IDocument document, int offset, int length) {
        if (ASSERT_INVLID_SELECTION_NULL) {
            Assert.isLegal((offset >= 0 ? 1 : 0) != 0);
            Assert.isLegal((length >= 0 ? 1 : 0) != 0);
        }
        this.fDocument = document;
        this.fOffset = offset;
        this.fLength = length;
    }

    public boolean isEmpty() {
        return this == NULL || this.fOffset < 0 || this.fLength < 0;
    }

    @Override
    public int getOffset() {
        return this.fOffset;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public int getStartLine() {
        try {
            if (this.fDocument != null) {
                return this.fDocument.getLineOfOffset(this.fOffset);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public int getEndLine() {
        try {
            if (this.fDocument != null) {
                int endOffset = this.fOffset + this.fLength;
                if (this.fLength != 0) {
                    --endOffset;
                }
                return this.fDocument.getLineOfOffset(endOffset);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public String getText() {
        try {
            if (this.fDocument != null) {
                return this.fDocument.get(this.fOffset, this.fLength);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public boolean equals(Object obj) {
        boolean sameRange;
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TextSelection s = (TextSelection)obj;
        boolean bl = sameRange = s.fOffset == this.fOffset && s.fLength == this.fLength;
        if (sameRange) {
            if (s.fDocument == null && this.fDocument == null) {
                return true;
            }
            if (s.fDocument == null || this.fDocument == null) {
                return false;
            }
            try {
                String sContent = s.fDocument.get(this.fOffset, this.fLength);
                String content = this.fDocument.get(this.fOffset, this.fLength);
                return sContent.equals(content);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        int low = this.fDocument != null ? this.fDocument.hashCode() : 0;
        return this.fOffset << 24 | this.fLength << 16 | low;
    }

    protected IDocument getDocument() {
        return this.fDocument;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TextSelection [offset: ").append(this.fOffset);
        int startLine = this.getStartLine();
        sb.append(", startLine: ").append(startLine);
        int endLine = this.getEndLine();
        if (endLine != startLine) {
            sb.append(", endLine: ").append(endLine);
        }
        sb.append(", length: ").append(this.fLength);
        if (this.fLength != 0) {
            sb.append(", text: ").append(this.getText());
        }
        if (this.fDocument != null) {
            sb.append(", document: ").append(this.fDocument);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public IRegion[] getRegions() {
        return new IRegion[]{new Region(this.getOffset(), this.getLength())};
    }
}

