/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.theme.css;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.theme.css.CSSConditionFactory;
import org.eclipse.tm4e.core.internal.theme.css.CSSDocumentHandler;
import org.eclipse.tm4e.core.internal.theme.css.CSSSelectorFactory;
import org.eclipse.tm4e.core.internal.theme.css.CSSStyle;
import org.eclipse.tm4e.core.internal.theme.css.ExtendedSelector;
import org.eclipse.tm4e.core.internal.theme.css.sac.SACParserFactory;
import org.eclipse.tm4e.core.theme.IStyle;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SelectorList;

public class CSSParser {
    protected final CSSDocumentHandler handler = new CSSDocumentHandler();

    private static InputSource toSource(InputStream source) {
        InputSource in = new InputSource();
        in.setByteStream(source);
        return in;
    }

    protected CSSParser() {
    }

    public CSSParser(InputStream source) throws Exception {
        this(CSSParser.toSource(source));
    }

    public CSSParser(InputSource source) throws Exception {
        this(source, new SACParserFactory().makeParser());
    }

    public CSSParser(String source) throws Exception {
        this(new InputSource((Reader)new StringReader(source)));
    }

    public CSSParser(InputSource source, Parser parser) throws CSSException, IOException {
        parser.setDocumentHandler((DocumentHandler)this.handler);
        parser.setConditionFactory(CSSConditionFactory.INSTANCE);
        parser.setSelectorFactory(CSSSelectorFactory.INSTANCE);
        parser.parseStyleSheet(source);
    }

    public @Nullable IStyle getBestStyle(String ... cssClassNames) {
        int bestSpecificity = 0;
        IStyle bestStyle = null;
        for (IStyle style : this.handler.getStyles()) {
            SelectorList list = ((CSSStyle)style).selectorList;
            int i = 0;
            int l = list.getLength();
            while (i < l) {
                ExtendedSelector selector = (ExtendedSelector)list.item(i);
                int nbMatch = selector.nbMatch(cssClassNames);
                if (nbMatch >= 1 && (nbMatch >= bestSpecificity || bestStyle == null) && nbMatch == selector.nbClass()) {
                    bestStyle = style;
                    bestSpecificity = nbMatch;
                }
                ++i;
            }
        }
        return bestStyle;
    }

    public List<IStyle> getStyles() {
        return this.handler.getStyles();
    }
}

