/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.jfr;

import java.util.HashMap;
import java.util.Map;
import jdk.jfr.Category;
import jdk.jfr.Event;
import jdk.jfr.Label;
import jdk.jfr.Name;
import jdk.jfr.StackTrace;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.engine.DiscoveryFilter;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.launcher.EngineDiscoveryResult;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.jfr.UniqueId;

@API(status=API.Status.INTERNAL, since="6.0")
class FlightRecordingDiscoveryListener
implements LauncherDiscoveryListener {
    private final Map<org.junit.platform.engine.UniqueId, EngineDiscoveryEvent> engineDiscoveryEvents = new HashMap<org.junit.platform.engine.UniqueId, EngineDiscoveryEvent>();
    private @Nullable LauncherDiscoveryEvent launcherDiscoveryEvent;

    FlightRecordingDiscoveryListener() {
    }

    @Override
    public void launcherDiscoveryStarted(LauncherDiscoveryRequest request) {
        LauncherDiscoveryEvent event = new LauncherDiscoveryEvent();
        if (event.isEnabled()) {
            event.begin();
            this.launcherDiscoveryEvent = event;
        }
    }

    @Override
    public void launcherDiscoveryFinished(LauncherDiscoveryRequest request) {
        LauncherDiscoveryEvent event = this.launcherDiscoveryEvent;
        this.launcherDiscoveryEvent = null;
        if (event != null && event.shouldCommit()) {
            event.selectors = request.getSelectorsByType(DiscoverySelector.class).size();
            event.filters = request.getFiltersByType(DiscoveryFilter.class).size();
            event.commit();
        }
    }

    @Override
    public void engineDiscoveryStarted(org.junit.platform.engine.UniqueId engineId) {
        EngineDiscoveryEvent event = new EngineDiscoveryEvent();
        if (event.isEnabled()) {
            event.begin();
            this.engineDiscoveryEvents.put(engineId, event);
        }
    }

    @Override
    public void engineDiscoveryFinished(org.junit.platform.engine.UniqueId engineId, EngineDiscoveryResult result) {
        EngineDiscoveryEvent event = this.engineDiscoveryEvents.remove(engineId);
        if (event != null && event.shouldCommit()) {
            event.uniqueId = engineId.toString();
            event.result = result.getStatus().toString();
            event.commit();
        }
    }

    public void issueEncountered(org.junit.platform.engine.UniqueId engineId, DiscoveryIssue issue) {
        DiscoveryIssueEvent event = new DiscoveryIssueEvent();
        if (event.shouldCommit()) {
            event.engineId = engineId.toString();
            event.severity = issue.severity().name();
            event.message = issue.message();
            event.source = issue.source().map(Object::toString).orElse(null);
            event.cause = issue.cause().map(ExceptionUtils::readStackTrace).orElse(null);
            event.commit();
        }
    }

    @Label(value="Test Discovery")
    @Name(value="org.junit.LauncherDiscovery")
    static class LauncherDiscoveryEvent
    extends DiscoveryEvent {
        @Label(value="Number of selectors")
        int selectors;
        @Label(value="Number of filters")
        int filters;

        LauncherDiscoveryEvent() {
        }
    }

    @Label(value="Engine Discovery")
    @Name(value="org.junit.EngineDiscovery")
    static class EngineDiscoveryEvent
    extends DiscoveryEvent {
        @UniqueId
        @Label(value="Unique Id")
        @Nullable String uniqueId;
        @Label(value="Result")
        @Nullable String result;

        EngineDiscoveryEvent() {
        }
    }

    @Label(value="Discovery Issue")
    @Name(value="org.junit.DiscoveryIssue")
    static class DiscoveryIssueEvent
    extends DiscoveryEvent {
        @Label(value="Engine Id")
        @Nullable String engineId;
        @Label(value="Severity")
        @Nullable String severity;
        @Label(value="Message")
        @Nullable String message;
        @Label(value="Source")
        @Nullable String source;
        @Label(value="Cause")
        @Nullable String cause;

        DiscoveryIssueEvent() {
        }
    }

    @Category(value={"JUnit", "Discovery"})
    @StackTrace(value=false)
    static abstract class DiscoveryEvent
    extends Event {
        DiscoveryEvent() {
        }
    }
}

