/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DenseConjunctionBulkScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public abstract class ConstantScoreScorerSupplier
extends ScorerSupplier {
    private final ScoreMode scoreMode;
    private final float score;
    private final int maxDoc;

    public static ConstantScoreScorerSupplier matchAll(float score, ScoreMode scoreMode, int maxDoc) {
        return ConstantScoreScorerSupplier.fromIterator(DocIdSetIterator.all(maxDoc), score, scoreMode, maxDoc);
    }

    public static ConstantScoreScorerSupplier fromIterator(final DocIdSetIterator iterator, float score, ScoreMode scoreMode, int maxDoc) {
        return new ConstantScoreScorerSupplier(score, scoreMode, maxDoc){

            @Override
            public long cost() {
                return iterator.cost();
            }

            @Override
            public DocIdSetIterator iterator(long leadCost) throws IOException {
                return iterator;
            }
        };
    }

    protected ConstantScoreScorerSupplier(float score, ScoreMode scoreMode, int maxDoc) {
        this.scoreMode = scoreMode;
        this.score = score;
        this.maxDoc = maxDoc;
    }

    public abstract DocIdSetIterator iterator(long var1) throws IOException;

    @Override
    public final Scorer get(long leadCost) throws IOException {
        DocIdSetIterator iterator = this.iterator(leadCost);
        TwoPhaseIterator twoPhase = TwoPhaseIterator.unwrap(iterator);
        if (twoPhase == null) {
            return new ConstantScoreScorer(this.score, this.scoreMode, iterator);
        }
        return new ConstantScoreScorer(this.score, this.scoreMode, twoPhase);
    }

    @Override
    public final BulkScorer bulkScorer() throws IOException {
        DocIdSetIterator iterator = this.iterator(Long.MAX_VALUE);
        if (this.maxDoc >= 2048 && iterator.cost() >= (long)(this.maxDoc / 32)) {
            List<TwoPhaseIterator> twoPhases;
            List<DocIdSetIterator> iterators;
            TwoPhaseIterator twoPhase = TwoPhaseIterator.unwrap(iterator);
            if (twoPhase == null) {
                iterators = Collections.singletonList(iterator);
                twoPhases = Collections.emptyList();
            } else {
                iterators = Collections.emptyList();
                twoPhases = Collections.singletonList(twoPhase);
            }
            return new DenseConjunctionBulkScorer(iterators, twoPhases, this.maxDoc, this.score);
        }
        return new Weight.DefaultBulkScorer(new ConstantScoreScorer(this.score, this.scoreMode, iterator));
    }
}

