/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.zest.core.widgets.DefaultSubgraph;
import org.eclipse.zest.core.widgets.FisheyeListener;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.InternalNodeLayout;
import org.eclipse.zest.core.widgets.internal.GraphLabel;
import org.eclipse.zest.core.widgets.internal.ZestRootLayer;
import org.eclipse.zest.layouts.interfaces.LayoutContext;
import org.eclipse.zest.layouts.interfaces.NodeLayout;

class PrunedSuccessorsSubgraph
extends DefaultSubgraph {
    private final FigureListener nodeFigureListener = source -> {
        GraphLabel label = this.nodeFigureToLabel.get(source);
        if (label != null) {
            PrunedSuccessorsSubgraph.refreshLabelBounds(source, label);
        }
    };
    private final FisheyeListener fisheyeListener = new FisheyeListener(){

        @Override
        public void fisheyeReplaced(Graph graph, IFigure oldFisheyeFigure, IFigure newFisheyeFigure) {
            oldFisheyeFigure.removeFigureListener(PrunedSuccessorsSubgraph.this.nodeFigureListener);
            newFisheyeFigure.addFigureListener(PrunedSuccessorsSubgraph.this.nodeFigureListener);
            GraphLabel label = PrunedSuccessorsSubgraph.this.nodeFigureToLabel.remove(oldFisheyeFigure);
            PrunedSuccessorsSubgraph.this.nodeFigureToLabel.put(newFisheyeFigure, label);
            LabelAncestorListener ancestorListener = (LabelAncestorListener)PrunedSuccessorsSubgraph.this.labelToAncestorListener.get(label);
            ancestorListener.fisheyeFigure = null;
            PrunedSuccessorsSubgraph.addLabelForFigure(newFisheyeFigure, label);
            ancestorListener.fisheyeFigure = newFisheyeFigure;
            PrunedSuccessorsSubgraph.refreshLabelBounds(newFisheyeFigure, label);
        }

        @Override
        public void fisheyeRemoved(Graph graph, IFigure originalFigure, IFigure fisheyeFigure) {
        }

        @Override
        public void fisheyeAdded(Graph graph, IFigure originalFigure, IFigure fisheyeFigure) {
            originalFigure.removeFigureListener(PrunedSuccessorsSubgraph.this.nodeFigureListener);
            fisheyeFigure.addFigureListener(PrunedSuccessorsSubgraph.this.nodeFigureListener);
            GraphLabel label = PrunedSuccessorsSubgraph.this.nodeFigureToLabel.get(originalFigure);
            if (label == null) {
                return;
            }
            PrunedSuccessorsSubgraph.this.nodeFigureToLabel.put(fisheyeFigure, label);
            PrunedSuccessorsSubgraph.refreshLabelBounds(fisheyeFigure, label);
            PrunedSuccessorsSubgraph.addLabelForFigure(fisheyeFigure, label);
            LabelAncestorListener labelAncestorListener = new LabelAncestorListener(originalFigure, fisheyeFigure);
            label.addAncestorListener((AncestorListener)labelAncestorListener);
            PrunedSuccessorsSubgraph.this.labelToAncestorListener.put(label, (AncestorListener)labelAncestorListener);
        }
    };
    private final Map<IFigure, GraphLabel> nodeFigureToLabel = new HashMap<IFigure, GraphLabel>();
    private final Map<GraphLabel, AncestorListener> labelToAncestorListener = new HashMap<GraphLabel, AncestorListener>();

    protected PrunedSuccessorsSubgraph(LayoutContext context2) {
        super(context2);
        this.context.container.getGraph().addFisheyeListener(this.fisheyeListener);
    }

    @Override
    public void addNodes(NodeLayout[] nodes) {
        super.addNodes(nodes);
        HashSet<NodeLayout> nodesToUpdate = new HashSet<NodeLayout>();
        NodeLayout[] nodeLayoutArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            NodeLayout node = nodeLayoutArray[n2];
            nodesToUpdate.addAll(Arrays.asList(node.getPredecessingNodes()));
            ++n2;
        }
        for (NodeLayout element : nodesToUpdate) {
            InternalNodeLayout nodeToUpdate = (InternalNodeLayout)element;
            this.updateNodeLabel(nodeToUpdate);
        }
    }

    @Override
    public void removeNodes(NodeLayout[] nodes) {
        super.removeNodes(nodes);
        HashSet<NodeLayout> nodesToUpdate = new HashSet<NodeLayout>();
        NodeLayout[] nodeLayoutArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            NodeLayout node = nodeLayoutArray[n2];
            nodesToUpdate.addAll(Arrays.asList(node.getPredecessingNodes()));
            if (((InternalNodeLayout)node).isDisposed()) {
                this.removeFigureForNode((InternalNodeLayout)node);
            } else {
                nodesToUpdate.add(node);
            }
            ++n2;
        }
        for (NodeLayout element : nodesToUpdate) {
            InternalNodeLayout predecessor = (InternalNodeLayout)element;
            this.updateNodeLabel(predecessor);
        }
    }

    private static void addLabelForFigure(IFigure figure, GraphLabel label) {
        IFigure parent = figure.getParent();
        if (parent instanceof ZestRootLayer) {
            ((ZestRootLayer)parent).addDecoration(figure, label);
        } else {
            if (parent.getChildren().contains(label)) {
                parent.remove((IFigure)label);
            }
            int index = parent.getChildren().indexOf(figure);
            parent.add((IFigure)label, index + 1);
        }
    }

    private static void refreshLabelBounds(IFigure figure, GraphLabel label) {
        Rectangle figureBounds = figure.getBounds();
        if (figureBounds.width * figureBounds.height > 0) {
            label.setText(label.getText());
            Dimension labelSize = label.getSize();
            labelSize.expand(-6, -4);
            Point anchorPoint = figure.getBounds().getBottomRight();
            anchorPoint.x -= labelSize.width / 2;
            anchorPoint.y -= labelSize.height / 2;
            Rectangle bounds = new Rectangle(anchorPoint, labelSize);
            label.setBounds(bounds);
            label.getParent().setConstraint((IFigure)label, (Object)bounds);
        } else {
            label.getParent().setConstraint((IFigure)label, (Object)new Rectangle(figureBounds.x, figureBounds.y, 0, 0));
            label.setBounds(new Rectangle(figureBounds.x, figureBounds.y, 0, 0));
        }
    }

    void updateNodeLabel(InternalNodeLayout internalNode) {
        GraphNode graphNode;
        if (internalNode.isDisposed()) {
            return;
        }
        IFigure figure = internalNode.getNode().getFigure();
        GraphLabel label = this.nodeFigureToLabel.get(figure);
        IFigure fisheye = this.getFisheyeFigure(figure);
        if (fisheye != null) {
            figure = fisheye;
        }
        if (label == null) {
            label = new GraphLabel(false);
            label.setForegroundColor(ColorConstants.white);
            label.setBackgroundColor(ColorConstants.red);
            FontData fontData = Display.getDefault().getSystemFont().getFontData()[0];
            fontData.setHeight(6);
            label.setFont(new Font((Device)Display.getCurrent(), fontData));
            figure.addFigureListener(this.nodeFigureListener);
            PrunedSuccessorsSubgraph.addLabelForFigure(figure, label);
            this.nodeFigureToLabel.put(figure, label);
        }
        if (!(graphNode = internalNode.getNode()).getGraphModel().canExpand(graphNode) || graphNode.getGraphModel().canCollapse(graphNode) || internalNode.isPruned()) {
            label.setVisible(false);
        } else {
            String labelText;
            NodeLayout[] successors = internalNode.getSuccessingNodes();
            int numberOfHiddenSuccessors = 0;
            NodeLayout[] nodeLayoutArray = successors;
            int n = successors.length;
            int n2 = 0;
            while (n2 < n) {
                NodeLayout successor = nodeLayoutArray[n2];
                if (successor.isPruned()) {
                    ++numberOfHiddenSuccessors;
                }
                ++n2;
            }
            String string = labelText = numberOfHiddenSuccessors > 0 ? Integer.toString(numberOfHiddenSuccessors) : "";
            if (!labelText.equals(label.getText())) {
                label.setText(labelText);
            }
            label.setVisible(true);
        }
        PrunedSuccessorsSubgraph.refreshLabelBounds(figure, label);
    }

    private IFigure getFisheyeFigure(IFigure originalFigure) {
        GraphLabel label = this.nodeFigureToLabel.get(originalFigure);
        LabelAncestorListener ancestorListener = (LabelAncestorListener)this.labelToAncestorListener.get(label);
        if (ancestorListener != null) {
            return ancestorListener.fisheyeFigure;
        }
        return null;
    }

    private void removeFigureForNode(InternalNodeLayout internalNode) {
        IFigure figure = internalNode.getNode().getFigure();
        GraphLabel label = this.nodeFigureToLabel.get(figure);
        if (label != null && label.getParent() != null) {
            label.getParent().remove((IFigure)label);
        }
        this.nodeFigureToLabel.remove(figure);
    }

    private class LabelAncestorListener
    extends AncestorListener.Stub {
        private final IFigure originalFigure;
        private IFigure fisheyeFigure;

        public LabelAncestorListener(IFigure originalFigure, IFigure fisheyeFigure) {
            this.originalFigure = originalFigure;
            this.fisheyeFigure = fisheyeFigure;
        }

        public void ancestorRemoved(IFigure ancestor) {
            if (this.fisheyeFigure != null) {
                GraphLabel label = PrunedSuccessorsSubgraph.this.nodeFigureToLabel.get(this.fisheyeFigure);
                if (label == null) {
                    return;
                }
                PrunedSuccessorsSubgraph.this.nodeFigureToLabel.remove(this.fisheyeFigure);
                Display.getDefault().asyncExec(() -> label.removeAncestorListener((AncestorListener)this));
                this.fisheyeFigure.removeFigureListener(PrunedSuccessorsSubgraph.this.nodeFigureListener);
                this.originalFigure.addFigureListener(PrunedSuccessorsSubgraph.this.nodeFigureListener);
                PrunedSuccessorsSubgraph.this.labelToAncestorListener.remove(label);
                this.fisheyeFigure = null;
                PrunedSuccessorsSubgraph.addLabelForFigure(this.originalFigure, label);
                PrunedSuccessorsSubgraph.refreshLabelBounds(this.originalFigure, label);
            }
        }
    }
}

