/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.expression;

import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.ExpressionsChangedEvent;
import org.eclipse.cdt.dsf.ui.viewmodel.update.IElementUpdateTester;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.jface.viewers.TreePath;

class ExpressionsChangedUpdateTester
implements IElementUpdateTester {
    private final ExpressionsChangedEvent fEvent;

    public ExpressionsChangedUpdateTester(ExpressionsChangedEvent event) {
        this.fEvent = event;
    }

    @Override
    public int getUpdateFlags(Object viewerInput, TreePath path) {
        Object element;
        Object object = element = path.getSegmentCount() == 0 ? viewerInput : path.getLastSegment();
        if (this.fEvent.getExpressionManagerElements().contains(element)) {
            return 1;
        }
        if (this.fEvent.getType().equals((Object)ExpressionsChangedEvent.Type.CHANGED)) {
            int i = 0;
            while (i < path.getSegmentCount()) {
                if (this.eventContainsElement(path.getSegment(i))) {
                    return 1;
                }
                ++i;
            }
        }
        return 0;
    }

    private boolean eventContainsElement(Object element) {
        IExpression expression;
        if (element instanceof IAdaptable && (expression = (IExpression)((IAdaptable)element).getAdapter(IExpression.class)) != null) {
            int i = 0;
            while (i < this.fEvent.getExpressions().length) {
                if (expression.equals(this.fEvent.getExpressions()[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public boolean includes(IElementUpdateTester tester) {
        return tester instanceof ExpressionsChangedUpdateTester;
    }

    public String toString() {
        return "(" + String.valueOf(this.fEvent) + ") update tester";
    }
}

