/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.grammar;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.grammar.IStateStack;
import org.eclipse.tm4e.core.grammar.IToken;
import org.eclipse.tm4e.core.grammar.ITokenizeLineResult;
import org.eclipse.tm4e.core.internal.grammar.AttributedScopeStack;
import org.eclipse.tm4e.core.internal.grammar.BalancedBracketSelectors;
import org.eclipse.tm4e.core.internal.grammar.BasicScopeAttributes;
import org.eclipse.tm4e.core.internal.grammar.BasicScopeAttributesProvider;
import org.eclipse.tm4e.core.internal.grammar.Injection;
import org.eclipse.tm4e.core.internal.grammar.LineTokenizer;
import org.eclipse.tm4e.core.internal.grammar.LineTokens;
import org.eclipse.tm4e.core.internal.grammar.StateStack;
import org.eclipse.tm4e.core.internal.grammar.TokenTypeMatcher;
import org.eclipse.tm4e.core.internal.grammar.TokenizeLineResult;
import org.eclipse.tm4e.core.internal.grammar.raw.IRawGrammar;
import org.eclipse.tm4e.core.internal.grammar.raw.IRawRepository;
import org.eclipse.tm4e.core.internal.grammar.raw.IRawRule;
import org.eclipse.tm4e.core.internal.grammar.raw.RawRule;
import org.eclipse.tm4e.core.internal.grammar.tokenattrs.EncodedTokenAttributes;
import org.eclipse.tm4e.core.internal.matcher.Matcher;
import org.eclipse.tm4e.core.internal.matcher.MatcherWithPriority;
import org.eclipse.tm4e.core.internal.oniguruma.OnigString;
import org.eclipse.tm4e.core.internal.registry.IGrammarRepository;
import org.eclipse.tm4e.core.internal.registry.IThemeProvider;
import org.eclipse.tm4e.core.internal.rule.IRuleFactoryHelper;
import org.eclipse.tm4e.core.internal.rule.Rule;
import org.eclipse.tm4e.core.internal.rule.RuleFactory;
import org.eclipse.tm4e.core.internal.rule.RuleId;
import org.eclipse.tm4e.core.internal.theme.StyleAttributes;
import org.eclipse.tm4e.core.internal.utils.ObjectCloner;
import org.eclipse.tm4e.core.internal.utils.StringUtils;

public final class Grammar
implements IGrammar,
IRuleFactoryHelper {
    private static final System.Logger LOGGER = System.getLogger(Grammar.class.getName());
    private final String rootScopeName;
    private @Nullable RuleId _rootId;
    private int _lastRuleId = 0;
    private final Map<RuleId, @Nullable Rule> _ruleId2desc = new HashMap<RuleId, Rule>();
    private final Map<String, IRawGrammar> includedGrammars = new HashMap<String, IRawGrammar>();
    private final IGrammarRepository _grammarRepository;
    private final IRawGrammar _grammar;
    final IThemeProvider themeProvider;
    private @Nullable List<Injection> _injections;
    private final BasicScopeAttributesProvider _basicScopeAttributesProvider;
    private final List<TokenTypeMatcher> _tokenTypeMatchers = new ArrayList<TokenTypeMatcher>();
    private final @Nullable BalancedBracketSelectors balancedBracketSelectors;

    public Grammar(String rootScopeName, IRawGrammar grammar, int initialLanguage, @Nullable Map<String, Integer> embeddedLanguages, @Nullable Map<String, Integer> tokenTypes, @Nullable BalancedBracketSelectors balancedBracketSelectors, IGrammarRepository grammarRepository, IThemeProvider themeProvider) {
        this.rootScopeName = rootScopeName;
        this._basicScopeAttributesProvider = new BasicScopeAttributesProvider(initialLanguage, embeddedLanguages);
        this._grammarRepository = grammarRepository;
        this._grammar = this.initGrammar(grammar, null);
        this.balancedBracketSelectors = balancedBracketSelectors;
        this.themeProvider = themeProvider;
        if (tokenTypes != null) {
            for (Map.Entry<String, Integer> entry : tokenTypes.entrySet()) {
                String selector = entry.getKey();
                Integer type = entry.getValue();
                for (MatcherWithPriority<List<String>> matcher : Matcher.createMatchers(selector)) {
                    this._tokenTypeMatchers.add(new TokenTypeMatcher(matcher.matcher, type));
                }
            }
        }
    }

    BasicScopeAttributes getMetadataForScope(String scope) {
        return this._basicScopeAttributesProvider.getBasicScopeAttributes(scope);
    }

    private void collectInjections(List<Injection> result, String selector, IRawRule rule, IRuleFactoryHelper ruleFactoryHelper, IRawGrammar grammar) {
        List<MatcherWithPriority<List<String>>> matchers = Matcher.createMatchers(selector);
        RuleId ruleId = RuleFactory.getCompiledRuleId(rule, ruleFactoryHelper, this._grammar.getRepository());
        for (MatcherWithPriority<List<String>> matcher : matchers) {
            result.add(new Injection(selector, matcher.matcher, ruleId, grammar, matcher.priority));
        }
    }

    private List<Injection> _collectInjections() {
        var grammarRepository = new IGrammarRepository(){

            @Override
            public @Nullable IRawGrammar lookup(String scopeName) {
                if (Objects.equals(scopeName, Grammar.this.rootScopeName)) {
                    return Grammar.this._grammar;
                }
                return Grammar.this.getExternalGrammar(scopeName, null);
            }

            @Override
            public @Nullable Collection<String> injections(String targetScope) {
                return Grammar.this._grammarRepository.injections(targetScope);
            }
        };
        ArrayList<Injection> result = new ArrayList<Injection>();
        String scopeName = this.rootScopeName;
        IRawGrammar grammar = grammarRepository.lookup(scopeName);
        if (grammar != null) {
            Collection<String> injectionScopeNames;
            Map<String, IRawRule> rawInjections = grammar.getInjections();
            if (rawInjections != null) {
                for (Map.Entry<String, IRawRule> e : rawInjections.entrySet()) {
                    this.collectInjections(result, e.getKey(), e.getValue(), this, grammar);
                }
            }
            if ((injectionScopeNames = this._grammarRepository.injections(scopeName)) != null) {
                injectionScopeNames.forEach(injectionScopeName -> {
                    String selector;
                    IRawGrammar injectionGrammar = this.getExternalGrammar((String)injectionScopeName, null);
                    if (injectionGrammar != null && (selector = injectionGrammar.getInjectionSelector()) != null) {
                        this.collectInjections(result, selector, injectionGrammar.toRawRule(), this, injectionGrammar);
                    }
                });
            }
        }
        Collections.sort(result, (i1, i2) -> i1.priority - i2.priority);
        return result;
    }

    List<Injection> getInjections() {
        List<Injection> injections = this._injections;
        if (injections == null) {
            injections = this._injections = this._collectInjections();
            if (LOGGER.isLoggable(System.Logger.Level.TRACE) && !injections.isEmpty()) {
                LOGGER.log(System.Logger.Level.TRACE, "Grammar " + this.rootScopeName + " contains the following injections:");
                for (Injection injection : injections) {
                    LOGGER.log(System.Logger.Level.TRACE, "  - " + injection.debugSelector);
                }
            }
        }
        return injections;
    }

    @Override
    public <T extends Rule> T registerRule(Function<RuleId, T> factory) {
        RuleId id = RuleId.of(++this._lastRuleId);
        @Nullable Rule result = (Rule)factory.apply(id);
        this._ruleId2desc.put(id, result);
        return (T)result;
    }

    @Override
    public Rule getRule(RuleId ruleId) {
        Rule rule = this._ruleId2desc.get(ruleId);
        if (rule == null) {
            throw new IndexOutOfBoundsException("No rule with index " + ruleId.id + " found. Possible values: 0.." + this._ruleId2desc.size());
        }
        return rule;
    }

    @Override
    public @Nullable IRawGrammar getExternalGrammar(String scopeName, @Nullable IRawRepository repository) {
        if (this.includedGrammars.containsKey(scopeName)) {
            return this.includedGrammars.get(scopeName);
        }
        IRawGrammar rawIncludedGrammar = this._grammarRepository.lookup(scopeName);
        if (rawIncludedGrammar != null) {
            this.includedGrammars.put(scopeName, this.initGrammar(rawIncludedGrammar, repository != null ? repository.getBase() : null));
            return this.includedGrammars.get(scopeName);
        }
        return null;
    }

    private IRawGrammar initGrammar(IRawGrammar grammar, @Nullable IRawRule base) {
        grammar = ObjectCloner.deepClone(grammar);
        IRawRepository repo = grammar.getRepository();
        repo.setSelf(new RawRule().setName(grammar.getScopeName()).setPatterns(grammar.getPatterns()));
        repo.setBase(base != null ? base : repo.getSelf());
        return grammar;
    }

    @Override
    public ITokenizeLineResult<IToken[]> tokenizeLine(String lineText) {
        return this.tokenizeLine(lineText, null, null);
    }

    @Override
    public ITokenizeLineResult<IToken[]> tokenizeLine(String lineText, @Nullable IStateStack prevState, @Nullable Duration timeLimit) {
        return (ITokenizeLineResult)this._tokenize(lineText, (StateStack)prevState, false, timeLimit);
    }

    @Override
    public ITokenizeLineResult<int[]> tokenizeLine2(String lineText) {
        return this.tokenizeLine2(lineText, null, null);
    }

    @Override
    public ITokenizeLineResult<int[]> tokenizeLine2(String lineText, @Nullable IStateStack prevState, @Nullable Duration timeLimit) {
        return (ITokenizeLineResult)this._tokenize(lineText, (StateStack)prevState, true, timeLimit);
    }

    private synchronized <T> T _tokenize(String lineText, @Nullable StateStack prevState, boolean emitBinaryTokens, @Nullable Duration timeLimit) {
        boolean isFirstLine;
        RuleId rootId = this._rootId;
        if (rootId == null) {
            rootId = this._rootId = RuleFactory.getCompiledRuleId(this._grammar.getRepository().getSelf(), this, this._grammar.getRepository());
            this.getInjections();
        }
        if (prevState == null || prevState == StateStack.NULL) {
            isFirstLine = true;
            BasicScopeAttributes rawDefaultMetadata = this._basicScopeAttributesProvider.getDefaultAttributes();
            StyleAttributes defaultStyle = this.themeProvider.getDefaults();
            int defaultMetadata = EncodedTokenAttributes.set(0, rawDefaultMetadata.languageId, rawDefaultMetadata.tokenType, null, defaultStyle.fontStyle, defaultStyle.foregroundId, defaultStyle.backgroundId);
            String rootScopeName = this.getRule(rootId).getName(null, null);
            AttributedScopeStack scopeList = rootScopeName != null ? AttributedScopeStack.createRootAndLookUpScopeName(rootScopeName, defaultMetadata, this) : AttributedScopeStack.createRoot("unknown", defaultMetadata);
            prevState = new StateStack(null, rootId, -1, -1, false, null, scopeList, scopeList);
        } else {
            isFirstLine = false;
            prevState.reset();
        }
        if (((String)lineText).isEmpty() || ((String)lineText).charAt(((String)lineText).length() - 1) != '\n') {
            lineText = (String)lineText + "\n";
        }
        OnigString onigLineText = OnigString.of((String)lineText);
        int lineLength = ((String)lineText).length();
        LineTokens lineTokens = new LineTokens(emitBinaryTokens, (String)lineText, this._tokenTypeMatchers, this.balancedBracketSelectors);
        LineTokenizer.TokenizeStringResult r = LineTokenizer.tokenizeString(this, onigLineText, isFirstLine, 0, prevState, lineTokens, true, timeLimit == null ? Duration.ZERO : timeLimit);
        return (T)new TokenizeLineResult<int[]>(emitBinaryTokens ? lineTokens.getBinaryResult(r.stack, lineLength) : (int[])lineTokens.getResult(r.stack, lineLength), r.stack, r.stoppedEarly);
    }

    @Override
    public @Nullable String getName() {
        return this._grammar.getName();
    }

    @Override
    public String getScopeName() {
        return this.rootScopeName;
    }

    @Override
    public Collection<String> getFileTypes() {
        return this._grammar.getFileTypes();
    }

    public String toString() {
        return StringUtils.toString(this, sb -> {
            StringBuilder stringBuilder = sb.append("name=").append(this.getName()).append(", ").append("scopeName=").append(this.getScopeName());
        });
    }
}

