/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class CopyQualifiedNameAction
extends TextEditorAction {
    private ITextEditor fEditor;

    public CopyQualifiedNameAction(ITextEditor editor) {
        super(CEditorMessages.getBundleForConstructedKeys(), "CopyQualifiedName.", editor);
        this.fEditor = editor;
        this.setText(ActionMessages.CopyQualifiedNameAction_ActionName);
        this.setToolTipText(ActionMessages.CopyQualifiedNameAction_ToolTipText);
        this.setDisabledImageDescriptor(CPluginImages.DESC_DLCL_COPY_QUALIFIED_NAME);
        this.setImageDescriptor(CPluginImages.DESC_ELCL_COPY_QUALIFIED_NAME);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.cdt.ui.copy_qualified_name_action_context");
    }

    private boolean isValidSelection(ITextSelection selection) {
        return selection != null && !selection.isEmpty() && selection.getLength() > 0;
    }

    public void update() {
        super.update();
        if (this.isEnabled()) {
            this.setEnabled(this.isValidSelection(this.getCurrentSelection()));
        }
    }

    protected ITextSelection getCurrentSelection() {
        ISelection selection;
        ISelectionProvider provider;
        if (this.fEditor != null && (provider = this.fEditor.getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return null;
    }

    public void run() {
        ITextSelection textSelection = this.getCurrentSelection();
        if (textSelection == null || !this.isValidSelection(textSelection)) {
            return;
        }
        int offset = textSelection.getOffset();
        int length = textSelection.getLength();
        ITranslationUnit translationUnit = (ITranslationUnit)CDTUITools.getEditorInputCElement(this.fEditor.getEditorInput());
        String qualName = null;
        try {
            IASTTranslationUnit ast = translationUnit.getAST(null, 0);
            if (ast != null) {
                IASTNode enclosingNode = ast.getNodeSelector(null).findEnclosingNode(offset, length);
                NameVisitor n = new NameVisitor();
                enclosingNode.accept((ASTVisitor)n);
                qualName = n.getQualifiedName();
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        Shell shell = this.fEditor.getEditorSite().getShell();
        if (qualName == null) {
            MessageDialog.openInformation((Shell)shell, (String)ActionMessages.CopyQualifiedNameAction_InfoDialogTitel, (String)ActionMessages.CopyQualifiedNameAction_NoElementToQualify);
            return;
        }
        Clipboard clipboard = new Clipboard(shell.getDisplay());
        try {
            try {
                clipboard.setContents((Object[])new String[]{qualName}, new Transfer[]{TextTransfer.getInstance()});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (MessageDialog.openQuestion((Shell)shell, (String)ActionMessages.CopyQualifiedNameAction_ErrorTitle, (String)ActionMessages.CopyQualifiedNameAction_ErrorDescription)) {
                    clipboard.setContents((Object[])new String[]{qualName}, new Transfer[]{TextTransfer.getInstance()});
                }
                clipboard.dispose();
            }
        }
        finally {
            clipboard.dispose();
        }
    }

    private static class NameVisitor
    extends ASTVisitor {
        private String qualifiedName;

        public NameVisitor() {
            this.shouldVisitNames = true;
            this.qualifiedName = null;
        }

        public int visit(IASTName name) {
            IBinding b = name.resolveBinding();
            if (b instanceof ICPPBinding) {
                try {
                    this.qualifiedName = String.join((CharSequence)"::", ((ICPPBinding)b).getQualifiedName());
                }
                catch (DOMException e) {
                    CUIPlugin.log(e);
                }
            }
            return 2;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }
    }
}

