/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.view.ui.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.terminal.connector.ITerminalConnector;
import org.eclipse.terminal.view.core.ITerminalService;
import org.eclipse.terminal.view.core.ITerminalTabListener;
import org.eclipse.terminal.view.ui.TerminalViewId;
import org.eclipse.terminal.view.ui.internal.Messages;
import org.eclipse.terminal.view.ui.launcher.ILauncherDelegate;
import org.eclipse.terminal.view.ui.launcher.ILauncherDelegateManager;
import org.eclipse.terminal.view.ui.launcher.ITerminalConsoleViewManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ITerminalService.class})
public class TerminalService
implements ITerminalService {
    private final ListenerList<ITerminalTabListener> terminalTabListeners = new ListenerList();
    private boolean fRestoringView;
    public static final int TAB_DISPOSED = 1;
    private final ITerminalConsoleViewManager consoleViewManager;
    private final ILauncherDelegateManager launchDelegateManager;

    @Activate
    public TerminalService(@Reference ITerminalConsoleViewManager consoleViewManager, @Reference ILauncherDelegateManager launchDelegateManager) {
        this.consoleViewManager = consoleViewManager;
        this.launchDelegateManager = launchDelegateManager;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public final void addTerminalTabListener(ITerminalTabListener listener) {
        Assert.isNotNull((Object)listener);
        this.terminalTabListeners.add((Object)listener);
    }

    public final void removeTerminalTabListener(ITerminalTabListener listener) {
        Assert.isNotNull((Object)listener);
        this.terminalTabListeners.remove((Object)listener);
    }

    public final void fireTerminalTabEvent(final int event, final Object source, final Object data) {
        Assert.isNotNull((Object)source);
        if (this.terminalTabListeners.isEmpty()) {
            return;
        }
        for (final ITerminalTabListener listener : this.terminalTabListeners) {
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    switch (event) {
                        case 1: {
                            listener.terminalTabDisposed(source, data);
                        }
                    }
                }
            };
            SafeRunner.run((ISafeRunnable)job);
        }
    }

    protected final CompletableFuture<?> executeServiceOperation(Map<String, Object> properties, TerminalServiceRunnable runnable) {
        ITerminalConnector connector;
        Assert.isNotNull(properties);
        Assert.isNotNull((Object)runnable);
        String id = (String)properties.get("id");
        String secondaryId = (String)properties.get("secondaryId");
        if (!properties.containsKey("secondaryId")) {
            secondaryId = "last";
        }
        String title = (String)properties.get("title");
        Object data = properties.get("data");
        id = this.normalizeId(id, data);
        title = this.normalizeTitle(title, data);
        try {
            connector = this.createTerminalConnector(properties);
        }
        catch (CoreException e) {
            return CompletableFuture.failedFuture(e);
        }
        return this.executeServiceOperation(runnable, new TerminalViewId(id, secondaryId), title, connector, data);
    }

    private CompletableFuture<?> executeServiceOperation(TerminalServiceRunnable runnable, TerminalViewId tvid, String title, ITerminalConnector connector, Object data) {
        if (runnable.isExecuteAsync()) {
            return CompletableFuture.supplyAsync(() -> runnable.run(tvid, title, connector, data), (Executor)Display.getDefault());
        }
        return CompletableFuture.completedFuture(runnable.run(tvid, title, connector, data));
    }

    protected String normalizeId(String id, Object data) {
        return id != null ? id : "org.eclipse.terminal.view.ui.TerminalsView";
    }

    protected String normalizeTitle(String title, Object data) {
        if (title != null) {
            return title;
        }
        return Messages.TerminalService_defaultTitle;
    }

    protected ITerminalConnector createTerminalConnector(Map<String, Object> properties) throws CoreException {
        Assert.isNotNull(properties);
        ILauncherDelegate delegate = (ILauncherDelegate)Optional.of(properties).map(map -> map.get("delegateId")).filter(String.class::isInstance).map(String.class::cast).flatMap(id -> this.launchDelegateManager.findLauncherDelegate((String)id, false)).orElseThrow(() -> new CoreException(Status.error((String)Messages.TerminalService_error_cannotCreateConnector)));
        return delegate.createTerminalConnector(properties);
    }

    public CompletableFuture<?> openConsole(final Map<String, Object> properties) {
        Assert.isNotNull(properties);
        final boolean restoringView = this.fRestoringView;
        return this.executeServiceOperation(properties, new TerminalServiceRunnable(){

            @Override
            public IStatus run(TerminalViewId tvid, String title, ITerminalConnector connector, Object data) {
                if (restoringView) {
                    return this.doRun(tvid, title, connector, data);
                }
                TerminalService.this.fRestoringView = true;
                try {
                    TerminalService.this.consoleViewManager.showConsoleView(tvid);
                }
                catch (CoreException e) {
                    ILog.get().log(e.getStatus());
                }
                TerminalService.this.fRestoringView = false;
                return this.doRun(tvid, title, connector, data);
            }

            private IStatus doRun(TerminalViewId tvid, String title, ITerminalConnector connector, Object data) {
                String encoding = (String)properties.get("encoding");
                HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
                flags.put("activate", Boolean.TRUE);
                if (properties.get("terminal.forceNew") instanceof Boolean) {
                    flags.put("terminal.forceNew", (Boolean)properties.get("terminal.forceNew"));
                }
                if (properties.get("data.noReconnect") instanceof Boolean) {
                    flags.put("data.noReconnect", (Boolean)properties.get("data.noReconnect"));
                }
                if (properties.get("titleDisableAnsiTitle") instanceof Boolean) {
                    flags.put("titleDisableAnsiTitle", (Boolean)properties.get("titleDisableAnsiTitle"));
                } else {
                    flags.put("titleDisableAnsiTitle", false);
                }
                try {
                    Widget console = TerminalService.this.consoleViewManager.openConsole(tvid, title, encoding, connector, data, flags);
                    if (!console.isDisposed()) {
                        console.setData("properties", (Object)properties);
                    }
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
        });
    }

    public CompletableFuture<?> closeConsole(Map<String, Object> properties) {
        Assert.isNotNull(properties);
        return this.executeServiceOperation(properties, new TerminalServiceRunnable(){

            @Override
            public IStatus run(TerminalViewId tvid, String title, ITerminalConnector connector, Object data) {
                TerminalService.this.consoleViewManager.closeConsole(tvid, title, connector, data);
                return Status.OK_STATUS;
            }
        });
    }

    public CompletableFuture<?> terminateConsole(Map<String, Object> properties) {
        Assert.isNotNull(properties);
        return this.executeServiceOperation(properties, new TerminalServiceRunnable(){

            @Override
            public IStatus run(TerminalViewId tvid, String title, ITerminalConnector connector, Object data) {
                TerminalService.this.consoleViewManager.terminateConsole(tvid, title, connector, data);
                return Status.OK_STATUS;
            }
        });
    }

    protected static abstract class TerminalServiceRunnable {
        protected TerminalServiceRunnable() {
        }

        public abstract IStatus run(TerminalViewId var1, String var2, ITerminalConnector var3, Object var4);

        public boolean isExecuteAsync() {
            return true;
        }
    }
}

