/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.sql.h2;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.dltk.core.index.sql.DbFactory;
import org.eclipse.dltk.core.index.sql.IContainerDao;
import org.eclipse.dltk.core.index.sql.IElementDao;
import org.eclipse.dltk.core.index.sql.IFileDao;
import org.eclipse.dltk.core.index.sql.SqlIndex;
import org.eclipse.dltk.core.index.sql.h2.H2Index;
import org.eclipse.dltk.internal.core.index.sql.h2.H2ContainerDao;
import org.eclipse.dltk.internal.core.index.sql.h2.H2ElementDao;
import org.eclipse.dltk.internal.core.index.sql.h2.H2FileDao;
import org.eclipse.dltk.internal.core.index.sql.h2.Schema;
import org.h2.jdbcx.JdbcConnectionPool;
import org.h2.tools.DeleteDbFiles;

public class H2DbFactory
extends DbFactory {
    private static final String DB_NAME = "model";
    private static final String DB_USER = "";
    private static final String DB_PASS = "";
    private JdbcConnectionPool pool;

    public H2DbFactory() throws Exception {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        IPath dbPath = H2Index.getDefault().getStateLocation();
        String connString = this.getConnectionString(dbPath);
        this.pool = JdbcConnectionPool.create((String)connString, (String)"", (String)"");
        Schema schema = new Schema();
        boolean initializeSchema = false;
        int tries = 2;
        Connection connection = null;
        do {
            try {
                connection = this.pool.getConnection();
                try {
                    block19: {
                        Statement statement = connection.createStatement();
                        try {
                            try {
                                statement.executeQuery("SELECT COUNT(*) FROM FILES WHERE 1=0;");
                                initializeSchema = !schema.isCompatible();
                            }
                            catch (SQLException e) {
                                initializeSchema = true;
                                statement.close();
                                break block19;
                            }
                        }
                        catch (Throwable throwable) {
                            statement.close();
                            throw throwable;
                        }
                        statement.close();
                    }
                    if (!initializeSchema) continue;
                    connection.close();
                    this.pool.dispose();
                    DeleteDbFiles.execute((String)dbPath.toOSString(), (String)DB_NAME, (boolean)true);
                    this.pool = JdbcConnectionPool.create((String)connString, (String)"", (String)"");
                    connection = this.pool.getConnection();
                    schema.initialize(connection);
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (SQLException e) {
                SqlIndex.error((String)"An exception occurred while connecting to a database. Retrying ...", (Throwable)e);
                try {
                    if (tries == 1) {
                        File folder = new File(dbPath.toOSString());
                        File[] fileArray = folder.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File f = fileArray[n2];
                            if (f.getName().startsWith("model.")) {
                                f.delete();
                            }
                            ++n2;
                        }
                        initializeSchema = true;
                        continue;
                    }
                    DeleteDbFiles.execute((String)dbPath.toOSString(), (String)DB_NAME, (boolean)true);
                }
                catch (Exception e1) {
                    SqlIndex.error((String)("An exception has occurred while removing corrupted DB: " + dbPath.toOSString()), (Throwable)e1);
                    throw e1;
                }
            }
        } while (connection == null && --tries >= 0);
    }

    private String getConnectionString(IPath dbPath) {
        IPreferencesService preferencesService = Platform.getPreferencesService();
        StringBuilder buf = new StringBuilder("jdbc:h2:").append(dbPath.append(DB_NAME).toOSString());
        buf.append(";UNDO_LOG=0");
        buf.append(";LOCK_MODE=").append(preferencesService.getInt("org.eclipse.dltk.core.index.sql.h2", "lockMode", 0, null));
        buf.append(";CACHE_TYPE=").append(preferencesService.getString("org.eclipse.dltk.core.index.sql.h2", "cacheType", null, null));
        buf.append(";CACHE_SIZE=").append(preferencesService.getInt("org.eclipse.dltk.core.index.sql.h2", "cacheSize", 0, null));
        buf.append(";QUERY_CACHE_SIZE=").append(preferencesService.getInt("org.eclipse.dltk.core.index.sql.h2", "queryCacheSize", 0, null));
        buf.append(";LARGE_RESULT_BUFFER_SIZE=").append(preferencesService.getInt("org.eclipse.dltk.core.index.sql.h2", "largeResultBufferSize", 0, null));
        buf.append(";FILE_LOCK=NO");
        return buf.toString();
    }

    public Connection createConnection() throws SQLException {
        return this.pool == null ? null : this.pool.getConnection();
    }

    public void dispose() throws SQLException {
        if (this.pool != null) {
            this.pool.dispose();
            this.pool = null;
        }
    }

    public IContainerDao getContainerDao() {
        return new H2ContainerDao();
    }

    public IElementDao getElementDao() {
        return new H2ElementDao();
    }

    public IFileDao getFileDao() {
        return new H2FileDao();
    }
}

