/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.msaa.properties;

import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.accservice.swtbridge.MSAA;
import org.eclipse.actf.visualization.gui.msaa.properties.AbstractPropertyInvokeSource;
import org.eclipse.actf.visualization.gui.msaa.properties.methods.ia1.MsaaDoDefaultActionMethod;
import org.eclipse.actf.visualization.gui.msaa.properties.methods.ia1.MsaaSelectMethod;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class Accessible1PropertySource
extends AbstractPropertyInvokeSource
implements IPropertySource {
    private AccessibleObject accObject;
    private static final String PID_HANDLE = "HANDLE";
    private static final String PID_PARENT = "PARENT";
    private static final String PID_NAME = "NAME";
    private static final String PID_ROLE = "ROLE";
    private static final String PID_STATE = "STATE";
    private static final String PID_VALUE = "VALUE";
    private static final String PID_DESCRIPTION = "DESCRIPTION";
    private static final String PID_CHILDREN = "CHILDREN";
    private static final String PID_DEFAULTACTION = "DEFAULTACTION";
    private static final String PID_LOCATION = "LOCATION";
    private static final String PID_KEYBOARDSHORTCUT = "KEYBOARDSHORTCUT";
    private static final String PID_HELP = "HELP";
    private static final String PID_HELPTOPIC = "HELPTOPIC";
    private static final String PID_DO_DEFAULTACTION = "DO_DEFAULTACTION";
    private static final String PID_SELECT = "SELECT";
    private static final IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"HANDLE", "Window Handle"), new PropertyDescriptor((Object)"PARENT", "Parent"), new PropertyDescriptor((Object)"NAME", "Name"), new PropertyDescriptor((Object)"ROLE", "Role"), new PropertyDescriptor((Object)"STATE", "State"), new PropertyDescriptor((Object)"VALUE", "Value"), new PropertyDescriptor((Object)"DESCRIPTION", "Description"), new PropertyDescriptor((Object)"CHILDREN", "Children"), new PropertyDescriptor((Object)"DEFAULTACTION", "DefaultAction"), new PropertyDescriptor((Object)"LOCATION", "Location"), new PropertyDescriptor((Object)"KEYBOARDSHORTCUT", "Keyboard Shortcut"), new PropertyDescriptor((Object)"HELP", "Help"), new PropertyDescriptor((Object)"HELPTOPIC", "Help Topic")};
    private static final IPropertyDescriptor[] descriptorsEx = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"DO_DEFAULTACTION", "accDoDefaultAction"), new PropertyDescriptor((Object)"SELECT", "accSelect")};

    public Accessible1PropertySource(AccessibleObject accessibleObject) {
        this.accObject = accessibleObject;
        this.addMethodData(PID_SELECT, new MsaaSelectMethod(this.accObject));
        this.addMethodData(PID_DO_DEFAULTACTION, new MsaaDoDefaultActionMethod(this.accObject));
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    public IPropertyDescriptor[] getPropertyDescriptorsExtra() {
        return descriptorsEx;
    }

    public Object getPropertyValue(Object object) {
        String[] stringArray;
        int[] nArray;
        Object object2 = super.getPropertyValue(object);
        if (object2 != null) {
            return object2;
        }
        String string = null;
        if (PID_HANDLE.equals(object)) {
            string = "0x" + Integer.toHexString(this.accObject.getWindow());
            String string2 = this.accObject.getClassName();
            if (string2 != null && string2.length() > 0) {
                string = String.valueOf(string) + " [" + string2 + "]";
            }
        } else if (PID_PARENT.equals(object)) {
            AccessibleObject accessibleObject = this.accObject.getCachedParent();
            if (accessibleObject != null) {
                string = accessibleObject.getAccName();
            }
        } else if (PID_NAME.equals(object)) {
            string = this.accObject.getAccName();
        } else if (PID_ROLE.equals(object)) {
            int n = this.accObject.getRealAccRole();
            string = this.accObject.getRealRoleText();
            if (string != null) {
                string = String.valueOf(string) + " (0x" + Integer.toHexString(n) + ")";
            }
        } else if (PID_STATE.equals(object)) {
            int n = this.accObject.getAccState();
            string = MSAA.getStateText(n);
            if (string != null) {
                string = String.valueOf(string) + " (0x" + Integer.toHexString(n) + ")";
            }
        } else if (PID_VALUE.equals(object)) {
            string = this.accObject.getAccValue();
        } else if (PID_DESCRIPTION.equals(object)) {
            string = this.accObject.getAccDescription();
        } else if (PID_CHILDREN.equals(object)) {
            string = Integer.toString(this.accObject.getChildCount());
        } else if (PID_DEFAULTACTION.equals(object)) {
            string = this.accObject.getAccDefaultAction();
        } else if (PID_LOCATION.equals(object)) {
            Rectangle rectangle = this.accObject.getAccLocation();
            if (rectangle != null) {
                string = String.valueOf(rectangle.x) + ", " + rectangle.y + ", " + (rectangle.x + rectangle.width) + ", " + (rectangle.y + rectangle.height) + " (width=" + rectangle.width + ", height=" + rectangle.height + ")";
            }
        } else if (PID_KEYBOARDSHORTCUT.equals(object)) {
            string = this.accObject.getAccKeyboardShortcut();
        } else if (PID_HELP.equals(object)) {
            string = this.accObject.getAccHelp();
        } else if (PID_HELPTOPIC.equals(object) && this.accObject.getAccHelpTopic(nArray = new int[1], stringArray = new String[1])) {
            string = "Help Topic: Topic #" + nArray[0];
            if (stringArray[0] != null) {
                string = String.valueOf(string) + " in " + stringArray[0];
            }
        }
        return string == null ? "null" : string;
    }

    public boolean isPropertySet(Object object) {
        return false;
    }

    public void resetPropertyValue(Object object) {
    }

    public void setPropertyValue(Object object, Object object2) {
    }
}

