/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.editor.api.pages;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.editor.SessionEditor;
import org.eclipse.sirius.ui.editor.api.pages.AbstractSessionEditorPage;
import org.eclipse.sirius.ui.editor.api.pages.PageProvider;
import org.eclipse.sirius.ui.editor.internal.pages.PageOrderer;
import org.eclipse.sirius.ui.editor.internal.pages.PageProviderListener;

public class PageProviderRegistry {
    private final Set<PageProviderListener> pageProviderListeners;
    private final List<PageProvider> pageProviders = new CopyOnWriteArrayList<PageProvider>();
    private PageOrderer pageOrderer;

    public PageProviderRegistry() {
        this.pageProviderListeners = new HashSet<PageProviderListener>();
        this.pageOrderer = new PageOrderer();
    }

    public void addPageProvider(PageProvider newPageProvider) {
        this.pageProviders.add(newPageProvider);
        for (PageProviderListener pageProviderListener : this.pageProviderListeners) {
            pageProviderListener.pageProviderChanged();
        }
    }

    public void addRegistryListener(PageProviderListener pageProviderListener) {
        this.pageProviderListeners.add(pageProviderListener);
    }

    public void removeRegistryListener(PageProviderListener pageProviderListener) {
        this.pageProviderListeners.remove(pageProviderListener);
    }

    public void removePageProvider(PageProvider pageProvider) {
        this.pageProviders.remove(pageProvider);
        for (PageProviderListener pageProviderListener : this.pageProviderListeners) {
            pageProviderListener.pageProviderChanged();
        }
    }

    public List<AbstractSessionEditorPage> getPagesOrdered(SessionEditor editor, Session session, List<AbstractSessionEditorPage> displayedPages, ResourceSetChangeEvent event) {
        List<AbstractSessionEditorPage> pagesOrdered = this.pageOrderer.getOrderedPages(this.pageProviders, editor, displayedPages, event);
        return pagesOrdered;
    }

    public static enum PositioningKind {
        BEFORE,
        AFTER,
        REPLACE;

    }
}

