/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.repair;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.migration.AirdResourceVersionMismatchException;
import org.eclipse.sirius.business.api.repair.SiriusRepairProcess;
import org.eclipse.sirius.business.internal.migration.resource.MigrationUtil;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.ui.tools.internal.actions.repair.RepresentationFilesNeedCloseSessionValidator;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public class RepresentationFilesRepairAction
extends ActionDelegate {
    public static final String REPAIR_ACTION_LABEL = Messages.RepresentationFilesRepairValidator_repairActionLabel;
    protected IFile file;

    public void run(IAction action) {
        if (this.file != null) {
            try {
                IStatus validationStatus = new RepresentationFilesNeedCloseSessionValidator(REPAIR_ACTION_LABEL).validate(this.file);
                if (validationStatus.isOK()) {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            block5: {
                                try {
                                    this.repair(monitor);
                                }
                                catch (AirdResourceVersionMismatchException e) {
                                    UICallBack uiCallback = SiriusEditPlugin.getPlugin().getUiCallback();
                                    if (uiCallback == null || !uiCallback.askSessionReopeningWithResourceVersionMismatch(e)) break block5;
                                    try {
                                        MigrationUtil.ignoreVersionMismatch = true;
                                        this.repair(monitor);
                                    }
                                    finally {
                                        MigrationUtil.ignoreVersionMismatch = false;
                                    }
                                }
                            }
                        }

                        private void repair(IProgressMonitor monitor) throws InterruptedException {
                            SiriusRepairProcess process = new SiriusRepairProcess(RepresentationFilesRepairAction.this.file, true);
                            process.run(monitor);
                            process.dispose();
                        }
                    });
                }
            }
            catch (InvocationTargetException e) {
                this.dispose();
                Status status = new Status(4, "org.eclipse.sirius", Messages.RepresentationFilesRepairAction_repairFailed, e.getCause());
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.RepresentationFilesRepairAction_repairError, (String)Messages.RepresentationFilesRepairAction_repairError, (IStatus)status);
                SiriusPlugin.getDefault().getLog().log((IStatus)status);
            }
            catch (InterruptedException e) {
                this.dispose();
                Status status = new Status(2, "org.eclipse.sirius", e.getMessage(), (Throwable)e);
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.RepresentationFilesRepairAction_repairInterrupted, (String)Messages.RepresentationFilesRepairAction_repairInterrupted, (IStatus)status);
                SiriusPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.file = null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.file = (IFile)object;
        }
    }
}

