/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.internal.widgets.IHyperlinkAdapter;
import org.eclipse.ui.forms.internal.widgets.hyperlinkkit.HyperlinkLCA;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;
import org.eclipse.ui.internal.forms.widgets.FormUtil;

public class Hyperlink
extends AbstractHyperlink {
    private String text;
    private boolean underlined;
    private String appToolTipText;
    private transient IHyperlinkAdapter hyperlinkAdapter;

    public Hyperlink(Composite parent, int style) {
        super(parent, style);
        this.initAccessible();
        this.text = "";
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IHyperlinkAdapter.class) {
            if (this.hyperlinkAdapter == null) {
                this.hyperlinkAdapter = new IHyperlinkAdapter(){
                    private Color activeForeground;
                    private Color activeBackground;
                    private int underlineMode;

                    @Override
                    public void setActiveForeground(Color activeForeground) {
                        this.activeForeground = activeForeground;
                    }

                    @Override
                    public Color getActiveForeground() {
                        return this.activeForeground;
                    }

                    @Override
                    public void setActiveBackground(Color activeBackground) {
                        this.activeBackground = activeBackground;
                    }

                    @Override
                    public Color getActiveBackground() {
                        return this.activeBackground;
                    }

                    @Override
                    public void setUnderlineMode(int underlineMode) {
                        this.underlineMode = underlineMode;
                    }

                    @Override
                    public int getUnderlineMode() {
                        return this.underlineMode;
                    }
                };
            }
            return (T)this.hyperlinkAdapter;
        }
        if (adapter == WidgetLCA.class) {
            return (T)((Object)HyperlinkLCA.INSTANCE);
        }
        return (T)super.getAdapter(adapter);
    }

    protected void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Hyperlink.this.getText();
                if (e.result == null) {
                    this.getHelp(e);
                }
            }

            public void getHelp(AccessibleEvent e) {
                e.result = Hyperlink.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = Hyperlink.this.toControl(new Point(e.x, e.y));
                e.childID = Hyperlink.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = Hyperlink.this.getBounds();
                Point pt = Hyperlink.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 30;
            }

            public void getDefaultAction(AccessibleControlEvent e) {
                e.result = SWT.getMessage((String)"SWT_Press");
            }

            public void getState(AccessibleControlEvent e) {
                int state = 0;
                if (Hyperlink.this.getSelection()) {
                    state = 6;
                }
                e.detail = state;
            }
        });
    }

    public void setUnderlined(boolean underlined) {
        this.underlined = underlined;
        this.redraw();
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int innerWidth = wHint;
        if (innerWidth != -1) {
            innerWidth -= this.marginWidth * 2;
        }
        Point textSize = this.computeTextSize(innerWidth, hHint);
        int textWidth = textSize.x + 2 * this.marginWidth;
        int textHeight = textSize.y + 2 * this.marginHeight;
        return new Point(textWidth, textHeight);
    }

    @Override
    public String getText() {
        return this.text;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.appToolTipText;
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.appToolTipText = super.getToolTipText();
    }

    public void setText(String text) {
        this.text = text != null ? text : "";
        this.redraw();
    }

    protected Point computeTextSize(int wHint, int hHint) {
        Point extent;
        GC gc = new GC((Drawable)this);
        gc.setFont(this.getFont());
        if ((this.getStyle() & 0x40) != 0 && wHint != -1) {
            extent = FormUtil.computeWrapSize(gc, this.getText(), wHint);
        } else {
            extent = gc.textExtent(this.getText());
            if ((this.getStyle() & 0x40) == 0 && wHint != -1) {
                extent.x = wHint;
            }
        }
        gc.dispose();
        return extent;
    }
}

