/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.servlet.internal.servlet;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.rap.http.servlet.internal.context.DispatchTargets;

public class RequestDispatcherAdaptor
implements RequestDispatcher {
    private static final String SIMPLE_NAME = RequestDispatcherAdaptor.class.getSimpleName();
    private final DispatchTargets dispatchTargets;
    private final String path;
    private String string;

    public RequestDispatcherAdaptor(DispatchTargets dispatchTargets, String path) {
        this.dispatchTargets = dispatchTargets;
        this.path = path;
    }

    public void forward(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        this.dispatchTargets.doDispatch((HttpServletRequest)request, (HttpServletResponse)response, this.path, DispatcherType.FORWARD);
    }

    public void include(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        this.dispatchTargets.doDispatch((HttpServletRequest)request, (HttpServletResponse)response, this.path, DispatcherType.INCLUDE);
    }

    public String toString() {
        String value = this.string;
        if (value == null) {
            this.string = value = String.valueOf(SIMPLE_NAME) + '[' + this.path + ", " + this.dispatchTargets + ']';
        }
        return value;
    }
}

