/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrOptional;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class FlattenSingletonUnionsTransform
extends BaseTransform {
    private FlattenSingletonUnionsTransform() {
    }

    public static IrBGP apply(IrBGP bgp) {
        if (bgp == null) {
            return null;
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        for (IrNode n : bgp.getLines()) {
            if ((n = n.transformChildren(child -> {
                if (child instanceof IrOptional) {
                    return child;
                }
                if (child instanceof IrBGP) {
                    return FlattenSingletonUnionsTransform.apply((IrBGP)child);
                }
                return child;
            })) instanceof IrUnion) {
                IrUnion u = (IrUnion)n;
                boolean branchesAllNonScoped = true;
                for (IrBGP b : u.getBranches()) {
                    if (b == null || !b.isNewScope()) continue;
                    branchesAllNonScoped = false;
                    break;
                }
                if (u.isNewScope() && (!branchesAllNonScoped || u.getBranches().size() != 1)) {
                    out.add(u);
                    continue;
                }
                if (u.getBranches().size() == 1) {
                    IrBGP only = u.getBranches().get(0);
                    out.addAll(only.getLines());
                    continue;
                }
            }
            out.add(n);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }
}

