/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.flattening;

import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.util.LinkedHashMap;
import java.util.Map;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.flattening.NodeMap;
import no.hasmac.jsonld.flattening.NodeMapBuilder;
import no.hasmac.jsonld.json.JsonProvider;
import no.hasmac.jsonld.json.JsonUtils;
import no.hasmac.jsonld.lang.Utils;

public final class Flattening {
    private JsonStructure element;
    private boolean ordered;

    private Flattening(JsonStructure element) {
        this.element = element;
        this.ordered = false;
    }

    public static Flattening with(JsonStructure element) {
        return new Flattening(element);
    }

    public Flattening ordered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public JsonArray flatten() throws JsonLdError {
        NodeMap nodeMap = new NodeMap();
        NodeMapBuilder.with(this.element, nodeMap).build();
        Map<String, Map<String, JsonValue>> defaultGraph = nodeMap.get("@default").orElseThrow(IllegalStateException::new);
        for (String graphName : Utils.index(nodeMap.graphs(), this.ordered)) {
            if ("@default".equals(graphName)) continue;
            Map<String, Map<String, JsonValue>> graph = nodeMap.get(graphName).orElseThrow(IllegalStateException::new);
            if (!defaultGraph.containsKey(graphName)) {
                defaultGraph.put(graphName, (Map<String, JsonValue>)JsonProvider.instance().createObjectBuilder().add("@id", graphName).build());
            }
            LinkedHashMap<String, JsonValue> entry = new LinkedHashMap<String, JsonValue>(defaultGraph.get(graphName));
            JsonArrayBuilder graphArray = JsonProvider.instance().createArrayBuilder();
            for (String id : Utils.index(graph.keySet(), this.ordered)) {
                Map<String, JsonValue> node = graph.get(id);
                if (node == null || node.size() == 1 && node.containsKey("@id")) continue;
                graphArray.add((JsonValue)JsonUtils.toJsonObject(node));
            }
            entry.put("@graph", (JsonValue)graphArray.build());
            defaultGraph.put(graphName, entry);
        }
        JsonArrayBuilder flattened = JsonProvider.instance().createArrayBuilder();
        for (String id : Utils.index(defaultGraph.keySet(), this.ordered)) {
            Map<String, JsonValue> node = defaultGraph.get(id);
            if (node == null || node.size() == 1 && node.containsKey("@id")) continue;
            flattened.add((JsonValue)JsonUtils.toJsonObject(node));
        }
        return flattened.build();
    }
}

