/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.elasticsearch;

import java.io.IOException;
import org.eclipse.rdf4j.sail.elasticsearch.ElasticsearchDocument;
import org.eclipse.rdf4j.sail.lucene.BulkUpdater;
import org.eclipse.rdf4j.sail.lucene.SearchDocument;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.Client;

public class ElasticsearchBulkUpdater
implements BulkUpdater {
    private final Client client;
    private final BulkRequestBuilder bulkRequest;

    public ElasticsearchBulkUpdater(Client client) {
        this.client = client;
        this.bulkRequest = client.prepareBulk();
    }

    public void add(SearchDocument doc) {
        ElasticsearchDocument esDoc = (ElasticsearchDocument)doc;
        this.bulkRequest.add(this.client.prepareIndex(esDoc.getIndex(), esDoc.getType(), esDoc.getId()).setSource(esDoc.getSource()));
    }

    public void update(SearchDocument doc) {
        ElasticsearchDocument esDoc = (ElasticsearchDocument)doc;
        this.bulkRequest.add(this.client.prepareUpdate(esDoc.getIndex(), esDoc.getType(), esDoc.getId()).setIfSeqNo(esDoc.getSeqNo()).setIfPrimaryTerm(esDoc.getPrimaryTerm()).setDoc(esDoc.getSource()));
    }

    public void delete(SearchDocument doc) {
        ElasticsearchDocument esDoc = (ElasticsearchDocument)doc;
        this.bulkRequest.add(this.client.prepareDelete(esDoc.getIndex(), esDoc.getType(), esDoc.getId()).setIfSeqNo(esDoc.getSeqNo()).setIfPrimaryTerm(esDoc.getPrimaryTerm()));
    }

    public void end() throws IOException {
        BulkResponse response;
        if (this.bulkRequest.numberOfActions() > 0 && (response = (BulkResponse)this.bulkRequest.execute().actionGet()).hasFailures()) {
            throw new IOException(response.buildFailureMessage());
        }
    }
}

