/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.helpers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.common.transaction.QueryEvaluationMode;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.helpers.AbstractSailConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSail
implements Sail {
    protected static final long DEFAULT_CONNECTION_TIMEOUT = 20000L;
    private IsolationLevel defaultIsolationLevel = IsolationLevels.READ_COMMITTED;
    private QueryEvaluationMode defaultQueryEvaluationMode = QueryEvaluationMode.STRICT;
    private List<IsolationLevel> supportedIsolationLevels = new ArrayList<IsolationLevel>();
    protected static final long DEFAULT_ITERATION_SYNC_THRESHOLD = 0L;
    static final String DEBUG_PROP = "org.eclipse.rdf4j.repository.debug";
    private static final Logger logger = LoggerFactory.getLogger(AbstractSail.class);
    private volatile File dataDir;
    private volatile boolean initialized = false;
    protected final ReentrantReadWriteLock initializationLock = new ReentrantReadWriteLock();
    protected volatile long connectionTimeOut = 20000L;
    private long iterationCacheSyncThreshold = 0L;
    private boolean trackResultSize;
    private final Map<SailConnection, Throwable> activeConnections = new IdentityHashMap<SailConnection, Throwable>();

    protected static boolean debugEnabled() {
        try {
            String value = System.getProperty(DEBUG_PROP);
            return value != null && !value.equals("false");
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public AbstractSail() {
        this.addSupportedIsolationLevel(IsolationLevels.READ_UNCOMMITTED);
        this.addSupportedIsolationLevel(IsolationLevels.SERIALIZABLE);
    }

    public void setConnectionTimeOut(long connectionTimeOut) {
        this.connectionTimeOut = connectionTimeOut;
    }

    @Override
    public void setDataDir(File dataDir) {
        if (this.isInitialized()) {
            throw new IllegalStateException("sail has already been initialized");
        }
        this.dataDir = dataDir;
    }

    @Override
    public File getDataDir() {
        return this.dataDir;
    }

    public String toString() {
        if (this.dataDir == null) {
            return super.toString();
        }
        return this.dataDir.toString();
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void init() throws SailException {
        this.initializationLock.writeLock().lock();
        try {
            if (this.isInitialized()) {
                return;
            }
            this.initializeInternal();
            this.initialized = true;
        }
        finally {
            this.initializationLock.writeLock().unlock();
        }
    }

    protected void initializeInternal() throws SailException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutDown() throws SailException {
        this.initializationLock.writeLock().lock();
        try {
            SailConnection con;
            IdentityHashMap<SailConnection, Throwable> activeConnectionsCopy;
            if (!this.isInitialized()) {
                return;
            }
            Object object = this.activeConnections;
            synchronized (object) {
                if (!this.activeConnections.isEmpty()) {
                    logger.debug("Waiting for active connections to close before shutting down...");
                    try {
                        this.activeConnections.wait(this.connectionTimeOut);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                activeConnectionsCopy = new IdentityHashMap<SailConnection, Throwable>(this.activeConnections);
            }
            for (Map.Entry entry : activeConnectionsCopy.entrySet()) {
                try {
                    AbstractSailConnection sailCon;
                    Thread owner;
                    con = (SailConnection)entry.getKey();
                    if (!(con instanceof AbstractSailConnection) || (owner = (sailCon = (AbstractSailConnection)con).getOwner()) == Thread.currentThread()) continue;
                    owner.interrupt();
                    owner.join(1000L);
                    if (!owner.isAlive()) continue;
                    logger.error("Closing active connection due to shut down and interrupted the owning thread of the connection {} but thread is still alive after 1000 ms!", (Object)owner);
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        throw new SailException(e);
                    }
                    if (e instanceof AssertionError || !(e instanceof Error)) continue;
                    throw (Error)e;
                }
            }
            for (Map.Entry entry : activeConnectionsCopy.entrySet()) {
                con = (SailConnection)entry.getKey();
                Throwable stackTrace = (Throwable)entry.getValue();
                if (stackTrace == null) {
                    logger.warn("Closing active connection due to shut down; consider setting the {} system property", (Object)DEBUG_PROP);
                } else {
                    logger.warn("Closing active connection due to shut down, connection was acquired in", stackTrace);
                }
                try {
                    con.close();
                }
                catch (SailException e) {
                    logger.error("Failed to close connection", (Throwable)((Object)e));
                }
            }
            object = this.activeConnections;
            synchronized (object) {
                this.activeConnections.clear();
            }
            this.shutDownInternal();
        }
        finally {
            this.initialized = false;
            this.initializationLock.writeLock().unlock();
        }
    }

    protected abstract void shutDownInternal() throws SailException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SailConnection getConnection() throws SailException {
        if (!this.isInitialized()) {
            this.init();
        }
        this.initializationLock.readLock().lock();
        try {
            SailConnection connection = this.getConnectionInternal();
            Throwable stackTrace = AbstractSail.debugEnabled() ? new Throwable() : null;
            Object object = this.activeConnections;
            synchronized (object) {
                this.activeConnections.put(connection, stackTrace);
            }
            object = connection;
            return object;
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }

    protected abstract SailConnection getConnectionInternal() throws SailException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionClosed(SailConnection connection) {
        Map<SailConnection, Throwable> map = this.activeConnections;
        synchronized (map) {
            if (this.activeConnections.containsKey(connection)) {
                this.activeConnections.remove(connection);
                if (this.activeConnections.isEmpty()) {
                    this.activeConnections.notifyAll();
                }
            } else {
                logger.warn("tried to remove unknown connection object from store.");
            }
        }
    }

    protected void addSupportedIsolationLevel(IsolationLevels level) {
        this.supportedIsolationLevels.add((IsolationLevel)level);
    }

    protected void removeSupportedIsolationLevel(IsolationLevel level) {
        while (this.supportedIsolationLevels.remove(level)) {
        }
    }

    protected void setSupportedIsolationLevels(List<IsolationLevel> supportedIsolationLevels) {
        this.supportedIsolationLevels = supportedIsolationLevels;
    }

    protected void setSupportedIsolationLevels(IsolationLevel ... supportedIsolationLevels) {
        this.supportedIsolationLevels = Arrays.asList(supportedIsolationLevels);
    }

    @Override
    public List<IsolationLevel> getSupportedIsolationLevels() {
        return Collections.unmodifiableList(this.supportedIsolationLevels);
    }

    @Override
    public IsolationLevel getDefaultIsolationLevel() {
        return this.defaultIsolationLevel;
    }

    public void setDefaultIsolationLevel(IsolationLevel defaultIsolationLevel) {
        if (defaultIsolationLevel == null) {
            throw new IllegalArgumentException("default isolation level may not be null");
        }
        this.defaultIsolationLevel = defaultIsolationLevel;
    }

    public long getIterationCacheSyncThreshold() {
        return this.iterationCacheSyncThreshold;
    }

    public void setIterationCacheSyncThreshold(long iterationCacheSyncThreshold) {
        this.iterationCacheSyncThreshold = iterationCacheSyncThreshold;
    }

    public boolean isTrackResultSize() {
        return this.trackResultSize;
    }

    public void setTrackResultSize(boolean trackResultSize) {
        this.trackResultSize = trackResultSize;
    }

    public QueryEvaluationMode getDefaultQueryEvaluationMode() {
        return this.defaultQueryEvaluationMode;
    }

    public void setDefaultQueryEvaluationMode(QueryEvaluationMode defaultQueryEvaluationMode) {
        this.defaultQueryEvaluationMode = Objects.requireNonNull(defaultQueryEvaluationMode);
    }
}

