/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code.flow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowContext;

public abstract class FlowInfo {
    protected static final int NOT_POSSIBLE = 0;
    protected static final int UNDEFINED = 1;
    protected static final int NO_RETURN = 2;
    protected static final int PARTIAL_RETURN = 3;
    protected static final int VOID_RETURN = 4;
    protected static final int VALUE_RETURN = 5;
    protected static final int THROW = 6;
    public static final int UNUSED = 1;
    public static final int READ = 2;
    public static final int READ_POTENTIAL = 4;
    public static final int WRITE = 8;
    public static final int WRITE_POTENTIAL = 16;
    public static final int UNKNOWN = 32;
    private static final int[][] ACCESS_MODE_CONDITIONAL_TABLE = new int[][]{{1, 4, 4, 16, 16, 32}, {4, 2, 4, 32, 32, 32}, {4, 4, 4, 32, 32, 32}, {16, 32, 32, 8, 16, 32}, {16, 32, 32, 16, 16, 32}, {32, 32, 32, 32, 32, 32}};
    private static final int[] ACCESS_MODE_OPEN_BRANCH_TABLE = new int[]{1, 4, 4, 16, 16, 32};
    private static final int[][] RETURN_KIND_CONDITIONAL_TABLE;
    private static final int[][] RETURN_KIND_SEQUENTIAL_TABLE;
    protected static final String UNLABELED = "@unlabeled";
    protected static final IVariableBinding[] EMPTY_ARRAY;
    protected int fReturnKind;
    protected int[] fAccessModes;
    protected Set<String> fBranches;
    protected Set<ITypeBinding> fTypeVariables;

    static {
        int[][] nArrayArray = new int[7][];
        nArrayArray[0] = new int[7];
        int[] nArray = new int[7];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[7];
        nArray2[1] = 2;
        nArray2[2] = 2;
        nArray2[3] = 3;
        nArray2[4] = 3;
        nArray2[5] = 3;
        nArray2[6] = 2;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[7];
        nArray3[1] = 3;
        nArray3[2] = 3;
        nArray3[3] = 3;
        nArray3[4] = 3;
        nArray3[5] = 3;
        nArray3[6] = 3;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[7];
        nArray4[1] = 4;
        nArray4[2] = 3;
        nArray4[3] = 3;
        nArray4[4] = 4;
        nArray4[6] = 4;
        nArrayArray[4] = nArray4;
        int[] nArray5 = new int[7];
        nArray5[1] = 5;
        nArray5[2] = 3;
        nArray5[3] = 3;
        nArray5[5] = 5;
        nArray5[6] = 5;
        nArrayArray[5] = nArray5;
        int[] nArray6 = new int[7];
        nArray6[1] = 6;
        nArray6[2] = 2;
        nArray6[3] = 3;
        nArray6[4] = 4;
        nArray6[5] = 5;
        nArray6[6] = 6;
        nArrayArray[6] = nArray6;
        RETURN_KIND_CONDITIONAL_TABLE = nArrayArray;
        int[][] nArrayArray2 = new int[7][];
        nArrayArray2[0] = new int[7];
        int[] nArray7 = new int[7];
        nArray7[1] = 1;
        nArray7[2] = 2;
        nArray7[3] = 3;
        nArray7[4] = 4;
        nArray7[5] = 5;
        nArray7[6] = 6;
        nArrayArray2[1] = nArray7;
        int[] nArray8 = new int[7];
        nArray8[1] = 2;
        nArray8[2] = 2;
        nArray8[3] = 3;
        nArray8[4] = 4;
        nArray8[5] = 5;
        nArray8[6] = 6;
        nArrayArray2[2] = nArray8;
        int[] nArray9 = new int[7];
        nArray9[1] = 3;
        nArray9[2] = 3;
        nArray9[3] = 3;
        nArray9[4] = 4;
        nArray9[5] = 5;
        nArray9[6] = 5;
        nArrayArray2[3] = nArray9;
        int[] nArray10 = new int[7];
        nArray10[1] = 4;
        nArray10[2] = 4;
        nArray10[3] = 3;
        nArray10[4] = 4;
        nArrayArray2[4] = nArray10;
        int[] nArray11 = new int[7];
        nArray11[1] = 5;
        nArray11[2] = 5;
        nArray11[3] = 3;
        nArray11[5] = 5;
        nArrayArray2[5] = nArray11;
        int[] nArray12 = new int[7];
        nArray12[1] = 6;
        nArray12[2] = 6;
        nArray12[3] = 5;
        nArray12[4] = 4;
        nArray12[5] = 5;
        nArray12[6] = 6;
        nArrayArray2[6] = nArray12;
        RETURN_KIND_SEQUENTIAL_TABLE = nArrayArray2;
        EMPTY_ARRAY = new IVariableBinding[0];
    }

    protected FlowInfo() {
        this(1);
    }

    protected FlowInfo(int returnKind) {
        this.fReturnKind = returnKind;
    }

    protected void assignExecutionFlow(FlowInfo right) {
        this.fReturnKind = right.fReturnKind;
        this.fBranches = right.fBranches;
    }

    protected void assignAccessMode(FlowInfo right) {
        this.fAccessModes = right.fAccessModes;
    }

    protected void assign(FlowInfo right) {
        this.assignExecutionFlow(right);
        this.assignAccessMode(right);
    }

    protected void mergeConditional(FlowInfo info, FlowContext context) {
        this.mergeAccessModeConditional(info, context);
        this.mergeExecutionFlowConditional(info);
        this.mergeTypeVariablesConditional(info);
    }

    protected void mergeSequential(FlowInfo info, FlowContext context) {
        this.mergeAccessModeSequential(info, context);
        this.mergeExecutionFlowSequential(info);
        this.mergeTypeVariablesSequential(info);
    }

    public void setNoReturn() {
        this.fReturnKind = 2;
    }

    public boolean isUndefined() {
        return this.fReturnKind == 1;
    }

    public boolean isNoReturn() {
        return this.fReturnKind == 2;
    }

    public boolean isPartialReturn() {
        return this.fReturnKind == 3;
    }

    public boolean isVoidReturn() {
        return this.fReturnKind == 4;
    }

    public boolean isValueReturn() {
        return this.fReturnKind == 5;
    }

    public boolean isThrow() {
        return this.fReturnKind == 6;
    }

    public boolean isReturn() {
        return this.fReturnKind == 4 || this.fReturnKind == 5;
    }

    public boolean branches() {
        return this.fBranches != null && !this.fBranches.isEmpty();
    }

    protected Set<String> getBranches() {
        return this.fBranches;
    }

    protected void removeLabel(SimpleName label) {
        if (this.fBranches != null) {
            this.fBranches.remove(FlowInfo.makeString(label));
            if (this.fBranches.isEmpty()) {
                this.fBranches = null;
            }
        }
    }

    protected static String makeString(SimpleName label) {
        if (label == null) {
            return UNLABELED;
        }
        return label.getIdentifier();
    }

    public ITypeBinding[] getTypeVariables() {
        if (this.fTypeVariables == null) {
            return new ITypeBinding[0];
        }
        return this.fTypeVariables.toArray(new ITypeBinding[this.fTypeVariables.size()]);
    }

    protected void addTypeVariable(ITypeBinding typeParameter) {
        if (this.fTypeVariables == null) {
            this.fTypeVariables = new HashSet<ITypeBinding>();
        }
        this.fTypeVariables.add(typeParameter);
    }

    private void mergeTypeVariablesSequential(FlowInfo otherInfo) {
        this.fTypeVariables = FlowInfo.mergeSets(this.fTypeVariables, otherInfo.fTypeVariables);
    }

    private void mergeTypeVariablesConditional(FlowInfo otherInfo) {
        this.fTypeVariables = FlowInfo.mergeSets(this.fTypeVariables, otherInfo.fTypeVariables);
    }

    private void mergeExecutionFlowSequential(FlowInfo otherInfo) {
        int other = otherInfo.fReturnKind;
        if (this.branches() && other == 5) {
            other = 3;
        }
        this.fReturnKind = RETURN_KIND_SEQUENTIAL_TABLE[this.fReturnKind][other];
        this.mergeBranches(otherInfo);
    }

    private void mergeExecutionFlowConditional(FlowInfo otherInfo) {
        this.fReturnKind = RETURN_KIND_CONDITIONAL_TABLE[this.fReturnKind][otherInfo.fReturnKind];
        this.mergeBranches(otherInfo);
    }

    private void mergeBranches(FlowInfo otherInfo) {
        this.fBranches = FlowInfo.mergeSets(this.fBranches, otherInfo.fBranches);
    }

    private static <T> Set<T> mergeSets(Set<T> thisSet, Set<T> otherSet) {
        if (otherSet != null) {
            if (thisSet == null) {
                thisSet = otherSet;
            } else {
                Iterator<T> iter = otherSet.iterator();
                while (iter.hasNext()) {
                    thisSet.add(iter.next());
                }
            }
        }
        return thisSet;
    }

    public IVariableBinding[] get(FlowContext context, int mode) {
        ArrayList<IVariableBinding> result = new ArrayList<IVariableBinding>();
        int[] locals = this.getAccessModes();
        if (locals == null) {
            return EMPTY_ARRAY;
        }
        int i = 0;
        while (i < locals.length) {
            int accessMode = locals[i];
            if ((accessMode & mode) != 0) {
                result.add(context.getLocalFromIndex(i));
            }
            ++i;
        }
        return result.toArray(new IVariableBinding[result.size()]);
    }

    public boolean hasAccessMode(FlowContext context, IVariableBinding local, int mode) {
        boolean unusedMode;
        boolean bl = unusedMode = (mode & 1) != 0;
        if (this.fAccessModes == null && unusedMode) {
            return true;
        }
        int index = context.getIndexFromLocal(local);
        if (index == -1) {
            return unusedMode;
        }
        return (this.fAccessModes[index] & mode) != 0;
    }

    public int getAccessMode(FlowContext context, IVariableBinding local) {
        if (this.fAccessModes == null) {
            return 1;
        }
        int index = context.getIndexFromLocal(local);
        if (index == -1) {
            return 1;
        }
        return this.fAccessModes[index];
    }

    protected int[] getAccessModes() {
        return this.fAccessModes;
    }

    protected void clearAccessMode(IVariableBinding binding, FlowContext context) {
        if (this.fAccessModes == null) {
            return;
        }
        this.fAccessModes[binding.getVariableId() - context.getStartingIndex()] = 1;
    }

    protected void mergeAccessModeSequential(FlowInfo otherInfo, FlowContext context) {
        if (!context.considerAccessMode()) {
            return;
        }
        int[] others = otherInfo.fAccessModes;
        if (others == null) {
            return;
        }
        if (this.branches()) {
            int i = 0;
            while (i < others.length) {
                others[i] = ACCESS_MODE_OPEN_BRANCH_TABLE[FlowInfo.getIndex(others[i])];
                ++i;
            }
        }
        if (this.fAccessModes == null) {
            this.fAccessModes = others;
            return;
        }
        if (context.computeArguments()) {
            this.handleComputeArguments(others);
        } else if (context.computeReturnValues()) {
            this.handleComputeReturnValues(others);
        } else if (context.computeMerge()) {
            this.handleMergeValues(others);
        }
    }

    private void handleComputeReturnValues(int[] others) {
        int i = 0;
        while (i < this.fAccessModes.length) {
            int accessmode = this.fAccessModes[i];
            int othermode = others[i];
            if (accessmode != 8) {
                if (accessmode == 16) {
                    if (othermode == 8) {
                        this.fAccessModes[i] = 8;
                    }
                } else if (others[i] != 1) {
                    this.fAccessModes[i] = othermode;
                }
            }
            ++i;
        }
    }

    private void handleComputeArguments(int[] others) {
        int i = 0;
        while (i < this.fAccessModes.length) {
            int accessMode = this.fAccessModes[i];
            int otherMode = others[i];
            if (accessMode == 1 || accessMode == 16 && (otherMode == 2 || otherMode == 4)) {
                this.fAccessModes[i] = otherMode;
            } else if (accessMode == 16 && otherMode == 8) {
                this.fAccessModes[i] = 8;
            }
            ++i;
        }
    }

    private void handleMergeValues(int[] others) {
        int i = 0;
        while (i < this.fAccessModes.length) {
            this.fAccessModes[i] = ACCESS_MODE_CONDITIONAL_TABLE[FlowInfo.getIndex(this.fAccessModes[i])][FlowInfo.getIndex(others[i])];
            ++i;
        }
    }

    protected void createAccessModeArray(FlowContext context) {
        this.fAccessModes = new int[context.getArrayLength()];
        Arrays.fill(this.fAccessModes, 1);
    }

    protected void mergeAccessModeConditional(FlowInfo otherInfo, FlowContext context) {
        if (!context.considerAccessMode()) {
            return;
        }
        int[] others = otherInfo.fAccessModes;
        if (this.fAccessModes == null) {
            if (others != null) {
                this.fAccessModes = others;
            } else {
                this.createAccessModeArray(context);
            }
            return;
        }
        if (others == null) {
            int i = 0;
            while (i < this.fAccessModes.length) {
                int unused_index = FlowInfo.getIndex(1);
                this.fAccessModes[i] = ACCESS_MODE_CONDITIONAL_TABLE[FlowInfo.getIndex(this.fAccessModes[i])][unused_index];
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.fAccessModes.length) {
                this.fAccessModes[i] = ACCESS_MODE_CONDITIONAL_TABLE[FlowInfo.getIndex(this.fAccessModes[i])][FlowInfo.getIndex(others[i])];
                ++i;
            }
        }
    }

    protected void mergeEmptyCondition(FlowContext context) {
        if (this.fReturnKind == 5 || this.fReturnKind == 4) {
            this.fReturnKind = 3;
        }
        if (!context.considerAccessMode()) {
            return;
        }
        if (this.fAccessModes == null) {
            this.createAccessModeArray(context);
            return;
        }
        int unused_index = FlowInfo.getIndex(1);
        int i = 0;
        while (i < this.fAccessModes.length) {
            this.fAccessModes[i] = ACCESS_MODE_CONDITIONAL_TABLE[FlowInfo.getIndex(this.fAccessModes[i])][unused_index];
            ++i;
        }
    }

    private static int getIndex(int accessMode) {
        switch (accessMode) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 32: {
                return 5;
            }
        }
        return -1;
    }
}

