/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.maven.provider;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.StyledString;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.maven.Coordinate;
import org.eclipse.oomph.maven.MavenPackage;
import org.eclipse.oomph.maven.provider.DOMElementItemProvider;

public class CoordinateItemProvider
extends DOMElementItemProvider {
    public CoordinateItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addGroupIdPropertyDescriptor(object);
            this.addArtifactIdPropertyDescriptor(object);
            this.addVersionPropertyDescriptor(object);
            this.addExpandedGroupIdPropertyDescriptor(object);
            this.addExpandedVersionPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addGroupIdPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Coordinate_groupId_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Coordinate_groupId_feature", "_UI_Coordinate_type"), (EStructuralFeature)MavenPackage.Literals.COORDINATE__GROUP_ID, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addArtifactIdPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Coordinate_artifactId_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Coordinate_artifactId_feature", "_UI_Coordinate_type"), (EStructuralFeature)MavenPackage.Literals.COORDINATE__ARTIFACT_ID, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addVersionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Coordinate_version_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Coordinate_version_feature", "_UI_Coordinate_type"), (EStructuralFeature)MavenPackage.Literals.COORDINATE__VERSION, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addExpandedGroupIdPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Coordinate_expandedGroupId_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Coordinate_expandedGroupId_feature", "_UI_Coordinate_type"), (EStructuralFeature)MavenPackage.Literals.COORDINATE__EXPANDED_GROUP_ID, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addExpandedVersionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Coordinate_expandedVersion_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Coordinate_expandedVersion_feature", "_UI_Coordinate_type"), (EStructuralFeature)MavenPackage.Literals.COORDINATE__EXPANDED_VERSION, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Coordinate"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    public StyledString getStyledText(Object object) {
        String expandedGroupId;
        Coordinate coordinate = (Coordinate)object;
        StyledString styledLabel = new StyledString();
        String groupId = coordinate.getGroupId();
        if (Objects.equals(groupId, expandedGroupId = coordinate.getExpandedGroupId())) {
            styledLabel.append(groupId);
        } else {
            styledLabel.append(groupId, StyledString.Style.QUALIFIER_STYLER);
            styledLabel.append(" = ", StyledString.Style.QUALIFIER_STYLER);
            styledLabel.append(expandedGroupId);
        }
        styledLabel.append(" : ", StyledString.Style.QUALIFIER_STYLER);
        styledLabel.append(coordinate.getArtifactId());
        String version = coordinate.getVersion();
        if (!version.isBlank()) {
            styledLabel.append(" : ", StyledString.Style.QUALIFIER_STYLER);
            String expandedVersion = coordinate.getExpandedVersion();
            if (version.equals(expandedVersion)) {
                styledLabel.append(version);
            } else {
                styledLabel.append(version, StyledString.Style.QUALIFIER_STYLER);
                styledLabel.append(" = ", StyledString.Style.QUALIFIER_STYLER);
                styledLabel.append(expandedVersion);
            }
        }
        return styledLabel;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Coordinate.class)) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

