/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms;

import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.forms.widgets.FormsResources;

public class HyperlinkSettings {
    public static final int UNDERLINE_NEVER = 1;
    public static final int UNDERLINE_HOVER = 2;
    public static final int UNDERLINE_ALWAYS = 3;
    private int hyperlinkUnderlineMode = 3;
    private Color background;
    private Color foreground;
    private Color activeBackground;
    private Color activeForeground;
    private Cursor busyCursor;
    private Cursor textCursor;
    private Cursor hyperlinkCursor;

    public HyperlinkSettings(Display display) {
        this.initializeDefaultForegrounds(display);
        this.initializeDefaultCursors();
    }

    public void initializeDefaultForegrounds(Display display) {
        Color fg = JFaceColors.getHyperlinkText((Display)display);
        Color afg = JFaceColors.getActiveHyperlinkText((Display)display);
        if (fg == null) {
            fg = display.getSystemColor(36);
        }
        this.setForeground(fg);
        this.setActiveForeground(afg);
    }

    public void initializeDefaultCursors() {
        this.setBusyCursor(FormsResources.getBusyCursor());
        this.setTextCursor(FormsResources.getTextCursor());
        this.setHyperlinkCursor(FormsResources.getHandCursor());
    }

    public Color getActiveBackground() {
        return this.activeBackground;
    }

    public Color getActiveForeground() {
        return this.activeForeground;
    }

    public Color getBackground() {
        return this.background;
    }

    public Cursor getBusyCursor() {
        return this.busyCursor;
    }

    public Cursor getTextCursor() {
        return this.textCursor;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Cursor getHyperlinkCursor() {
        return this.hyperlinkCursor;
    }

    public int getHyperlinkUnderlineMode() {
        return this.hyperlinkUnderlineMode;
    }

    public void setActiveBackground(Color newActiveBackground) {
        this.activeBackground = newActiveBackground;
    }

    public void setActiveForeground(Color newActiveForeground) {
        this.activeForeground = newActiveForeground;
    }

    public void setBackground(Color newBackground) {
        this.background = newBackground;
    }

    public void setForeground(Color newForeground) {
        this.foreground = newForeground;
    }

    public void setHyperlinkUnderlineMode(int mode) {
        this.hyperlinkUnderlineMode = mode;
    }

    public void setBusyCursor(Cursor newBusyCursor) {
        this.busyCursor = newBusyCursor;
    }

    public void setTextCursor(Cursor newTextCursor) {
        this.textCursor = newTextCursor;
    }

    public void setHyperlinkCursor(Cursor newHyperlinkCursor) {
        this.hyperlinkCursor = newHyperlinkCursor;
    }
}

