/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property;

import java.util.List;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.ListProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.property.PropertyObservableUtil;

public class ValuePropertyDetailList<S, M, T>
extends ListProperty<S, T> {
    private final IValueProperty<S, M> masterProperty;
    private final IListProperty<? super M, T> detailProperty;

    public ValuePropertyDetailList(IValueProperty<S, M> masterProperty, IListProperty<? super M, T> detailProperty) {
        this.masterProperty = masterProperty;
        this.detailProperty = detailProperty;
    }

    @Override
    public Object getElementType() {
        return this.detailProperty.getElementType();
    }

    @Override
    protected List<T> doGetList(S source) {
        M masterValue = this.masterProperty.getValue(source);
        return this.detailProperty.getList(masterValue);
    }

    @Override
    protected void doSetList(S source, List<T> list) {
        M masterValue = this.masterProperty.getValue(source);
        this.detailProperty.setList(masterValue, list);
    }

    @Override
    protected void doUpdateList(S source, ListDiff<T> diff) {
        M masterValue = this.masterProperty.getValue(source);
        this.detailProperty.updateList(masterValue, diff);
    }

    @Override
    public IObservableList<T> observe(Realm realm, S source) {
        IObservableValue<M> masterValue;
        ObservableTracker.setIgnore((boolean)true);
        try {
            masterValue = this.masterProperty.observe(realm, source);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        IObservableList<T> detailList = this.detailProperty.observeDetail(masterValue);
        PropertyObservableUtil.cascadeDispose(detailList, masterValue);
        return detailList;
    }

    @Override
    public <U extends S> IObservableList<T> observeDetail(IObservableValue<U> master) {
        IObservableValue<M> masterValue;
        ObservableTracker.setIgnore((boolean)true);
        try {
            masterValue = this.masterProperty.observeDetail(master);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        IObservableList<T> detailList = this.detailProperty.observeDetail(masterValue);
        PropertyObservableUtil.cascadeDispose(detailList, masterValue);
        return detailList;
    }

    public String toString() {
        return String.valueOf(this.masterProperty) + " => " + String.valueOf(this.detailProperty);
    }
}

