/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.actions.ExistingIUInProfileAction;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.RemediationOperation;
import org.eclipse.equinox.p2.operations.RemedyConfig;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.PlatformUI;

public class UpdateAction
extends ExistingIUInProfileAction {
    protected IUElementListRoot root;
    protected ArrayList<?> initialSelections;
    boolean resolveIsVisible = true;
    boolean skipSelectionPage = false;

    public UpdateAction(ProvisioningUI ui, ISelectionProvider selectionProvider, String profileId, boolean resolveIsVisible) {
        super(ui, ProvUI.UPDATE_COMMAND_LABEL, selectionProvider, profileId);
        this.setToolTipText(ProvUI.UPDATE_COMMAND_TOOLTIP);
        this.resolveIsVisible = resolveIsVisible;
    }

    public void setSkipSelectionPage(boolean skipSelectionPage) {
        this.skipSelectionPage = skipSelectionPage;
    }

    protected String getTaskName() {
        return ProvUIMessages.UpdateIUProgress;
    }

    protected boolean isResolveUserVisible() {
        return this.resolveIsVisible;
    }

    @Override
    protected int getLockConstant() {
        return 2;
    }

    @Override
    protected ProfileChangeOperation getProfileChangeOperation(Collection<IInstallableUnit> ius) {
        return this.ui.getUpdateOperation(ius, null);
    }

    @Override
    protected int performAction(final ProfileChangeOperation operation, Collection<IInstallableUnit> ius) {
        if (operation.getResolutionResult() == Status.OK_STATUS) {
            return this.ui.openUpdateWizard(this.skipSelectionPage, (UpdateOperation)operation, null);
        }
        if (!operation.hasResolved()) {
            return 1;
        }
        final RemediationOperation remediationOperation = new RemediationOperation(this.getSession(), operation.getProfileChangeRequest());
        ProvisioningJob job = new ProvisioningJob(ProvUIMessages.UpdateActionRemediationJobName, this.getSession()){

            public IStatus runModal(IProgressMonitor monitor) {
                monitor.beginTask(ProvUIMessages.UpdateActionRemediationJobTask, RemedyConfig.getAllRemedyConfigs().length);
                return remediationOperation.resolveModal(monitor);
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (PlatformUI.isWorkbenchRunning()) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                        int n = UpdateAction.this.ui.openUpdateWizard(UpdateAction.this.skipSelectionPage, (UpdateOperation)operation, remediationOperation, null);
                    });
                }
            }
        });
        this.getProvisioningUI().schedule(job, 3);
        return 1;
    }
}

