/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.e4.ui.internal.workbench.ExtensionsSort;
import org.eclipse.e4.ui.internal.workbench.ModelFragmentComparator;
import org.eclipse.e4.ui.internal.workbench.ModelFragmentWrapper;
import org.eclipse.e4.ui.internal.workbench.URIHelper;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.fragment.MModelFragment;
import org.eclipse.e4.ui.model.fragment.MModelFragments;
import org.eclipse.e4.ui.model.fragment.MStringModelFragment;
import org.eclipse.e4.ui.model.fragment.impl.FragmentPackageImpl;
import org.eclipse.e4.ui.model.internal.ModelUtils;
import org.eclipse.e4.ui.workbench.modeling.IModelProcessorContribution;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(service={ModelAssembler.class}, immediate=true)
public class ModelAssembler {
    private MApplication application;
    private IEclipseContext context;
    private UISynchronize uiSync;
    private boolean initial;
    private static final String EXTENSION_POINT_ID = "org.eclipse.e4.workbench.model";
    private static final String MODEL_FRAGMENT_HEADER = "Model-Fragment";
    private static final String ALWAYS = "always";
    private static final String INITIAL = "initial";
    private static final String NOTEXISTS = "notexists";
    private LoggerFactory factory;
    private Logger logger;
    private final AtomicReference<IExtensionRegistry> registry = new AtomicReference();
    private final List<ServiceReference<IModelProcessorContribution>> processorContributions = new CopyOnWriteArrayList<ServiceReference<IModelProcessorContribution>>();
    private BundleContext bundleContext;
    private BundleTracker<List<FragmentWrapperElementMapping>> tracker;
    private boolean processModelExecuted = false;

    @Activate
    void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.tracker = new BundleTracker(bundleContext, 56, (BundleTrackerCustomizer)new ModelFragmentBundleTracker());
    }

    @Deactivate
    void deactivate() {
        if (this.tracker != null) {
            this.tracker.close();
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setExtensionRegistry(IExtensionRegistry registry) {
        this.registry.set(registry);
    }

    void unsetExtensionRegistry(IExtensionRegistry registry) {
        this.registry.compareAndSet(registry, null);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    void registerModelProcessorContribution(ServiceReference<IModelProcessorContribution> contrib) {
        this.processorContributions.add(contrib);
        if (this.processModelExecuted) {
            this.uiSync.asyncExec(() -> {
                IModelProcessorContribution service = (IModelProcessorContribution)this.bundleContext.getService(contrib);
                this.runProcessor(service);
            });
        }
    }

    void unregisterModelProcessorContribution(ServiceReference<IModelProcessorContribution> contrib) {
        this.processorContributions.remove(contrib);
        IModelProcessorContribution service = (IModelProcessorContribution)this.bundleContext.getService(contrib);
        if (this.context != null) {
            this.uiSync.asyncExec(() -> {
                try {
                    ContextInjectionFactory.invoke((Object)service, PreDestroy.class, (IEclipseContext)this.context);
                }
                catch (Exception e) {
                    this.warn("Could not run PreDestroy on processor {}: {}", contrib.getClass().getName(), e);
                }
            });
        }
    }

    @PostConstruct
    public void init(MApplication application, IEclipseContext context, UISynchronize sync) {
        this.application = application;
        this.context = context;
        this.uiSync = sync;
    }

    @Execute
    public void processModel(boolean initial) {
        this.initial = initial;
        IExtensionRegistry extReg = this.registry.get();
        if (extReg != null) {
            IExtensionPoint extPoint = extReg.getExtensionPoint(EXTENSION_POINT_ID);
            IExtension[] extensions = new ExtensionsSort().sort(extPoint.getExtensions());
            this.runProcessors(extensions, initial, false);
            this.processFragments(extensions, initial);
            this.runProcessors(extensions, initial, true);
        }
        this.initial = false;
        this.processModelExecuted = true;
    }

    private void processFragments(IExtension[] extensions, boolean initial) {
        ArrayList<ModelFragmentWrapper> wrappers = new ArrayList<ModelFragmentWrapper>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] ces;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ces = extension.getConfigurationElements();
            int n3 = ces.length;
            int n4 = 0;
            while (n4 < n3) {
                MModelFragments fragmentsContainer;
                IConfigurationElement ce = iConfigurationElementArray[n4];
                if ("fragment".equals(ce.getName()) && (initial || !INITIAL.equals(ce.getAttribute("apply"))) && (fragmentsContainer = this.getFragmentsContainer(ce.getAttribute("uri"), ce.getContributor().getName())) != null) {
                    for (MModelFragment fragment : fragmentsContainer.getFragments()) {
                        boolean checkExist = !initial && NOTEXISTS.equals(ce.getAttribute("apply"));
                        wrappers.add(new ModelFragmentWrapper(fragmentsContainer, fragment, ce.getContributor().getName(), URIHelper.constructPlatformURI(ce.getContributor()), checkExist));
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (this.tracker != null) {
            this.tracker.open();
            this.tracker.getTracked().values().stream().flatMap(Collection::stream).map(FragmentWrapperElementMapping::wrapper).forEach(wrappers::add);
        }
        this.processFragmentWrappers(wrappers);
    }

    private List<ModelFragmentWrapper> getModelFragmentWrapperFromBundle(Bundle bundle, boolean initial) {
        ArrayList<ModelFragmentWrapper> wrappers = new ArrayList<ModelFragmentWrapper>();
        String fragmentHeader = (String)bundle.getHeaders("").get(MODEL_FRAGMENT_HEADER);
        String[] fr = fragmentHeader.split(";");
        if (fr.length > 0) {
            MModelFragments fragmentsContainer;
            String apply;
            String uri = fr[0];
            String string = apply = fr.length > 1 ? fr[1].split("=")[1] : ALWAYS;
            if (!(ALWAYS.equals(apply) || INITIAL.equals(apply) || NOTEXISTS.equals(apply))) {
                this.warn("Model-Fragment header apply attribute {} is invalid, falling back to always", apply);
                apply = ALWAYS;
            }
            if ((initial || !INITIAL.equals(apply)) && (fragmentsContainer = this.getFragmentsContainer(uri, bundle.getSymbolicName())) != null) {
                for (MModelFragment fragment : fragmentsContainer.getFragments()) {
                    boolean checkExist = !initial && NOTEXISTS.equals(apply);
                    wrappers.add(new ModelFragmentWrapper(fragmentsContainer, fragment, bundle.getSymbolicName(), URIHelper.constructPlatformURI(bundle), checkExist));
                }
            }
        } else {
            this.error("Model-Fragment header value {} in bundle {} is invalid", fragmentHeader, bundle.getSymbolicName());
        }
        return wrappers;
    }

    public void processFragmentWrappers(Collection<ModelFragmentWrapper> wrappers) {
        LinkedHashMap<String, Bucket> elementIdToBucket = new LinkedHashMap<String, Bucket>();
        LinkedHashMap<String, Bucket> parentIdToBuckets = new LinkedHashMap<String, Bucket>();
        for (ModelFragmentWrapper fragmentWrapper : wrappers) {
            MModelFragment fragment = fragmentWrapper.getModelFragment();
            String parentId = ((MStringModelFragment)fragment).getParentElementId();
            Bucket b = parentIdToBuckets.computeIfAbsent(parentId, id -> new Bucket());
            if (elementIdToBucket.containsKey(parentId)) {
                Bucket parentBucket = (Bucket)elementIdToBucket.get(parentId);
                parentBucket.dependencies.add(b);
                b.dependentOn = parentBucket;
            }
            b.wrapper.add(fragmentWrapper);
            for (MApplicationElement e : fragment.getElements()) {
                if (parentId == e.getElementId()) continue;
                elementIdToBucket.put(e.getElementId(), b);
                b.containedElementIds.add(e.getElementId());
                if (!parentIdToBuckets.containsKey(e.getElementId())) continue;
                Bucket childBucket = (Bucket)parentIdToBuckets.get(e.getElementId());
                b.dependencies.add(childBucket);
                childBucket.dependentOn = b;
            }
        }
        this.processFragments(this.createUnifiedFragmentList(elementIdToBucket));
    }

    private List<ModelFragmentWrapper> createUnifiedFragmentList(Map<String, Bucket> elementIdToBucket) {
        ArrayList<ModelFragmentWrapper> fragmentList = new ArrayList<ModelFragmentWrapper>();
        LinkedHashSet checkedElementIds = new LinkedHashSet();
        elementIdToBucket.forEach((arg_0, arg_1) -> this.lambda$6(checkedElementIds, fragmentList, arg_0, arg_1));
        return fragmentList;
    }

    private void addAllBucketFragmentWrapper(Bucket bucket, List<ModelFragmentWrapper> fragmentList, Set<String> checkedElementIds) {
        fragmentList.addAll(bucket.wrapper);
        checkedElementIds.addAll(bucket.containedElementIds);
        for (Bucket child : bucket.dependencies) {
            this.addAllBucketFragmentWrapper(child, fragmentList, checkedElementIds);
        }
    }

    public void processFragments(Collection<ModelFragmentWrapper> fragmentList) {
        for (ModelFragmentWrapper fragmentWrapper : fragmentList) {
            this.processFragment(fragmentWrapper.getFragmentContainer(), fragmentWrapper.getModelFragment(), fragmentWrapper.getContributorName(), fragmentWrapper.getContributorURI(), fragmentWrapper.isCheckExists());
        }
    }

    public void processFragment(MModelFragments fragmentsContainer, MModelFragment fragment, String contributorName, String contributorURI, boolean checkExist) {
        List<MApplicationElement> merged;
        ArrayList<MApplicationElement> addedElements = new ArrayList<MApplicationElement>();
        if (fragmentsContainer == null) {
            return;
        }
        boolean evalImports = false;
        Diagnostic validationResult = Diagnostician.INSTANCE.validate((EObject)fragment);
        int severity = validationResult.getSeverity();
        if (severity == 4) {
            this.error("Fragment from {} of {} could not be validated and was not merged:  -> Validation result: {}" + String.valueOf(fragment), contributorURI, contributorName, validationResult);
        }
        if (!(merged = this.processModelFragment(fragment, contributorURI, checkExist)).isEmpty()) {
            evalImports = true;
            addedElements.addAll(merged);
        } else {
            this.debug("Nothing to merge for fragment {} of {}", contributorURI, contributorName);
        }
        if (evalImports && !fragmentsContainer.getImports().isEmpty()) {
            this.resolveImports(fragmentsContainer.getImports(), addedElements);
        }
    }

    /*
     * WARNING - void declaration
     */
    private MModelFragments getFragmentsContainer(String attrURI, String bundleName) {
        void modelFragments;
        Resource resource;
        URI uri;
        E4XMIResource applicationResource = (E4XMIResource)((EObject)this.application).eResource();
        ResourceSet resourceSet = applicationResource.getResourceSet();
        if (attrURI == null) {
            this.warn("Unable to find location for the model extension {}", bundleName);
            return null;
        }
        try {
            if (URIHelper.isPlatformURI(attrURI)) {
                uri = URI.createURI((String)attrURI);
            } else {
                String path = bundleName + "/" + attrURI;
                uri = URI.createPlatformPluginURI((String)path, (boolean)false);
            }
        }
        catch (RuntimeException e) {
            this.warn("Invalid location {} of model extension {}", attrURI, bundleName, e);
            return null;
        }
        try {
            resource = resourceSet.getResource(uri, true);
        }
        catch (RuntimeException e) {
            this.warn("Unable to read model extension from {} of {}", uri, bundleName);
            return null;
        }
        EList contents = resource.getContents();
        if (contents.isEmpty()) {
            return null;
        }
        Object extensionRoot = contents.get(0);
        if (!(extensionRoot instanceof MModelFragments)) {
            this.warn("Unable to create model extension {}", bundleName);
            return null;
        }
        MModelFragments mModelFragments = (MModelFragments)extensionRoot;
        return modelFragments;
    }

    public List<MApplicationElement> processModelFragment(MModelFragment fragment, String contributorURI, boolean checkExist) {
        E4XMIResource applicationResource = (E4XMIResource)((EObject)this.application).eResource();
        List elements = fragment.getElements();
        if (elements.isEmpty()) {
            return new ArrayList<MApplicationElement>();
        }
        for (MApplicationElement el : elements) {
            EObject o = (EObject)el;
            E4XMIResource r = (E4XMIResource)o.eResource();
            if (checkExist && applicationResource.getIDToEObjectMap().containsKey(r.getID(o))) continue;
            applicationResource.setID(o, r.getID(o));
            if (contributorURI != null) {
                el.setContributorURI(contributorURI);
            }
            Iterable contents = () -> EcoreUtil.getAllContents((EObject)o, (boolean)true);
            for (EObject eObj : contents) {
                r = (E4XMIResource)eObj.eResource();
                if (contributorURI != null && eObj instanceof MApplicationElement) {
                    MApplicationElement application = (MApplicationElement)eObj;
                    application.setContributorURI(contributorURI);
                }
                applicationResource.setID(eObj, r.getInternalId(eObj));
            }
        }
        return fragment.merge(this.application);
    }

    public void runProcessors(IExtension[] extensions, boolean initial, boolean afterFragments) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] ces;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ces = extension.getConfigurationElements();
            int n3 = ces.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                boolean parseBoolean = Boolean.parseBoolean(ce.getAttribute("beforefragment"));
                if ("processor".equals(ce.getName()) && afterFragments != parseBoolean && (initial || !INITIAL.equals(ce.getAttribute("apply")))) {
                    this.runProcessor(ce);
                }
                ++n4;
            }
            ++n2;
        }
        this.processorContributions.stream().filter(sr -> {
            String applyValue;
            String apply;
            Object before = sr.getProperty("beforefragment");
            boolean beforeFragments = true;
            if (before instanceof Boolean) {
                Boolean beforeValue = (Boolean)before;
                beforeFragments = beforeValue;
            } else if (before instanceof String) {
                String beforeValue = (String)before;
                beforeFragments = Boolean.parseBoolean(beforeValue);
            }
            Object object = sr.getProperty("apply");
            String string = apply = object instanceof String ? (applyValue = (String)object) : ALWAYS;
            if (!ALWAYS.equals(apply) && !INITIAL.equals(apply)) {
                this.warn("IModelProcessorContribution apply property value {} is invalid, falling back to always", apply);
                apply = ALWAYS;
            }
            return afterFragments != beforeFragments && (initial || ALWAYS.equals(apply));
        }).map(arg_0 -> ((BundleContext)this.bundleContext).getService(arg_0)).forEach(this::runProcessor);
    }

    private void runProcessor(IConfigurationElement ce) {
        IEclipseContext localContext = EclipseContextFactory.create();
        IContributionFactory factory = (IContributionFactory)this.context.get(IContributionFactory.class);
        IConfigurationElement[] iConfigurationElementArray = ce.getChildren("element");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ceEl = iConfigurationElementArray[n2];
            String id = ceEl.getAttribute("id");
            if (id == null) {
                this.warn("No element id given", new Object[0]);
            } else {
                MApplicationElement el;
                String key = ceEl.getAttribute("contextKey");
                if (key == null) {
                    key = id;
                }
                if ((el = ModelUtils.findElementById((MApplicationElement)this.application, (String)id)) == null) {
                    this.warn("Could not find element with id {}", id);
                }
                localContext.set(key, (Object)el);
            }
            ++n2;
        }
        try {
            Object o = factory.create("bundleclass://" + ce.getContributor().getName() + "/" + ce.getAttribute("class"), this.context, localContext);
            if (o == null) {
                this.warn("Unable to create processor {} from {}", ce.getAttribute("class"), ce.getContributor().getName());
            } else {
                ContextInjectionFactory.invoke((Object)o, Execute.class, (IEclipseContext)this.context, (IEclipseContext)localContext, null);
            }
        }
        catch (Exception e) {
            this.warn("Could not run processor: {}", e);
        }
    }

    private void runProcessor(IModelProcessorContribution processor) {
        IEclipseContext localContext = EclipseContextFactory.create();
        for (IModelProcessorContribution.ModelElement element : processor.getModelElements()) {
            MApplicationElement el;
            String id = element.getId();
            if (id == null) {
                this.warn("No element id given", new Object[0]);
                continue;
            }
            String key = element.getContextKey();
            if (key == null) {
                key = id;
            }
            if ((el = ModelUtils.findElementById((MApplicationElement)this.application, (String)id)) == null) {
                this.warn("Could not find element with id {}", id);
            }
            localContext.set(key, (Object)el);
        }
        try {
            Object o = null;
            o = processor.getProcessorClass() != null ? ContextInjectionFactory.make(processor.getProcessorClass(), (IEclipseContext)localContext) : processor;
            if (o == null) {
                this.warn("Unable to create processor {} from {}", processor.getProcessorClass().getName(), FrameworkUtil.getBundle(processor.getProcessorClass()).getSymbolicName());
            } else {
                ContextInjectionFactory.invoke((Object)o, Execute.class, (IEclipseContext)this.context, (IEclipseContext)localContext, null);
            }
        }
        catch (Exception e) {
            this.warn("Could not run processor: {}", e);
        }
    }

    public void resolveImports(List<MApplicationElement> imports, List<MApplicationElement> addedElements) {
        if (imports.isEmpty()) {
            return;
        }
        HashMap<MApplicationElement, MApplicationElement> importMaps = new HashMap<MApplicationElement, MApplicationElement>();
        for (MApplicationElement importedElement : imports) {
            MApplicationElement realElement = ModelUtils.findElementById((MApplicationElement)this.application, (String)importedElement.getElementId());
            importMaps.put(importedElement, realElement);
        }
        Iterable contents = () -> EcoreUtil.getAllContents((Collection)addedElements);
        ArrayList<Runnable> commands = new ArrayList<Runnable>();
        for (EObject target : contents) {
            EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)target.eCrossReferences().iterator();
            while (featureIterator.hasNext()) {
                MApplicationElement element;
                EObject importObject = (EObject)featureIterator.next();
                if (importObject.eContainmentFeature() != FragmentPackageImpl.Literals.MODEL_FRAGMENTS__IMPORTS) continue;
                EStructuralFeature feature = featureIterator.feature();
                if (importObject instanceof MApplicationElement) {
                    MApplicationElement applicationElement = (MApplicationElement)importObject;
                    element = (MApplicationElement)importMaps.get(applicationElement);
                    if (element == null) {
                        this.warn("Could not resolve import for {}", applicationElement.getElementId());
                    }
                } else {
                    element = null;
                }
                commands.add(() -> {
                    if (feature.isMany()) {
                        this.error("Replacing in {}.\nFeature={}.\nInternalElement={} contributed by {}.\nImportObject={}\n", target, feature.getName(), element.getElementId(), element.getContributorURI(), importObject);
                        List l = (List)target.eGet(feature);
                        int index = l.indexOf(importObject);
                        if (index >= 0) {
                            l.set(index, element);
                        }
                    } else {
                        target.eSet(feature, (Object)element);
                    }
                });
            }
        }
        for (Runnable cmd : commands) {
            cmd.run();
        }
    }

    private void debug(String message, Object ... args) {
        this.log((logger, string, objectArray) -> logger.debug(string, objectArray), System.out, message, args);
    }

    private void warn(String message, Object ... args) {
        this.log((logger, string, objectArray) -> logger.warn(string, objectArray), System.out, message, args);
    }

    private void error(String message, Object ... args) {
        this.log((logger, string, objectArray) -> logger.error(string, objectArray), System.err, message, args);
    }

    private void log(LogMethod logMethod, PrintStream stream, String message, Object ... args) {
        Logger log = this.logger;
        if (log != null) {
            logMethod.invoke(log, message, args);
        } else {
            stream.println(MessageFormat.format(message, args));
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    public void setLogger(LoggerFactory factory) {
        this.factory = factory;
        this.logger = factory.getLogger(this.getClass());
    }

    public void unsetLogger(LoggerFactory loggerFactory) {
        if (this.factory == loggerFactory) {
            this.factory = null;
            this.logger = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$6(Set var1_1, List var2_2, String key, Bucket bucket) {
        if (!var1_1.contains(key)) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            bucket = bucket.dependentOn;
lbl4:
            // 2 sources

            ** while (bucket.dependentOn != null)
        }
lbl5:
        // 1 sources

        this.addAllBucketFragmentWrapper(bucket, var2_2, var1_1);
    }

    private class Bucket {
        SortedSet<ModelFragmentWrapper> wrapper;
        Bucket dependentOn;
        Set<Bucket> dependencies;
        Set<String> containedElementIds;

        private Bucket() {
            this.wrapper = new TreeSet<ModelFragmentWrapper>(new ModelFragmentComparator(ModelAssembler.this.application));
            this.dependencies = new LinkedHashSet<Bucket>();
            this.containedElementIds = new LinkedHashSet<String>();
        }
    }

    private record FragmentWrapperElementMapping(ModelFragmentWrapper wrapper, List<MApplicationElement> elements) {
        static /* synthetic */ List access$7(FragmentWrapperElementMapping fragmentWrapperElementMapping) {
            return fragmentWrapperElementMapping.elements;
        }
    }

    private static interface LogMethod {
        public void invoke(Logger var1, String var2, Object ... var3);
    }

    private class ModelFragmentBundleTracker
    implements BundleTrackerCustomizer<List<FragmentWrapperElementMapping>> {
        private ModelFragmentBundleTracker() {
        }

        public List<FragmentWrapperElementMapping> addingBundle(Bundle bundle, BundleEvent event) {
            if (bundle.getHeaders("").get(ModelAssembler.MODEL_FRAGMENT_HEADER) != null) {
                List<ModelFragmentWrapper> wrappers = ModelAssembler.this.getModelFragmentWrapperFromBundle(bundle, ModelAssembler.this.initial);
                List<FragmentWrapperElementMapping> mappings = wrappers.stream().map(w -> new FragmentWrapperElementMapping((ModelFragmentWrapper)w, List.copyOf(w.getModelFragment().getElements()))).toList();
                if (ModelAssembler.this.processModelExecuted) {
                    ModelAssembler.this.uiSync.asyncExec(() -> ModelAssembler.this.processFragmentWrappers(wrappers));
                }
                return mappings;
            }
            return null;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, List<FragmentWrapperElementMapping> mapping) {
        }

        public void removedBundle(Bundle bundle, BundleEvent event, List<FragmentWrapperElementMapping> mappings) {
            ModelAssembler.this.uiSync.asyncExec(() -> {
                if (mappings != null) {
                    mappings.stream().flatMap(m -> m.elements.stream()).forEach(appElement -> {
                        if (appElement instanceof MUIElement) {
                            MUIElement element = (MUIElement)appElement;
                            element.setToBeRendered(false);
                            if (element.getParent() != null) {
                                element.getParent().getChildren().remove(element);
                            }
                        }
                    });
                    String bundleName = bundle.getSymbolicName();
                    String fragmentHeader = (String)bundle.getHeaders("").get(ModelAssembler.MODEL_FRAGMENT_HEADER);
                    String[] fr = fragmentHeader.split(";");
                    if (fr.length > 0) {
                        URI uri;
                        String attrURI = fr[0];
                        E4XMIResource applicationResource = (E4XMIResource)((EObject)ModelAssembler.this.application).eResource();
                        ResourceSet resourceSet = applicationResource.getResourceSet();
                        if (attrURI == null) {
                            ModelAssembler.this.warn("Unable to find location for the model extension {}", bundleName);
                            return;
                        }
                        try {
                            if (URIHelper.isPlatformURI(attrURI)) {
                                uri = URI.createURI((String)attrURI);
                            } else {
                                String path = bundleName + "/" + attrURI;
                                uri = URI.createPlatformPluginURI((String)path, (boolean)false);
                            }
                        }
                        catch (RuntimeException e) {
                            ModelAssembler.this.warn("Invalid location {} of model extension {}", attrURI, bundleName, e);
                            return;
                        }
                        try {
                            Resource resource = resourceSet.getResource(uri, true);
                            resource.unload();
                        }
                        catch (RuntimeException e) {
                            ModelAssembler.this.warn("Unable to read model extension from {} of {}", uri, bundleName);
                        }
                    }
                }
            });
        }
    }
}

