/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.internal.navigator.wizards.CommonWizardDescriptor;
import org.eclipse.ui.internal.navigator.wizards.CommonWizardDescriptorManager;
import org.eclipse.ui.internal.navigator.wizards.WizardShortcutAction;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;

public final class WizardActionGroup
extends ActionGroup {
    public static final String TYPE_NEW = "new";
    public static final String TYPE_IMPORT = "import";
    public static final String TYPE_EXPORT = "export";
    private static final CommonWizardDescriptor[] NO_DESCRIPTORS = new CommonWizardDescriptor[0];
    private static final String[] NO_IDS = new String[0];
    private CommonWizardDescriptor[] descriptors;
    private Map<String, IAction> actions;
    private final IWorkbenchWindow window;
    private final IWizardRegistry wizardRegistry;
    private boolean disposed = false;
    private final String type;
    private final INavigatorContentService contentService;
    private final Predicate<IWizardDescriptor> descriptorFilter;
    private final boolean useSeparators;

    public WizardActionGroup(IWorkbenchWindow aWindow, IWizardRegistry aWizardRegistry, String aType) {
        this(aWindow, aWizardRegistry, aType, null);
    }

    public WizardActionGroup(IWorkbenchWindow aWindow, IWizardRegistry aWizardRegistry, String aType, INavigatorContentService aContentService) {
        this(aWindow, aWizardRegistry, aType, aContentService, null, true);
    }

    public WizardActionGroup(IWorkbenchWindow aWindow, IWizardRegistry aWizardRegistry, String aType, INavigatorContentService aContentService, Predicate<IWizardDescriptor> descriptorFilter, boolean useSeparators) {
        Assert.isNotNull((Object)aWindow);
        Assert.isNotNull((Object)aWizardRegistry);
        Assert.isNotNull((Object)aType);
        Assert.isTrue((TYPE_NEW.equals(aType) || TYPE_IMPORT.equals(aType) || TYPE_EXPORT.equals(aType) ? 1 : 0) != 0);
        this.window = aWindow;
        this.wizardRegistry = aWizardRegistry;
        this.type = aType;
        this.contentService = aContentService;
        this.descriptorFilter = descriptorFilter;
        this.useSeparators = useSeparators;
    }

    public void setContext(ActionContext aContext) {
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        super.setContext(aContext);
        if (aContext != null) {
            ISelection selection = aContext.getSelection();
            Object element = null;
            if (selection instanceof IStructuredSelection) {
                element = ((IStructuredSelection)selection).getFirstElement();
            }
            if (element == null) {
                element = Collections.EMPTY_LIST;
            }
            this.setWizardActionDescriptors(CommonWizardDescriptorManager.getInstance().getEnabledCommonWizardDescriptors(element, this.type, this.contentService));
        } else {
            this.setWizardActionDescriptors(NO_DESCRIPTORS);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        if (this.descriptors != null) {
            Map<String, SortedSet<IAction>> groups = this.findGroups();
            SortedSet<IAction> sortedWizards = null;
            String menuGroupId = null;
            for (Map.Entry<String, SortedSet<IAction>> entry : groups.entrySet()) {
                menuGroupId = entry.getKey();
                sortedWizards = entry.getValue();
                if (this.useSeparators) {
                    menu.add((IContributionItem)new Separator(menuGroupId));
                }
                Iterator wizardItr = sortedWizards.iterator();
                while (wizardItr.hasNext()) {
                    menu.add((IAction)wizardItr.next());
                }
            }
        }
    }

    private synchronized Map<String, SortedSet<IAction>> findGroups() {
        IAction action = null;
        TreeMap<String, SortedSet<IAction>> groups = new TreeMap<String, SortedSet<IAction>>();
        TreeSet<IAction> sortedWizards = null;
        String menuGroupId = null;
        CommonWizardDescriptor[] commonWizardDescriptorArray = this.descriptors;
        int n = this.descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            CommonWizardDescriptor descriptor = commonWizardDescriptorArray[n2];
            menuGroupId = descriptor.getMenuGroupId() != null ? descriptor.getMenuGroupId() : "all-uncategorized";
            sortedWizards = (TreeSet<IAction>)groups.get(menuGroupId);
            if (sortedWizards == null) {
                sortedWizards = new TreeSet<IAction>(ActionComparator.INSTANCE);
                groups.put(descriptor.getMenuGroupId(), sortedWizards);
            }
            if ((action = this.getAction(descriptor.getWizardId())) != null) {
                sortedWizards.add(action);
            }
            ++n2;
        }
        return groups;
    }

    public void dispose() {
        super.dispose();
        this.actions = null;
        this.descriptors = null;
        this.disposed = true;
    }

    protected IAction getAction(String id) {
        IWizardDescriptor descriptor;
        if (id == null || id.length() == 0) {
            return null;
        }
        Object action = this.getActions().get(id);
        if (action == null && (descriptor = this.getDescriptor(id)) != null) {
            action = new WizardShortcutAction(this.window, descriptor);
            this.getActions().put(id, (IAction)action);
        }
        return action;
    }

    protected IWizardDescriptor getDescriptor(String id) {
        IWizardDescriptor descriptor = this.wizardRegistry.findWizard(id);
        if (descriptor != null && this.descriptorFilter != null && !this.descriptorFilter.test(descriptor)) {
            return null;
        }
        return descriptor;
    }

    protected Map<String, IAction> getActions() {
        if (this.actions == null) {
            this.actions = new HashMap<String, IAction>();
        }
        return this.actions;
    }

    public synchronized String[] getWizardActionIds() {
        if (this.descriptors != null && this.descriptors.length > 0) {
            String[] wizardActionIds = new String[this.descriptors.length];
            int i = 0;
            while (i < this.descriptors.length) {
                wizardActionIds[i] = this.descriptors[i].getWizardId();
                ++i;
            }
            return wizardActionIds;
        }
        return NO_IDS;
    }

    private synchronized void setWizardActionDescriptors(CommonWizardDescriptor[] theWizardDescriptors) {
        this.descriptors = theWizardDescriptors;
    }

    private static class ActionComparator
    implements Comparator<IAction> {
        private static final ActionComparator INSTANCE = new ActionComparator();

        private ActionComparator() {
        }

        @Override
        public int compare(IAction arg0, IAction arg1) {
            return arg0.getText().compareToIgnoreCase(arg1.getText());
        }
    }
}

