/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.util.Iterator;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.tools.DependencyHelper;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public class ImplicationAnd<T, C> {
    private final DependencyHelper<T, C> helper;
    private final IVecInt clause;
    private final IVec<IConstr> toName = new Vec();

    public ImplicationAnd(DependencyHelper<T, C> helper, IVecInt clause) {
        this.clause = clause;
        this.helper = helper;
    }

    public ImplicationAnd<T, C> and(T thing) throws ContradictionException {
        VecInt tmpClause = new VecInt();
        this.clause.copyTo((IVecInt)tmpClause);
        tmpClause.push(this.helper.getIntValue(thing));
        IConstr constr = this.helper.solver.addClause((IVecInt)tmpClause);
        if (constr != null) {
            this.toName.push((Object)constr);
        }
        return this;
    }

    public ImplicationAnd<T, C> andNot(T thing) throws ContradictionException {
        VecInt tmpClause = new VecInt();
        this.clause.copyTo((IVecInt)tmpClause);
        tmpClause.push(-this.helper.getIntValue(thing));
        IConstr constr = this.helper.solver.addClause((IVecInt)tmpClause);
        if (constr != null) {
            this.toName.push((Object)constr);
        }
        return this;
    }

    public void named(C name) {
        Iterator it = this.toName.iterator();
        while (it.hasNext()) {
            this.helper.descs.put((IConstr)it.next(), name);
        }
    }
}

