/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.userstorage.internal.util.IOUtil;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.spi.StorageCache;

public class FileStorageCache
extends StorageCache {
    protected static final String PROPERTIES = ".properties";
    private final File folder;

    public FileStorageCache() {
        this(FileStorageCache.createTempFolder());
    }

    public FileStorageCache(File folder) {
        if (folder == null) {
            throw new IllegalArgumentException("Folder is null");
        }
        this.folder = folder;
    }

    public final File getFolder() {
        return this.folder;
    }

    @Override
    public Iterator<String> getKeys(String applicationToken) throws IOException {
        HashSet<String> keys = new HashSet<String>();
        File applicationFolder = this.getApplicationFolder(applicationToken);
        File[] files = applicationFolder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String name = file.getName();
                String key = this.getKeyFromFileName(name);
                if (key != null) {
                    keys.add(name);
                }
                ++n2;
            }
        }
        return keys.iterator();
    }

    @Override
    protected void loadProperties(String applicationToken, String key, Map<String, String> properties) throws IOException {
        File file = this.getFile(applicationToken, key, PROPERTIES);
        if (file.isFile()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                Properties buffer = new Properties();
                buffer.load(in);
                for (Map.Entry<Object, Object> entry : buffer.entrySet()) {
                    properties.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
            IOUtil.close(in);
        }
    }

    @Override
    protected void saveProperties(String applicationToken, String key, Map<String, String> properties) throws IOException {
        File file = this.getFile(applicationToken, key, PROPERTIES);
        Properties buffer = new Properties();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            buffer.put(entry.getKey(), entry.getValue());
        }
        FileOutputStream out = null;
        try {
            IOUtil.mkdirs(file.getParentFile());
            out = new FileOutputStream(file);
            buffer.store(out, "Blob " + applicationToken + "/" + key);
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close(out);
    }

    @Override
    protected InputStream getInputStream(String applicationToken, String key) throws IOException {
        File file = this.getFile(applicationToken, key, null);
        if (file.isFile()) {
            return new FileInputStream(file);
        }
        return null;
    }

    @Override
    protected OutputStream getOutputStream(String applicationToken, String key) throws IOException {
        File file = this.getFile(applicationToken, key, null);
        IOUtil.mkdirs(file.getParentFile());
        return new FileOutputStream(file);
    }

    @Override
    protected void delete(String applicationToken, String key) throws IOException {
        this.getFile(applicationToken, key, PROPERTIES).delete();
        this.getFile(applicationToken, key, null).delete();
    }

    protected File getFile(String applicationToken, String key, String extension) {
        File applicationFolder = this.getApplicationFolder(applicationToken);
        String keyFileName = this.getFileNameFromKey(key, extension);
        return new File(applicationFolder, keyFileName);
    }

    protected File getApplicationFolder(String applicationFolderName) {
        return new File(this.folder, applicationFolderName);
    }

    protected String getFileNameFromKey(String key, String extension) {
        return String.valueOf(key) + StringUtil.safe(extension);
    }

    protected String getKeyFromFileName(String name) {
        if (name.endsWith(PROPERTIES)) {
            return name.substring(0, name.length() - PROPERTIES.length());
        }
        return null;
    }

    private static File createTempFolder() {
        int i = 0;
        while (i < 100) {
            try {
                File folder = File.createTempFile("userstorage-", "");
                if (folder.delete()) {
                    IOUtil.mkdirs(folder);
                    return folder;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        throw new RuntimeException("Temporary folder could not be created");
    }

    public static class SingleApplication
    extends FileStorageCache {
        private final String applicationToken;

        public SingleApplication(String applicationToken) {
            this.applicationToken = applicationToken;
        }

        public SingleApplication(File folder, String applicationToken) {
            super(folder);
            this.applicationToken = applicationToken;
        }

        public final String getApplicationToken() {
            return this.applicationToken;
        }

        @Override
        public Iterator<String> getKeys(String applicationToken) throws IOException {
            this.checkApplication(applicationToken);
            return super.getKeys(applicationToken);
        }

        @Override
        protected void loadProperties(String applicationToken, String key, Map<String, String> properties) throws IOException {
            this.checkApplication(applicationToken);
            super.loadProperties(applicationToken, key, properties);
        }

        @Override
        protected void saveProperties(String applicationToken, String key, Map<String, String> properties) throws IOException {
            this.checkApplication(applicationToken);
            super.saveProperties(applicationToken, key, properties);
        }

        @Override
        protected InputStream getInputStream(String applicationToken, String key) throws IOException {
            this.checkApplication(applicationToken);
            return super.getInputStream(applicationToken, key);
        }

        @Override
        protected OutputStream getOutputStream(String applicationToken, String key) throws IOException {
            this.checkApplication(applicationToken);
            return super.getOutputStream(applicationToken, key);
        }

        @Override
        protected void delete(String applicationToken, String key) throws IOException {
            this.checkApplication(applicationToken);
            super.delete(applicationToken, key);
        }

        @Override
        protected File getFile(String applicationToken, String key, String extension) {
            this.checkApplication(applicationToken);
            return super.getFile(applicationToken, key, extension);
        }

        @Override
        protected File getApplicationFolder(String applicationFolderName) {
            this.checkApplication(this.applicationToken);
            return this.getFolder();
        }

        protected final void checkApplication(String applicationToken) throws IllegalArgumentException {
            if (!this.applicationToken.equals(applicationToken)) {
                throw new IllegalArgumentException("Invalid application token: " + applicationToken);
            }
        }

        public static class SingleKey
        extends SingleApplication {
            private static final Set<String> NO_KEYS = Collections.emptySet();
            private final String key;
            private String fileNamePrefix;

            public SingleKey(String applicationToken, String key) {
                super(applicationToken);
                this.key = key;
                this.fileNamePrefix = key;
            }

            public SingleKey(File folder, String applicationToken, String key) {
                super(folder, applicationToken);
                this.key = key;
                this.fileNamePrefix = key;
            }

            public final String getKey() {
                return this.key;
            }

            public final String getFileNamePrefix() {
                return this.fileNamePrefix;
            }

            public final void setFileNamePrefix(String fileNamePrefix) {
                this.fileNamePrefix = fileNamePrefix;
            }

            @Override
            public Iterator<String> getKeys(String applicationToken) throws IOException {
                Iterator<String> it = super.getKeys(applicationToken);
                while (it.hasNext()) {
                    String key = it.next();
                    if (!this.key.equals(key)) continue;
                    return Collections.singleton(key).iterator();
                }
                return NO_KEYS.iterator();
            }

            @Override
            protected void loadProperties(String applicationToken, String key, Map<String, String> properties) throws IOException {
                this.checkKey(key);
                super.loadProperties(applicationToken, key, properties);
            }

            @Override
            protected void saveProperties(String applicationToken, String key, Map<String, String> properties) throws IOException {
                this.checkKey(key);
                super.saveProperties(applicationToken, key, properties);
            }

            @Override
            protected InputStream getInputStream(String applicationToken, String key) throws IOException {
                this.checkKey(key);
                return super.getInputStream(applicationToken, key);
            }

            @Override
            protected OutputStream getOutputStream(String applicationToken, String key) throws IOException {
                this.checkKey(key);
                return super.getOutputStream(applicationToken, key);
            }

            @Override
            protected void delete(String applicationToken, String key) throws IOException {
                this.checkKey(key);
                super.delete(applicationToken, key);
            }

            @Override
            protected File getFile(String applicationToken, String key, String extension) {
                this.checkKey(key);
                return super.getFile(applicationToken, key, extension);
            }

            @Override
            protected String getFileNameFromKey(String key, String extension) {
                this.checkKey(key);
                return super.getFileNameFromKey(this.fileNamePrefix, extension);
            }

            @Override
            protected String getKeyFromFileName(String name) {
                String fileNamePrefix = super.getKeyFromFileName(name);
                if (this.fileNamePrefix.equals(fileNamePrefix)) {
                    return this.key;
                }
                return null;
            }

            protected final void checkKey(String key) throws IllegalArgumentException {
                if (!this.key.equals(key)) {
                    throw new IllegalArgumentException("Invalid key: " + key);
                }
            }
        }
    }
}

