/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.edit.event.DataUpdateEvent;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.event.FilterAppliedEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.util.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlazedListsFilterRowComboBoxDataProvider<T>
extends FilterRowComboBoxDataProvider<T>
implements ListEventListener<T> {
    private static final Logger LOG = LoggerFactory.getLogger(GlazedListsFilterRowComboBoxDataProvider.class);
    private static final Scheduler SCHEDULER = new Scheduler("GlazedListsFilterRowComboBoxDataProvider");
    private final ScheduledFuture<?> future;
    private AtomicBoolean eventsToProcess = new AtomicBoolean(false);
    private EventList<T> baseEventList;
    private final java.util.concurrent.locks.ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private AtomicBoolean terminated = new AtomicBoolean(false);
    private boolean active = true;

    public GlazedListsFilterRowComboBoxDataProvider(ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> columnAccessor) {
        this(bodyLayer, baseCollection, columnAccessor, true);
    }

    public GlazedListsFilterRowComboBoxDataProvider(ILayer bodyLayer, Collection<T> baseCollection, IColumnAccessor<T> columnAccessor, boolean lazy) {
        super(bodyLayer, baseCollection, columnAccessor, lazy);
        if (baseCollection instanceof EventList) {
            this.baseEventList = (EventList)baseCollection;
            this.baseEventList.addListEventListener((ListEventListener)this);
        } else {
            LOG.error("baseCollection is not of type EventList. List changes can not be tracked.");
        }
        this.future = SCHEDULER.scheduleWithFixedDelay(() -> {
            if (this.cachingEnabled && this.active && this.eventsToProcess.compareAndSet(true, false)) {
                this.clearCache(true);
            }
        }, 0L, 100L);
    }

    public void listChanged(ListEvent<T> listChanges) {
        this.cacheLock.readLock().lock();
        try {
            if (this.cachingEnabled && this.baseEventList.size() == 0) {
                this.setLastFilter(-1, null);
            }
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        this.eventsToProcess.set(true);
    }

    public void handleLayerEvent(ILayerEvent event) {
        if (this.cachingEnabled && this.isEventFromBodyLayer(event) && event instanceof DataUpdateEvent) {
            SCHEDULER.schedule(() -> this.updateCache(((DataUpdateEvent)event).getColumnPosition()), 0L);
        }
        if (event instanceof FilterAppliedEvent) {
            super.handleLayerEvent(event);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.terminated.compareAndSet(false, true)) {
            SCHEDULER.unschedule(this.future);
        }
    }

    public boolean isDisposed() {
        return this.terminated.get();
    }

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void discardEventsToProcess() {
        this.eventsToProcess.set(false);
    }

    protected List<?> collectValues(Collection<T> collection, int columnIndex) {
        if (collection instanceof EventList) {
            ReadWriteLock collectionLock = ((EventList)collection).getReadWriteLock();
            collectionLock.readLock().lock();
            try {
                List list = super.collectValues(collection, columnIndex);
                return list;
            }
            finally {
                collectionLock.readLock().unlock();
            }
        }
        return super.collectValues(collection, columnIndex);
    }
}

