/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.util.stream.DoubleStream;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.factory.list.primitive.ImmutableDoubleListFactory;
import org.eclipse.collections.api.list.primitive.ImmutableDoubleList;
import org.eclipse.collections.impl.factory.primitive.DoubleLists;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableDoubleArrayList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableDoubleEmptyList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableDoubleSingletonList;

@ServiceProvider(value=ImmutableDoubleListFactory.class)
public class ImmutableDoubleListFactoryImpl
implements ImmutableDoubleListFactory {
    public static final ImmutableDoubleListFactory INSTANCE = new ImmutableDoubleListFactoryImpl();

    public ImmutableDoubleList empty() {
        return ImmutableDoubleEmptyList.INSTANCE;
    }

    public ImmutableDoubleList of() {
        return this.empty();
    }

    public ImmutableDoubleList with() {
        return this.empty();
    }

    public ImmutableDoubleList of(double one) {
        return this.with(one);
    }

    public ImmutableDoubleList with(double one) {
        return new ImmutableDoubleSingletonList(one);
    }

    public ImmutableDoubleList of(double ... items) {
        return this.with(items);
    }

    public ImmutableDoubleList with(double ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableDoubleArrayList.newListWith(items);
    }

    public ImmutableDoubleList ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    public ImmutableDoubleList withAll(DoubleIterable items) {
        if (items instanceof ImmutableDoubleList) {
            return (ImmutableDoubleList)items;
        }
        if (items == null || items.size() == 0) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray()[0]);
        }
        return ImmutableDoubleArrayList.newList(items);
    }

    public ImmutableDoubleList ofAll(Iterable<Double> iterable) {
        return this.withAll(iterable);
    }

    public ImmutableDoubleList withAll(Iterable<Double> iterable) {
        return DoubleLists.mutable.withAll(iterable).toImmutable();
    }

    public ImmutableDoubleList ofAll(DoubleStream items) {
        return this.withAll(items);
    }

    public ImmutableDoubleList withAll(DoubleStream items) {
        return this.with(items.toArray());
    }
}

