/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.LeafIterator;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.generator.trace.TraceRegion;
import org.eclipse.xtext.generator.trace.TraceRegionMerger;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.TextRegionWithLineInformation;
import org.eclipse.xtext.util.Tuples;

public abstract class AbstractTraceRegion {
    private AbstractTraceRegion parent;
    private List<AbstractTraceRegion> nestedRegions;

    protected AbstractTraceRegion(AbstractTraceRegion parent) {
        this.setParent(parent);
    }

    protected boolean isConsistentWithParent() {
        AbstractTraceRegion prev;
        AbstractTraceRegion parent = this.getParent();
        if (parent == null) {
            return true;
        }
        if (parent.getMyOffset() > this.getMyOffset()) {
            return false;
        }
        if (parent.getMyOffset() + parent.getMyLength() < this.getMyOffset() + this.getMyLength()) {
            return false;
        }
        if (parent.getMyLineNumber() > this.getMyLineNumber()) {
            return false;
        }
        if (parent.getMyEndLineNumber() < this.getMyEndLineNumber()) {
            return false;
        }
        List<AbstractTraceRegion> siblings = parent.getNestedRegions();
        return siblings.size() < 2 || siblings.get(siblings.size() - 1) != this || (prev = siblings.get(siblings.size() - 2)).getMyEndLineNumber() <= this.getMyLineNumber();
    }

    public void setParent(AbstractTraceRegion parent) {
        this.parent = parent;
        if (parent != null) {
            this.setAsChildIn(parent);
        }
    }

    protected void setAsChildIn(AbstractTraceRegion parent) {
        parent.getWritableNestedRegions().add(this);
    }

    public final List<AbstractTraceRegion> getNestedRegions() {
        if (this.nestedRegions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.nestedRegions);
    }

    protected final List<AbstractTraceRegion> getWritableNestedRegions() {
        if (this.nestedRegions == null) {
            this.nestedRegions = Lists.newArrayListWithCapacity((int)4);
        }
        return this.nestedRegions;
    }

    public List<AbstractTraceRegion> invertFor(SourceRelativeURI expectedAssociatedPath, SourceRelativeURI myPath) {
        Map<SourceRelativeURI, List<Pair<ILocationData, AbstractTraceRegion>>> matchingLocations = this.collectMatchingLocations(expectedAssociatedPath);
        List<Pair<ILocationData, AbstractTraceRegion>> expectedMatchingLocations = matchingLocations.get(expectedAssociatedPath);
        if (expectedMatchingLocations == null) {
            return Collections.emptyList();
        }
        this.inplaceSortByOffset(expectedMatchingLocations);
        List<AbstractTraceRegion> result = this.toInvertedTraceRegions(expectedMatchingLocations, myPath);
        return result;
    }

    public Map<SourceRelativeURI, List<AbstractTraceRegion>> invertAll(SourceRelativeURI myPath) {
        Map<SourceRelativeURI, List<Pair<ILocationData, AbstractTraceRegion>>> matchingLocations = this.collectMatchingLocations(null);
        HashMap result = Maps.newHashMapWithExpectedSize((int)matchingLocations.size());
        for (SourceRelativeURI uri : matchingLocations.keySet()) {
            List<Pair<ILocationData, AbstractTraceRegion>> expectedMatchingLocations = matchingLocations.get(uri);
            if (expectedMatchingLocations == null) continue;
            this.inplaceSortByOffset(expectedMatchingLocations);
            List<AbstractTraceRegion> resultPerURI = this.toInvertedTraceRegions(expectedMatchingLocations, myPath);
            result.put(uri, resultPerURI);
        }
        return result;
    }

    protected Map<SourceRelativeURI, List<Pair<ILocationData, AbstractTraceRegion>>> collectMatchingLocations(SourceRelativeURI expectedAssociatedPath) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        TreeIterator<AbstractTraceRegion> treeIterator = this.treeIterator();
        while (treeIterator.hasNext()) {
            AbstractTraceRegion next = (AbstractTraceRegion)treeIterator.next();
            SourceRelativeURI associatedPath = next.getAssociatedSrcRelativePath();
            List<Pair<ILocationData, AbstractTraceRegion>> matchingLocations = this.getCollectingList(associatedPath, expectedAssociatedPath, result);
            for (ILocationData locationData : next.getAssociatedLocations()) {
                if (associatedPath == null) {
                    matchingLocations = this.getCollectingList(locationData.getSrcRelativePath(), expectedAssociatedPath, result);
                }
                if (matchingLocations == null) continue;
                matchingLocations.add((Pair<ILocationData, AbstractTraceRegion>)Tuples.create((Object)locationData, (Object)next));
            }
        }
        return result;
    }

    protected List<Pair<ILocationData, AbstractTraceRegion>> getCollectingList(SourceRelativeURI associatedPath, SourceRelativeURI expectedAssociatedPath, Map<SourceRelativeURI, List<Pair<ILocationData, AbstractTraceRegion>>> listsPerURI) {
        ArrayList result = null;
        if (associatedPath != null && (expectedAssociatedPath == null || associatedPath.equals(expectedAssociatedPath)) && (result = listsPerURI.get(associatedPath)) == null) {
            result = Lists.newArrayList();
            listsPerURI.put(associatedPath, result);
        }
        return result;
    }

    public TreeIterator<AbstractTraceRegion> treeIterator() {
        AbstractTreeIterator<AbstractTraceRegion> treeIterator = new AbstractTreeIterator<AbstractTraceRegion>(this){
            private static final long serialVersionUID = 1L;

            protected Iterator<? extends AbstractTraceRegion> getChildren(Object object) {
                if (object == null) {
                    return ImmutableSet.of().iterator();
                }
                AbstractTraceRegion casted = (AbstractTraceRegion)object;
                return casted.getNestedRegions().iterator();
            }

            public void remove() {
                throw new UnsupportedOperationException("remove is not supported");
            }
        };
        return treeIterator;
    }

    protected void inplaceSortByOffset(List<Pair<ILocationData, AbstractTraceRegion>> locations) {
        Collections.sort(locations, new Comparator<Pair<ILocationData, AbstractTraceRegion>>(){

            @Override
            public int compare(Pair<ILocationData, AbstractTraceRegion> o1, Pair<ILocationData, AbstractTraceRegion> o2) {
                if (o1 == null || o2 == null) {
                    throw new IllegalArgumentException("o1 == null || o2 == null");
                }
                ILocationData loc1 = (ILocationData)o1.getFirst();
                ILocationData loc2 = (ILocationData)o2.getFirst();
                int result = Ints.compare((int)loc1.getOffset(), (int)loc2.getOffset());
                if (result == 0) {
                    result = Ints.compare((int)loc2.getLength(), (int)loc1.getLength());
                }
                return result;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    protected List<AbstractTraceRegion> toInvertedTraceRegions(List<Pair<ILocationData, AbstractTraceRegion>> locations, SourceRelativeURI myPath) {
        result = Lists.newArrayListWithCapacity((int)2);
        current = null;
        currentEndOffset = 0;
        i = 0;
        while (i < locations.size()) {
            block15: {
                block16: {
                    nextPair = locations.get(i);
                    nextLocation = (ILocationData)nextPair.getFirst();
                    if (nextLocation.getOffset() == nextLocation.getLength() && nextLocation.getOffset() == 0) break block15;
                    nextRegion = (AbstractTraceRegion)nextPair.getSecond();
                    if (current == null) break block16;
                    if (current.getMyOffset() != nextLocation.getOffset() || current.getMyLength() != nextLocation.getLength()) ** GOTO lbl18
                    writableLocations = current.getWritableAssociatedLocations();
                    if (writableLocations.contains(newData = this.createLocationData(nextRegion, myPath))) break block15;
                    writableLocations.add(newData);
                    break block15;
lbl-1000:
                    // 1 sources

                    {
                        currentEndOffset = (current = (TraceRegion)current.getParent()) != null ? current.getMyOffset() + current.getMyLength() : 0;
lbl18:
                        // 2 sources

                        ** while (current != null && currentEndOffset <= nextLocation.getOffset())
                    }
                }
                if (current != null) {
                    nextOffset = nextLocation.getOffset();
                    if (nextOffset + nextLocation.getLength() <= currentEndOffset) {
                        current = new TraceRegion(nextOffset, nextLocation.getLength(), nextLocation.getLineNumber(), nextLocation.getEndLineNumber(), true, this.createLocationData(nextRegion, myPath), (AbstractTraceRegion)current);
                        currentEndOffset = nextLocation.getOffset() + nextLocation.getLength();
                    } else {
                        nextLength = currentEndOffset - nextOffset;
                        nextEndLine = current.getMyEndLineNumber();
                        splittedLength = nextLocation.getLength() - nextLength;
                        splittedBeginLine = nextEndLine;
                        splitted = new LocationData(currentEndOffset, splittedLength, splittedBeginLine, nextLocation.getEndLineNumber(), nextLocation.getSrcRelativePath());
                        j = i + 1;
                        while (j < locations.size() && splitted != null) {
                            shiftMe = (ILocationData)locations.get(j).getFirst();
                            if (splitted.getOffset() == shiftMe.getOffset()) {
                                if (splitted.getLength() > shiftMe.getLength()) {
                                    locations.add(j, (Pair<ILocationData, AbstractTraceRegion>)Tuples.create((Object)splitted, (Object)nextRegion));
                                    splitted = null;
                                }
                            } else if (splitted.getOffset() < shiftMe.getOffset()) {
                                locations.add(j, (Pair<ILocationData, AbstractTraceRegion>)Tuples.create((Object)splitted, (Object)nextRegion));
                                splitted = null;
                            }
                            ++j;
                        }
                        if (splitted != null) {
                            locations.add((Pair<ILocationData, AbstractTraceRegion>)Tuples.create((Object)splitted, (Object)nextRegion));
                        }
                        current = new TraceRegion(nextOffset, nextLength, nextLocation.getLineNumber(), splittedBeginLine, true, this.createLocationData(nextRegion, myPath), (AbstractTraceRegion)current);
                        currentEndOffset = nextOffset + nextLength;
                    }
                } else {
                    current = new TraceRegion(nextLocation.getOffset(), nextLocation.getLength(), nextLocation.getLineNumber(), nextLocation.getEndLineNumber(), true, this.createLocationData(nextRegion, myPath), null);
                    currentEndOffset = nextLocation.getOffset() + nextLocation.getLength();
                    result.add(current);
                }
            }
            ++i;
        }
        return result;
    }

    public static AbstractTraceRegion mergedFrom(List<AbstractTraceRegion> regions) {
        return new TraceRegionMerger().mergeTraceRegions(regions);
    }

    public LocationData createLocationData(AbstractTraceRegion region, SourceRelativeURI myPath) {
        return new LocationData(region.getMyOffset(), region.getMyLength(), region.getMyLineNumber(), region.getMyEndLineNumber(), myPath);
    }

    public final Iterator<AbstractTraceRegion> leafIterator() {
        if (this.nestedRegions == null) {
            return Collections.singleton(this).iterator();
        }
        return new LeafIterator(this);
    }

    public abstract int getMyLength();

    public abstract int getMyOffset();

    public abstract int getMyLineNumber();

    public abstract int getMyEndLineNumber();

    public ITextRegionWithLineInformation getMyRegion() {
        return new TextRegionWithLineInformation(this.getMyOffset(), this.getMyLength(), this.getMyLineNumber(), this.getMyEndLineNumber());
    }

    public abstract List<ILocationData> getAssociatedLocations();

    public ILocationData getMergedAssociatedLocation() {
        List<ILocationData> allData = this.getAssociatedLocations();
        if (allData.isEmpty()) {
            return null;
        }
        if (allData.size() == 1) {
            return allData.get(0);
        }
        boolean allNull = true;
        SourceRelativeURI path = null;
        ITextRegionWithLineInformation region = ITextRegionWithLineInformation.EMPTY_REGION;
        for (ILocationData data : allData) {
            if (path != null) {
                if (!path.equals(data.getSrcRelativePath())) {
                    return null;
                }
            } else if (data.getSrcRelativePath() == null) {
                if (!allNull) {
                    throw new IllegalStateException("Iff multiple associated locations are present, the path has to be set");
                }
            } else {
                allNull = false;
                path = data.getSrcRelativePath();
            }
            region = region.merge((ITextRegionWithLineInformation)new TextRegionWithLineInformation(data.getOffset(), data.getLength(), data.getLineNumber(), data.getEndLineNumber()));
        }
        return new LocationData(region.getOffset(), region.getLength(), region.getLineNumber(), region.getEndLineNumber(), path);
    }

    public SourceRelativeURI getAssociatedSrcRelativePath() {
        SourceRelativeURI result;
        ILocationData data = this.getMergedAssociatedLocation();
        if (data != null && (result = data.getSrcRelativePath()) != null) {
            return result;
        }
        if (this.parent == null) {
            return null;
        }
        boolean uriSeen = false;
        for (ILocationData associated : this.getAssociatedLocations()) {
            if (associated.getSrcRelativePath() == null) continue;
            if (!uriSeen) {
                uriSeen = true;
                continue;
            }
            return null;
        }
        return this.parent.getAssociatedSrcRelativePath();
    }

    public AbstractTraceRegion getParent() {
        return this.parent;
    }

    public AbstractTraceRegion getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    public String getAnnotatedString(String input) {
        StringBuilder result = new StringBuilder(input.length() * 3);
        int nextOffset = this.doAnnotateTrace(input, result, 0);
        if (nextOffset < input.length()) {
            result.append(input.substring(nextOffset));
        }
        return result.toString();
    }

    private int doAnnotateTrace(String input, StringBuilder result, int nextOffset) {
        if (nextOffset < this.getMyOffset()) {
            result.append(input.substring(nextOffset, this.getMyOffset()));
            nextOffset = this.getMyOffset();
        }
        result.append('<');
        List<ILocationData> associatedLocations = this.getAssociatedLocations();
        int i = 0;
        while (i < associatedLocations.size()) {
            if (i != 0) {
                result.append("/");
            }
            ILocationData associatedLocation = associatedLocations.get(i);
            result.append(associatedLocation.getOffset()).append(':').append(associatedLocation.getLength());
            ++i;
        }
        result.append("[");
        for (AbstractTraceRegion nested : this.getNestedRegions()) {
            nextOffset = nested.doAnnotateTrace(input, result, nextOffset);
        }
        if (nextOffset < this.getMyOffset() + this.getMyLength()) {
            result.append(input.substring(nextOffset, this.getMyOffset() + this.getMyLength()));
            nextOffset = this.getMyOffset() + this.getMyLength();
        }
        result.append(']');
        return nextOffset;
    }

    public abstract boolean isUseForDebugging();

    public int hashCode() {
        AbstractTraceRegion parent = this.getParent();
        return this.getMyOffset() ^ this.getMyLength() ^ this.getAssociatedLocations().hashCode() ^ (parent == null ? 0 : parent.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractTraceRegion)) {
            return false;
        }
        AbstractTraceRegion other = (AbstractTraceRegion)obj;
        if (this.getMyLength() != other.getMyLength()) {
            return false;
        }
        if (this.getMyOffset() != other.getMyOffset()) {
            return false;
        }
        if (!this.getAssociatedLocations().equals(other.getAssociatedLocations())) {
            return false;
        }
        AbstractTraceRegion otherParent = other.getParent();
        AbstractTraceRegion parent = this.getParent();
        if (otherParent == null) {
            if (parent != null) {
                return false;
            }
        } else {
            if (parent == null) {
                return false;
            }
            if (!parent.equals(otherParent)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        List<AbstractTraceRegion> nested = this.getNestedRegions();
        Object nestedText = nested.isEmpty() ? "" : " nestedRegions={\n  " + Joiner.on((String)"\n").join(nested).replace("\n", "\n  ") + "\n}";
        List<ILocationData> associated = this.getAssociatedLocations();
        Object associatedText = associated.isEmpty() ? "" : " associations={\n  " + Joiner.on((String)"\n").join(associated).replace("\n", "\n  ") + "\n}";
        return this.getClass().getSimpleName() + " [myOffset=" + this.getMyOffset() + ", myLength=" + this.getMyLength() + ", useForDebugging=" + this.isUseForDebugging() + "]" + (String)associatedText + (String)nestedText;
    }
}

