/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.preferences;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.xtext.ui.editor.preferences.FixedScopedPreferenceStore;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreInitializer;
import org.eclipse.xtext.ui.internal.Activator;

@Singleton
public class PreferenceStoreAccessImpl
implements IPreferenceStoreAccess {
    private String qualifier;
    private boolean initialized = false;
    @Inject
    private IPreferenceStoreInitializer.CompositeImpl initializer;

    @Override
    public IPreferenceStore getPreferenceStore() {
        this.lazyInitialize();
        Activator activator = Activator.getDefault();
        if (activator != null) {
            return new ChainedPreferenceStore(new IPreferenceStore[]{this.getWritablePreferenceStore(), activator.getPreferenceStore(), EditorsUI.getPreferenceStore()});
        }
        return new ChainedPreferenceStore(new IPreferenceStore[]{this.getWritablePreferenceStore(), EditorsUI.getPreferenceStore()});
    }

    @Override
    public IPreferenceStore getContextPreferenceStore(Object context) {
        this.lazyInitialize();
        Activator activator = Activator.getDefault();
        if (activator != null) {
            return new ChainedPreferenceStore(new IPreferenceStore[]{this.getWritablePreferenceStore(context), activator.getPreferenceStore(), EditorsUI.getPreferenceStore()});
        }
        return new ChainedPreferenceStore(new IPreferenceStore[]{this.getWritablePreferenceStore(context), EditorsUI.getPreferenceStore()});
    }

    @Override
    public IPreferenceStore getWritablePreferenceStore() {
        this.lazyInitialize();
        FixedScopedPreferenceStore result = new FixedScopedPreferenceStore(InstanceScope.INSTANCE, this.getQualifier());
        result.setSearchContexts(new IScopeContext[]{InstanceScope.INSTANCE, ConfigurationScope.INSTANCE});
        return result;
    }

    @Override
    public IPreferenceStore getWritablePreferenceStore(Object context) {
        this.lazyInitialize();
        IProject project = this.getProject(context);
        if (project == null) {
            return this.getWritablePreferenceStore();
        }
        ProjectScope projectScope = new ProjectScope(project);
        FixedScopedPreferenceStore result = new FixedScopedPreferenceStore((IScopeContext)projectScope, this.getQualifier());
        result.setSearchContexts(new IScopeContext[]{projectScope, InstanceScope.INSTANCE, ConfigurationScope.INSTANCE});
        return result;
    }

    protected IProject getProject(Object context) {
        if (context instanceof IFileEditorInput) {
            return ((IFileEditorInput)context).getFile().getProject();
        }
        if (context instanceof IProject) {
            return (IProject)context;
        }
        return null;
    }

    @Inject
    public void setLanguageNameAsQualifier(@Named(value="languageName") String languageName) {
        this.qualifier = languageName;
    }

    protected String getQualifier() {
        return this.qualifier;
    }

    protected void lazyInitialize() {
        if (!this.initialized) {
            this.initialized = true;
            this.initializer.initialize(this);
        }
    }
}

