/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.macro.ConditionUtils;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.macro.declaration.JvmAnnotationReferenceImpl;
import org.eclipse.xtend.core.macro.declaration.JvmEnumerationValueDeclarationImpl;
import org.eclipse.xtend.core.macro.declaration.TypeReferenceImpl;
import org.eclipse.xtend.core.macro.declaration.XtendAnnotationReferenceImpl;
import org.eclipse.xtend.core.macro.declaration.XtendEnumerationValueDeclarationImpl;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.EnumerationTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.EnumerationValueDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.services.AnnotationReferenceBuildContext;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationAnnotationValue;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmByteAnnotationValue;
import org.eclipse.xtext.common.types.JvmCharAnnotationValue;
import org.eclipse.xtext.common.types.JvmCustomAnnotationValue;
import org.eclipse.xtext.common.types.JvmDoubleAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmFloatAnnotationValue;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIntAnnotationValue;
import org.eclipse.xtext.common.types.JvmLongAnnotationValue;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmShortAnnotationValue;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class AnnotationReferenceBuildContextImpl
implements AnnotationReferenceBuildContext {
    @Accessors
    private JvmAnnotationReference delegate;
    @Accessors
    private CompilationUnitImpl compilationUnit;

    protected JvmOperation findOperation(String name) {
        ConditionUtils.checkJavaIdentifier(name, "name");
        JvmAnnotationType annotationType = this.delegate.getAnnotation();
        Functions.Function1 _function = it -> {
            String _simpleName = it.getSimpleName();
            return Objects.equals(_simpleName, name);
        };
        JvmOperation jvmOperation = (JvmOperation)IterableExtensions.findFirst((Iterable)annotationType.getDeclaredOperations(), (Functions.Function1)_function);
        if (jvmOperation == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("The annotation property '");
            _builder.append(name);
            _builder.append("' is not declared on the annotation type '");
            String _identifier = annotationType.getIdentifier();
            _builder.append(_identifier);
            _builder.append("'.");
            throw new IllegalArgumentException(_builder.toString());
        }
        return jvmOperation;
    }

    protected boolean remove(String name) {
        JvmOperation op = this.findOperation(name);
        return this.remove(op);
    }

    protected boolean remove(JvmOperation op) {
        Predicate _function = it -> Objects.equals(op, it.getOperation()) || it.getOperation() == null && Objects.equals(op.getSimpleName(), "value");
        return Iterators.removeIf((Iterator)this.delegate.getExplicitValues().iterator(), (Predicate)_function);
    }

    protected JvmOperation findOperation(String name, boolean mustBeArray) {
        JvmOperation result = this.findOperation(name);
        JvmTypeReference _returnType = result.getReturnType();
        JvmType _type = null;
        if (_returnType != null) {
            _type = _returnType.getType();
        }
        JvmType returnType = _type;
        boolean _and = false;
        if (!mustBeArray) {
            _and = false;
        } else {
            boolean _notEquals;
            EClass _eClass = null;
            if (returnType != null) {
                _eClass = returnType.eClass();
            }
            _and = _notEquals = !Objects.equals(_eClass, TypesPackage.Literals.JVM_ARRAY_TYPE);
        }
        if (_and) {
            throw new IllegalArgumentException("Cannot assign array value to simple annotation property");
        }
        return result;
    }

    public void set(String name, Object value) {
        this.internalSet(name, value, false);
    }

    public void setAnnotationValue(String name, AnnotationReference ... value) {
        int _length = value.length;
        boolean _notEquals = _length != 1;
        this.internalSet(name, value, _notEquals);
    }

    public void setBooleanValue(String name, boolean ... value) {
        int _length = value.length;
        boolean _notEquals = _length != 1;
        this._internalSet(name, value, _notEquals);
    }

    public void setByteValue(String name, byte ... value) {
        int _length = value.length;
        boolean _notEquals = _length != 1;
        this._internalSet(name, value, _notEquals);
    }

    public void setCharValue(String name, char ... value) {
        int _length = value.length;
        boolean _notEquals = _length != 1;
        this._internalSet(name, value, _notEquals);
    }

    public void setClassValue(String name, TypeReference ... value) {
        int _length = value.length;
        boolean _notEquals = _length != 1;
        this._internalSet(name, value, _notEquals);
    }

    public void setDoubleValue(String name, double ... value) {
        int _length = value.length;
        boolean _notEquals = _length != 1;
        this._internalSet(name, value, _notEquals);
    }

    public void setEnumValue(String name, EnumerationValueDeclaration ... value) {
        int _length = value.length;
        boolean _notEquals = _length != 1;
        this._internalSet(name, value, _notEquals);
    }

    public void setFloatValue(String name, float ... value) {
        int _length = value.length;
        boolean _notEquals = _length != 1;
        this._internalSet(name, value, _notEquals);
    }

    public void setIntValue(String name, int ... value) {
        int _length = value.length;
        boolean _notEquals = _length != 1;
        this._internalSet(name, value, _notEquals);
    }

    public void setLongValue(String name, long ... value) {
        int _length = value.length;
        boolean _notEquals = _length != 1;
        this._internalSet(name, value, _notEquals);
    }

    public void setShortValue(String name, short ... value) {
        int _length = value.length;
        boolean _notEquals = _length != 1;
        this._internalSet(name, value, _notEquals);
    }

    public void setStringValue(String name, String ... value) {
        int _length = value.length;
        boolean _notEquals = _length != 1;
        this._internalSet(name, value, _notEquals);
    }

    protected void _internalSet(String name, Void value, boolean mustBeArray) {
        this.remove(name);
    }

    protected void _internalSet(String name, Object values, boolean mustBeArray) {
        String _canonicalName = values.getClass().getCanonicalName();
        String _plus = "Cannot set annotation values of type " + _canonicalName;
        throw new IllegalArgumentException(_plus);
    }

    protected void _internalSet(String name, String value, boolean mustBeArray) {
        String[] arr = new String[]{value};
        this._internalSet(name, arr, false);
    }

    protected void _internalSet(String name, String[] values, boolean mustBeArray) {
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)values), "values");
        this.setValues(name, values, String.class.getName(), mustBeArray);
    }

    protected void _internalSet(String name, Boolean value, boolean mustBeArray) {
        boolean _booleanValue = value;
        boolean[] arr = new boolean[]{_booleanValue};
        this._internalSet(name, arr, false);
    }

    protected void _internalSet(String name, boolean[] values, boolean mustBeArray) {
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)values), "values");
        this.setValues(name, values, "boolean", mustBeArray);
    }

    protected void _internalSet(String name, Integer value, boolean mustBeArray) {
        int _intValue = value;
        int[] arr = new int[]{_intValue};
        this._internalSet(name, arr, false);
    }

    protected void _internalSet(String name, int[] values, boolean mustBeArray) {
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)values), "values");
        this.setValues(name, values, "int", mustBeArray);
    }

    protected void _internalSet(String name, Short value, boolean mustBeArray) {
        short _shortValue = value;
        short[] arr = new short[]{_shortValue};
        this._internalSet(name, arr, false);
    }

    protected void _internalSet(String name, short[] values, boolean mustBeArray) {
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)values), "values");
        this.setValues(name, values, "short", mustBeArray);
    }

    protected void _internalSet(String name, Long value, boolean mustBeArray) {
        long _longValue = value;
        long[] arr = new long[]{_longValue};
        this._internalSet(name, arr, false);
    }

    protected void _internalSet(String name, long[] values, boolean mustBeArray) {
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)values), "values");
        this.setValues(name, values, "long", mustBeArray);
    }

    protected void _internalSet(String name, Double value, boolean mustBeArray) {
        double _doubleValue = value;
        double[] arr = new double[]{_doubleValue};
        this._internalSet(name, arr, false);
    }

    protected void _internalSet(String name, double[] values, boolean mustBeArray) {
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)values), "values");
        this.setValues(name, values, "double", mustBeArray);
    }

    protected void _internalSet(String name, Float value, boolean mustBeArray) {
        float _floatValue = value.floatValue();
        float[] arr = new float[]{_floatValue};
        this._internalSet(name, arr, false);
    }

    protected void _internalSet(String name, float[] values, boolean mustBeArray) {
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)values), "values");
        this.setValues(name, values, "float", mustBeArray);
    }

    protected void _internalSet(String name, Character value, boolean mustBeArray) {
        char _charValue = value.charValue();
        char[] arr = new char[]{_charValue};
        this._internalSet(name, arr, false);
    }

    protected void _internalSet(String name, char[] values, boolean mustBeArray) {
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)values), "values");
        this.setValues(name, values, "char", mustBeArray);
    }

    protected void _internalSet(String name, Byte value, boolean mustBeArray) {
        byte _byteValue = value;
        byte[] arr = new byte[]{_byteValue};
        this._internalSet(name, arr, false);
    }

    protected void _internalSet(String name, byte[] values, boolean mustBeArray) {
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)values), "values");
        this.setValues(name, values, "byte", mustBeArray);
    }

    protected void _internalSet(String name, TypeReference value, boolean mustBeArray) {
        this._internalSet(name, new TypeReference[]{value}, false);
    }

    protected void _internalSet(String name, TypeReference[] values, boolean mustBeArray) {
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)values), "values");
        this.setValues(name, values, TypeReference.class.getName(), mustBeArray);
    }

    protected void _internalSet(String name, EnumerationValueDeclaration[] values, boolean mustBeArray) {
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)values), "values");
        EnumerationValueDeclaration _head = (EnumerationValueDeclaration)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)values)));
        EnumerationTypeDeclaration _declaringType = null;
        if (_head != null) {
            _declaringType = _head.getDeclaringType();
        }
        String _qualifiedName = null;
        if (_declaringType != null) {
            _qualifiedName = _declaringType.getQualifiedName();
        }
        this.setValues(name, values, _qualifiedName, mustBeArray);
    }

    protected void _internalSet(String name, XtendAnnotationReferenceImpl value, boolean mustBeArray) {
        this.setValues(name, value, null, mustBeArray);
    }

    protected void _internalSet(String name, AnnotationReference value, boolean mustBeArray) {
        this._internalSet(name, new AnnotationReference[]{value}, false);
    }

    protected void _internalSet(String name, AnnotationReference[] values, boolean mustBeArray) {
        ConditionUtils.checkIterable((Iterable)Conversions.doWrapArray((Object)values), "values");
        AnnotationReference _head = (AnnotationReference)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)values)));
        AnnotationTypeDeclaration _annotationTypeDeclaration = null;
        if (_head != null) {
            _annotationTypeDeclaration = _head.getAnnotationTypeDeclaration();
        }
        String _qualifiedName = null;
        if (_annotationTypeDeclaration != null) {
            _qualifiedName = _annotationTypeDeclaration.getQualifiedName();
        }
        this.setValues(name, values, _qualifiedName, mustBeArray);
    }

    protected void _internalSet(String name, EnumerationValueDeclaration value, boolean mustBeArray) {
        this._internalSet(name, new EnumerationValueDeclaration[]{value}, false);
    }

    protected void setValues(String name, Object values, String componentType, boolean mustBeArray) {
        JvmOperation op = this.findOperation(name, mustBeArray);
        JvmAnnotationValue newValue = this.createAnnotationValue(op, values);
        newValue.setOperation(op);
        this.setValue(newValue, values, componentType, mustBeArray);
        this.remove(op);
        this.delegate.getExplicitValues().add((Object)newValue);
    }

    protected JvmAnnotationValue createAnnotationValue(JvmOperation op, Object values) {
        JvmDoubleAnnotationValue _switchResult_1;
        boolean _matched;
        JvmType type;
        JvmEnumAnnotationValue _switchResult;
        JvmEnumAnnotationValue _xblockexpression;
        block36: {
            block39: {
                block37: {
                    _xblockexpression = null;
                    JvmTypeReference _returnType = op.getReturnType();
                    JvmType _type = null;
                    if (_returnType != null) {
                        _type = _returnType.getType();
                    }
                    JvmType returnType = _type;
                    _switchResult = null;
                    Object _xifexpression = null;
                    _xifexpression = returnType instanceof JvmArrayType ? ((JvmArrayType)returnType).getComponentType() : returnType;
                    type = _xifexpression;
                    _matched = false;
                    if (!(type instanceof JvmPrimitiveType)) break block36;
                    _matched = true;
                    _switchResult_1 = null;
                    String _simpleName = ((JvmPrimitiveType)type).getSimpleName();
                    if (_simpleName == null) break block37;
                    switch (_simpleName) {
                        case "boolean": {
                            _switchResult_1 = TypesFactory.eINSTANCE.createJvmBooleanAnnotationValue();
                            break block39;
                        }
                        case "double": {
                            _switchResult_1 = TypesFactory.eINSTANCE.createJvmDoubleAnnotationValue();
                            break block39;
                        }
                        case "float": {
                            _switchResult_1 = TypesFactory.eINSTANCE.createJvmFloatAnnotationValue();
                            break block39;
                        }
                        case "long": {
                            _switchResult_1 = TypesFactory.eINSTANCE.createJvmLongAnnotationValue();
                            break block39;
                        }
                        case "int": {
                            _switchResult_1 = TypesFactory.eINSTANCE.createJvmIntAnnotationValue();
                            break block39;
                        }
                        case "short": {
                            _switchResult_1 = TypesFactory.eINSTANCE.createJvmShortAnnotationValue();
                            break block39;
                        }
                        case "char": {
                            _switchResult_1 = TypesFactory.eINSTANCE.createJvmCharAnnotationValue();
                            break block39;
                        }
                        case "byte": {
                            _switchResult_1 = TypesFactory.eINSTANCE.createJvmByteAnnotationValue();
                            break block39;
                        }
                        default: {
                            throw new IllegalStateException("Unknown type: " + String.valueOf(type));
                        }
                    }
                }
                throw new IllegalStateException("Unknown type: " + String.valueOf(type));
            }
            _switchResult = _switchResult_1;
        }
        if (!_matched && type instanceof JvmGenericType) {
            String _name_1;
            _matched = true;
            _switchResult_1 = null;
            String _identifier = ((JvmGenericType)type).getIdentifier();
            boolean _matched_1 = false;
            String _name = String.class.getName();
            if (Objects.equals(_identifier, _name)) {
                _matched_1 = true;
                _switchResult_1 = TypesFactory.eINSTANCE.createJvmStringAnnotationValue();
            }
            if (!_matched_1 && Objects.equals(_identifier, _name_1 = Class.class.getName())) {
                _matched_1 = true;
                _switchResult_1 = TypesFactory.eINSTANCE.createJvmTypeAnnotationValue();
            }
            if (!_matched_1) {
                throw new IllegalStateException("Unknown type: " + String.valueOf(type));
            }
            _switchResult = _switchResult_1;
        }
        if (!_matched && type instanceof JvmEnumerationType) {
            _matched = true;
            _switchResult = TypesFactory.eINSTANCE.createJvmEnumAnnotationValue();
        }
        if (!_matched && type instanceof JvmAnnotationType) {
            _matched = true;
            Object _xifexpression_1 = null;
            _xifexpression_1 = values instanceof XtendAnnotationReferenceImpl ? TypesFactory.eINSTANCE.createJvmCustomAnnotationValue() : TypesFactory.eINSTANCE.createJvmAnnotationAnnotationValue();
            _switchResult = _xifexpression_1;
        }
        if (!_matched) {
            throw new IllegalStateException("Unknown type: " + String.valueOf(type));
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected void _setValue(JvmAnnotationValue it, Object value, String componentType, boolean mustBeArray) {
        if (componentType == null) {
            this.throwNotApplicable(it, value.getClass().getName());
        }
        boolean _or = false;
        if (mustBeArray) {
            _or = true;
        } else {
            boolean _equals;
            JvmTypeReference _returnType = it.getOperation().getReturnType();
            JvmType _type = null;
            if (_returnType != null) {
                _type = _returnType.getType();
            }
            EClass _eClass = null;
            if (_type != null) {
                _eClass = _type.eClass();
            }
            _or = _equals = Objects.equals(_eClass, TypesPackage.Literals.JVM_ARRAY_TYPE);
        }
        if (_or) {
            this.throwNotApplicable(it, componentType + "[]");
        }
        this.throwNotApplicable(it, componentType);
    }

    protected void _setValue(JvmTypeAnnotationValue it, TypeReference[] value, String componentType, boolean mustBeArray) {
        EList _values = it.getValues();
        Functions.Function1 _function = it_1 -> this.compilationUnit.toJvmTypeReference((TypeReference)it_1);
        Iterable _map = IterableExtensions.map((Iterable)Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)value)), TypeReferenceImpl.class), (Functions.Function1)_function);
        Iterables.addAll((Collection)_values, (Iterable)_map);
    }

    protected void _setValue(JvmEnumAnnotationValue it, EnumerationValueDeclaration[] value, String componentType, boolean mustBeArray) {
        this.checkType((JvmAnnotationValue)it, componentType, mustBeArray);
        EnumerationValueDeclaration[] enumerationValueDeclarationArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            EnumerationValueDeclaration enumValue = enumerationValueDeclarationArray[n2];
            boolean _matched = false;
            if (enumValue instanceof JvmEnumerationValueDeclarationImpl) {
                _matched = true;
                it.getValues().add((Object)((JvmEnumerationLiteral)((JvmEnumerationValueDeclarationImpl)enumValue).getDelegate()));
            }
            if (!_matched && enumValue instanceof XtendEnumerationValueDeclarationImpl) {
                _matched = true;
                throw new IllegalArgumentException("Cannot set source elements.");
            }
            ++n2;
        }
    }

    protected void _setValue(JvmAnnotationAnnotationValue it, AnnotationReference[] value, String componentType, boolean mustBeArray) {
        this.checkType((JvmAnnotationValue)it, componentType, mustBeArray);
        AnnotationReference[] annotationReferenceArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationReference annotationValue = annotationReferenceArray[n2];
            boolean _matched = false;
            if (annotationValue instanceof JvmAnnotationReferenceImpl) {
                _matched = true;
                it.getValues().add((Object)((JvmAnnotationReference)EcoreUtil2.cloneWithProxies((EObject)((JvmAnnotationReference)((JvmAnnotationReferenceImpl)annotationValue).getDelegate()))));
            }
            if (!_matched && annotationValue instanceof XtendAnnotationReferenceImpl) {
                _matched = true;
                throw new IllegalArgumentException("Multiple source annotations cannot be set as values. Please the the expression not the value.");
            }
            ++n2;
        }
    }

    protected void _setValue(JvmCustomAnnotationValue it, XtendAnnotationReferenceImpl value, String componentType, boolean mustBeArray) {
        it.getValues().add((Object)((EObject)value.getDelegate()));
    }

    protected void _setValue(JvmStringAnnotationValue it, String[] value, String componentType, boolean mustBeArray) {
        EList _values = it.getValues();
        Iterables.addAll((Collection)_values, (Iterable)((Iterable)Conversions.doWrapArray((Object)value)));
    }

    protected void _setValue(JvmBooleanAnnotationValue it, boolean[] value, String componentType, boolean mustBeArray) {
        EList _values = it.getValues();
        Iterables.addAll((Collection)_values, (Iterable)((Iterable)Conversions.doWrapArray((Object)value)));
    }

    protected void _setValue(JvmDoubleAnnotationValue it, double[] value, String componentType, boolean mustBeArray) {
        EList _values = it.getValues();
        Iterables.addAll((Collection)_values, (Iterable)((Iterable)Conversions.doWrapArray((Object)value)));
    }

    protected void _setValue(JvmDoubleAnnotationValue it, float[] value, String componentType, boolean mustBeArray) {
        Consumer<Float> _function = v -> {
            EList _values = it.getValues();
            _values.add((Object)v.floatValue());
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmDoubleAnnotationValue it, long[] value, String componentType, boolean mustBeArray) {
        Consumer<Long> _function = v -> {
            EList _values = it.getValues();
            _values.add(v);
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmDoubleAnnotationValue it, int[] value, String componentType, boolean mustBeArray) {
        Consumer<Integer> _function = v -> {
            EList _values = it.getValues();
            _values.add(v);
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmDoubleAnnotationValue it, short[] value, String componentType, boolean mustBeArray) {
        Consumer<Short> _function = v -> {
            EList _values = it.getValues();
            _values.add(v);
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmDoubleAnnotationValue it, byte[] value, String componentType, boolean mustBeArray) {
        Consumer<Byte> _function = v -> {
            EList _values = it.getValues();
            _values.add(v);
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmDoubleAnnotationValue it, char[] value, String componentType, boolean mustBeArray) {
        Consumer<Character> _function = v -> {
            EList _values = it.getValues();
            _values.add((Object)v.charValue());
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmFloatAnnotationValue it, float[] value, String componentType, boolean mustBeArray) {
        EList _values = it.getValues();
        Iterables.addAll((Collection)_values, (Iterable)((Iterable)Conversions.doWrapArray((Object)value)));
    }

    protected void _setValue(JvmFloatAnnotationValue it, long[] value, String componentType, boolean mustBeArray) {
        Consumer<Long> _function = v -> {
            EList _values = it.getValues();
            _values.add((Object)Float.valueOf(v.longValue()));
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmFloatAnnotationValue it, int[] value, String componentType, boolean mustBeArray) {
        Consumer<Integer> _function = v -> {
            EList _values = it.getValues();
            _values.add((Object)Float.valueOf(v.intValue()));
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmFloatAnnotationValue it, short[] value, String componentType, boolean mustBeArray) {
        Consumer<Short> _function = v -> {
            EList _values = it.getValues();
            _values.add((Object)Float.valueOf(v.shortValue()));
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmFloatAnnotationValue it, byte[] value, String componentType, boolean mustBeArray) {
        Consumer<Byte> _function = v -> {
            EList _values = it.getValues();
            _values.add((Object)Float.valueOf(v.byteValue()));
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmFloatAnnotationValue it, char[] value, String componentType, boolean mustBeArray) {
        Consumer<Character> _function = v -> {
            EList _values = it.getValues();
            _values.add((Object)Float.valueOf(v.charValue()));
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmLongAnnotationValue it, long[] value, String componentType, boolean mustBeArray) {
        EList _values = it.getValues();
        Iterables.addAll((Collection)_values, (Iterable)((Iterable)Conversions.doWrapArray((Object)value)));
    }

    protected void _setValue(JvmLongAnnotationValue it, int[] value, String componentType, boolean mustBeArray) {
        Consumer<Integer> _function = v -> {
            EList _values = it.getValues();
            _values.add(v);
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmLongAnnotationValue it, short[] value, String componentType, boolean mustBeArray) {
        Consumer<Short> _function = v -> {
            EList _values = it.getValues();
            _values.add(v);
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmLongAnnotationValue it, byte[] value, String componentType, boolean mustBeArray) {
        Consumer<Byte> _function = v -> {
            EList _values = it.getValues();
            _values.add(v);
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmLongAnnotationValue it, char[] value, String componentType, boolean mustBeArray) {
        Consumer<Character> _function = v -> {
            EList _values = it.getValues();
            _values.add((Object)v.charValue());
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmIntAnnotationValue it, int[] value, String componentType, boolean mustBeArray) {
        EList _values = it.getValues();
        Iterables.addAll((Collection)_values, (Iterable)((Iterable)Conversions.doWrapArray((Object)value)));
    }

    protected void _setValue(JvmIntAnnotationValue it, short[] value, String componentType, boolean mustBeArray) {
        Consumer<Short> _function = v -> {
            EList _values = it.getValues();
            _values.add(v);
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmIntAnnotationValue it, byte[] value, String componentType, boolean mustBeArray) {
        Consumer<Byte> _function = v -> {
            EList _values = it.getValues();
            _values.add(v);
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmIntAnnotationValue it, char[] value, String componentType, boolean mustBeArray) {
        Consumer<Character> _function = v -> {
            EList _values = it.getValues();
            _values.add((Object)v.charValue());
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmShortAnnotationValue it, short[] value, String componentType, boolean mustBeArray) {
        EList _values = it.getValues();
        Iterables.addAll((Collection)_values, (Iterable)((Iterable)Conversions.doWrapArray((Object)value)));
    }

    protected void _setValue(JvmShortAnnotationValue it, byte[] value, String componentType, boolean mustBeArray) {
        Consumer<Byte> _function = v -> {
            EList _values = it.getValues();
            _values.add(v);
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmCharAnnotationValue it, char[] value, String componentType, boolean mustBeArray) {
        EList _values = it.getValues();
        Iterables.addAll((Collection)_values, (Iterable)((Iterable)Conversions.doWrapArray((Object)value)));
    }

    protected void _setValue(JvmCharAnnotationValue it, byte[] value, String componentType, boolean mustBeArray) {
        Consumer<Byte> _function = v -> {
            EList _values = it.getValues();
            _values.add((Object)Character.valueOf((char)v.byteValue()));
        };
        ((List)Conversions.doWrapArray((Object)value)).forEach(_function);
    }

    protected void _setValue(JvmByteAnnotationValue it, byte[] value, String componentType, boolean mustBeArray) {
        EList _values = it.getValues();
        Iterables.addAll((Collection)_values, (Iterable)((Iterable)Conversions.doWrapArray((Object)value)));
    }

    protected void checkType(JvmAnnotationValue it, String componentType, boolean mustBeArray) {
        if (componentType == null) {
            return;
        }
        JvmTypeReference _returnType = it.getOperation().getReturnType();
        JvmType _type = null;
        if (_returnType != null) {
            _type = _returnType.getType();
        }
        JvmType returnType = _type;
        boolean _or = false;
        if (mustBeArray) {
            _or = true;
        } else {
            boolean _equals;
            EClass _eClass = null;
            if (returnType != null) {
                _eClass = returnType.eClass();
            }
            _or = _equals = Objects.equals(_eClass, TypesPackage.Literals.JVM_ARRAY_TYPE);
        }
        if (_or) {
            ConditionUtils.checkTypeName(this.getAnnotationValueTypeName(returnType), componentType + "[]");
        } else {
            ConditionUtils.checkTypeName(this.getAnnotationValueTypeName(returnType), componentType);
        }
    }

    protected void throwNotApplicable(JvmAnnotationValue it, String valueType) {
        JvmTypeReference _returnType = it.getOperation().getReturnType();
        JvmType _type = null;
        if (_returnType != null) {
            _type = _returnType.getType();
        }
        String _isNotApplicableMessage = ConditionUtils.isNotApplicableMessage(valueType, this.getAnnotationValueTypeName(_type));
        throw new IllegalArgumentException(_isNotApplicableMessage);
    }

    protected String getAnnotationValueTypeName(JvmType type) {
        Object _switchResult;
        block14: {
            String result;
            block12: {
                _switchResult = null;
                String _identifier = null;
                if (type != null) {
                    _identifier = type.getIdentifier();
                }
                String _replace = null;
                if (_identifier != null) {
                    _replace = _identifier.replace("$", ".");
                }
                if ((result = _replace) == null) break block12;
                switch (result) {
                    case "java.lang.Class": {
                        _switchResult = TypeReference.class.getName();
                        break;
                    }
                    case "java.lang.Class[]": {
                        String _name = TypeReference.class.getName();
                        _switchResult = _name + "[]";
                        break;
                    }
                    default: {
                        _switchResult = result;
                        break;
                    }
                }
                break block14;
            }
            _switchResult = result;
        }
        return _switchResult;
    }

    public void internalSet(String name, Object value, boolean mustBeArray) {
        if (value instanceof EnumerationValueDeclaration) {
            this._internalSet(name, (EnumerationValueDeclaration)value, mustBeArray);
            return;
        }
        if (value instanceof Byte) {
            this._internalSet(name, (Byte)value, mustBeArray);
            return;
        }
        if (value instanceof Double) {
            this._internalSet(name, (Double)value, mustBeArray);
            return;
        }
        if (value instanceof Float) {
            this._internalSet(name, (Float)value, mustBeArray);
            return;
        }
        if (value instanceof Integer) {
            this._internalSet(name, (Integer)value, mustBeArray);
            return;
        }
        if (value instanceof Long) {
            this._internalSet(name, (Long)value, mustBeArray);
            return;
        }
        if (value instanceof Short) {
            this._internalSet(name, (Short)value, mustBeArray);
            return;
        }
        if (value instanceof XtendAnnotationReferenceImpl) {
            this._internalSet(name, (XtendAnnotationReferenceImpl)value, mustBeArray);
            return;
        }
        if (value instanceof Boolean) {
            this._internalSet(name, (Boolean)value, mustBeArray);
            return;
        }
        if (value instanceof Character) {
            this._internalSet(name, (Character)value, mustBeArray);
            return;
        }
        if (value instanceof String) {
            this._internalSet(name, (String)value, mustBeArray);
            return;
        }
        if (value instanceof AnnotationReference) {
            this._internalSet(name, (AnnotationReference)value, mustBeArray);
            return;
        }
        if (value instanceof TypeReference) {
            this._internalSet(name, (TypeReference)value, mustBeArray);
            return;
        }
        if (value instanceof boolean[]) {
            this._internalSet(name, (boolean[])value, mustBeArray);
            return;
        }
        if (value instanceof byte[]) {
            this._internalSet(name, (byte[])value, mustBeArray);
            return;
        }
        if (value instanceof char[]) {
            this._internalSet(name, (char[])value, mustBeArray);
            return;
        }
        if (value instanceof double[]) {
            this._internalSet(name, (double[])value, mustBeArray);
            return;
        }
        if (value instanceof float[]) {
            this._internalSet(name, (float[])value, mustBeArray);
            return;
        }
        if (value instanceof int[]) {
            this._internalSet(name, (int[])value, mustBeArray);
            return;
        }
        if (value instanceof String[]) {
            this._internalSet(name, (String[])value, mustBeArray);
            return;
        }
        if (value == null) {
            this._internalSet(name, (Void)null, mustBeArray);
            return;
        }
        if (value instanceof long[]) {
            this._internalSet(name, (long[])value, mustBeArray);
            return;
        }
        if (value instanceof AnnotationReference[]) {
            this._internalSet(name, (AnnotationReference[])value, mustBeArray);
            return;
        }
        if (value instanceof EnumerationValueDeclaration[]) {
            this._internalSet(name, (EnumerationValueDeclaration[])value, mustBeArray);
            return;
        }
        if (value instanceof TypeReference[]) {
            this._internalSet(name, (TypeReference[])value, mustBeArray);
            return;
        }
        if (value instanceof short[]) {
            this._internalSet(name, (short[])value, mustBeArray);
            return;
        }
        if (value != null) {
            this._internalSet(name, value, mustBeArray);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(name, value, mustBeArray).toString());
    }

    protected void setValue(JvmAnnotationValue it, Object value, String componentType, boolean mustBeArray) {
        if (it instanceof JvmCustomAnnotationValue && value instanceof XtendAnnotationReferenceImpl) {
            this._setValue((JvmCustomAnnotationValue)it, (XtendAnnotationReferenceImpl)value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmAnnotationAnnotationValue && value instanceof AnnotationReference[]) {
            this._setValue((JvmAnnotationAnnotationValue)it, (AnnotationReference[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmBooleanAnnotationValue && value instanceof boolean[]) {
            this._setValue((JvmBooleanAnnotationValue)it, (boolean[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmByteAnnotationValue && value instanceof byte[]) {
            this._setValue((JvmByteAnnotationValue)it, (byte[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmCharAnnotationValue && value instanceof byte[]) {
            this._setValue((JvmCharAnnotationValue)it, (byte[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmCharAnnotationValue && value instanceof char[]) {
            this._setValue((JvmCharAnnotationValue)it, (char[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmDoubleAnnotationValue && value instanceof byte[]) {
            this._setValue((JvmDoubleAnnotationValue)it, (byte[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmDoubleAnnotationValue && value instanceof char[]) {
            this._setValue((JvmDoubleAnnotationValue)it, (char[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmDoubleAnnotationValue && value instanceof double[]) {
            this._setValue((JvmDoubleAnnotationValue)it, (double[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmDoubleAnnotationValue && value instanceof float[]) {
            this._setValue((JvmDoubleAnnotationValue)it, (float[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmDoubleAnnotationValue && value instanceof int[]) {
            this._setValue((JvmDoubleAnnotationValue)it, (int[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmDoubleAnnotationValue && value instanceof long[]) {
            this._setValue((JvmDoubleAnnotationValue)it, (long[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmDoubleAnnotationValue && value instanceof short[]) {
            this._setValue((JvmDoubleAnnotationValue)it, (short[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmEnumAnnotationValue && value instanceof EnumerationValueDeclaration[]) {
            this._setValue((JvmEnumAnnotationValue)it, (EnumerationValueDeclaration[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmFloatAnnotationValue && value instanceof byte[]) {
            this._setValue((JvmFloatAnnotationValue)it, (byte[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmFloatAnnotationValue && value instanceof char[]) {
            this._setValue((JvmFloatAnnotationValue)it, (char[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmFloatAnnotationValue && value instanceof float[]) {
            this._setValue((JvmFloatAnnotationValue)it, (float[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmFloatAnnotationValue && value instanceof int[]) {
            this._setValue((JvmFloatAnnotationValue)it, (int[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmFloatAnnotationValue && value instanceof long[]) {
            this._setValue((JvmFloatAnnotationValue)it, (long[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmFloatAnnotationValue && value instanceof short[]) {
            this._setValue((JvmFloatAnnotationValue)it, (short[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmIntAnnotationValue && value instanceof byte[]) {
            this._setValue((JvmIntAnnotationValue)it, (byte[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmIntAnnotationValue && value instanceof char[]) {
            this._setValue((JvmIntAnnotationValue)it, (char[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmIntAnnotationValue && value instanceof int[]) {
            this._setValue((JvmIntAnnotationValue)it, (int[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmIntAnnotationValue && value instanceof short[]) {
            this._setValue((JvmIntAnnotationValue)it, (short[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmLongAnnotationValue && value instanceof byte[]) {
            this._setValue((JvmLongAnnotationValue)it, (byte[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmLongAnnotationValue && value instanceof char[]) {
            this._setValue((JvmLongAnnotationValue)it, (char[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmLongAnnotationValue && value instanceof int[]) {
            this._setValue((JvmLongAnnotationValue)it, (int[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmLongAnnotationValue && value instanceof long[]) {
            this._setValue((JvmLongAnnotationValue)it, (long[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmLongAnnotationValue && value instanceof short[]) {
            this._setValue((JvmLongAnnotationValue)it, (short[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmShortAnnotationValue && value instanceof byte[]) {
            this._setValue((JvmShortAnnotationValue)it, (byte[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmShortAnnotationValue && value instanceof short[]) {
            this._setValue((JvmShortAnnotationValue)it, (short[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmStringAnnotationValue && value instanceof String[]) {
            this._setValue((JvmStringAnnotationValue)it, (String[])value, componentType, mustBeArray);
            return;
        }
        if (it instanceof JvmTypeAnnotationValue && value instanceof TypeReference[]) {
            this._setValue((JvmTypeAnnotationValue)it, (TypeReference[])value, componentType, mustBeArray);
            return;
        }
        if (it != null && value != null) {
            this._setValue(it, value, componentType, mustBeArray);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, value, componentType, mustBeArray).toString());
    }

    @Pure
    public JvmAnnotationReference getDelegate() {
        return this.delegate;
    }

    public void setDelegate(JvmAnnotationReference delegate) {
        this.delegate = delegate;
    }

    @Pure
    public CompilationUnitImpl getCompilationUnit() {
        return this.compilationUnit;
    }

    public void setCompilationUnit(CompilationUnitImpl compilationUnit) {
        this.compilationUnit = compilationUnit;
    }
}

