/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.smoketest.internal;

import org.eclipse.xtext.junit4.XtextRunner;
import org.eclipse.xtext.junit4.smoketest.IgnoredBySmokeTest;
import org.eclipse.xtext.junit4.smoketest.ProcessedBy;
import org.eclipse.xtext.junit4.smoketest.Scenario;
import org.eclipse.xtext.junit4.smoketest.Scenarios;
import org.eclipse.xtext.junit4.smoketest.internal.AllScenariosRunner;
import org.junit.Ignore;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.internal.builders.AnnotatedBuilder;
import org.junit.internal.builders.IgnoredBuilder;
import org.junit.internal.builders.IgnoredClassRunner;
import org.junit.runner.Runner;
import org.junit.runners.model.InitializationError;

@Deprecated(forRemoval=true, since="2.30")
public class RunnerBuilder
extends org.junit.runners.model.RunnerBuilder {
    private final Delegate delegate;

    public RunnerBuilder(Class<?> klass) throws InitializationError {
        ProcessedBy processor = RunnerBuilder.getProcessor(klass);
        Scenario[] scenarios = RunnerBuilder.getScenarios(klass, processor.processCompleteInput());
        this.delegate = new Delegate(processor, scenarios);
    }

    private static ProcessedBy getProcessor(Class<?> klass) throws InitializationError {
        ProcessedBy result = klass.getAnnotation(ProcessedBy.class);
        if (result == null) {
            throw new InitializationError(String.format("class '%s' must have a ProcessedBy annotation", klass.getName()));
        }
        return result;
    }

    private static Scenario[] getScenarios(Class<?> klass, boolean completeInput) throws InitializationError {
        Scenarios annotation = klass.getAnnotation(Scenarios.class);
        if (annotation == null) {
            return Scenario.values();
        }
        if (completeInput) {
            throw new InitializationError("Must not use ProcessedBy.processCompleteInput together with the Scenarios annotation");
        }
        Scenario[] result = annotation.value();
        if (result.length == 0) {
            throw new InitializationError("Must at least specify one smoke test scenario or omit the Scenarios annotation");
        }
        return result;
    }

    public Runner runnerForClass(Class<?> testClass) throws Throwable {
        return this.delegate.runnerForClass(testClass);
    }

    private static class Delegate
    extends AllDefaultPossibilitiesBuilder {
        private final ProcessedBy processor;
        private final Scenario[] scenarios;

        public Delegate(ProcessedBy processor, Scenario[] scenarios) {
            this.processor = processor;
            this.scenarios = scenarios;
        }

        protected AnnotatedBuilder annotatedBuilder() {
            return new AnnotatedBuilder((org.junit.runners.model.RunnerBuilder)this){

                public Runner buildRunner(Class<? extends Runner> runnerClass, Class<?> testClass) throws Exception {
                    if (XtextRunner.class.equals(runnerClass)) {
                        return new AllScenariosRunner(testClass, processor, scenarios);
                    }
                    return super.buildRunner(runnerClass, testClass);
                }
            };
        }

        protected IgnoredBuilder ignoredBuilder() {
            return new IgnoredBuilder(){

                public Runner runnerForClass(Class<?> testClass) {
                    if (testClass.getAnnotation(Ignore.class) != null || testClass.getAnnotation(IgnoredBySmokeTest.class) != null) {
                        return new IgnoredClassRunner(testClass);
                    }
                    return null;
                }
            };
        }
    }
}

