/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.annotations.validation;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.ILinkingDiagnosticMessageProvider;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.linking.impl.LinkingDiagnosticMessageProvider;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkHelper;
import org.eclipse.xtext.xbase.typesystem.internal.TypeAwareLinkingDiagnosticContext;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.util.FeatureCallAsTypeLiteralHelper;

public class UnresolvedFeatureCallTypeAwareMessageProvider
extends LinkingDiagnosticMessageProvider {
    public static final String TYPE_LITERAL = "key:TypeLiteral";
    public static final String FEATURE_CALL = "key:FeatureCall";
    @Inject
    private FeatureCallAsTypeLiteralHelper typeLiteralHelper;
    @Inject
    @Extension
    private FeatureLinkHelper featureLinkHelper;

    public DiagnosticMessage getUnresolvedProxyMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context) {
        String linkText = null;
        try {
            linkText = context.getLinkText();
        }
        catch (IllegalNodeException e) {
            linkText = e.getNode().getText();
        }
        if (linkText == null) {
            return null;
        }
        EObject contextObject = context.getContext();
        if (this.isStaticMemberCallTarget(contextObject)) {
            return new DiagnosticMessage(String.valueOf(linkText) + " cannot be resolved to a type.", Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[]{TYPE_LITERAL});
        }
        if (contextObject instanceof XAbstractFeatureCall && !((XAbstractFeatureCall)contextObject).isOperation()) {
            return this.handleUnresolvedFeatureCall(context, (XAbstractFeatureCall)contextObject, linkText);
        }
        EClass referenceType = context.getReference().getEReferenceType();
        String msg = String.valueOf(linkText) + " cannot be resolved" + this.getTypeName(referenceType, (EStructuralFeature)context.getReference()) + ".";
        return new DiagnosticMessage(msg, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[]{linkText});
    }

    private DiagnosticMessage handleUnresolvedFeatureCall(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context, XAbstractFeatureCall featureCall, String linkText) {
        LightweightTypeReference receiverType = null;
        String args = "";
        if (context instanceof TypeAwareLinkingDiagnosticContext) {
            IResolvedTypes types = ((TypeAwareLinkingDiagnosticContext)context).getResolvedTypes();
            if (this.featureLinkHelper.getSyntacticReceiver(featureCall) != null) {
                receiverType = types.getActualType(this.featureLinkHelper.getSyntacticReceiver(featureCall));
            }
            args = IterableExtensions.join((Iterable)Lists.transform(this.featureLinkHelper.getSyntacticArguments(featureCall), it -> types.getActualType((XExpression)it)), (CharSequence)", ", it -> {
                if (it == null || it.isAny()) {
                    return "Object";
                }
                return it.getHumanReadableName();
            });
        }
        boolean orField = !featureCall.isExplicitOperationCallOrBuilderSyntax();
        String msg = "";
        msg = orField ? "The method or field " + linkText + " is undefined" : "The method " + linkText + "(" + args + ") is undefined";
        if (receiverType != null) {
            msg = String.valueOf(msg) + " for the type " + receiverType.getHumanReadableName();
        }
        if (featureCall instanceof XFeatureCall && linkText.length() > 0 && Character.isUpperCase(linkText.charAt(0)) && this.typeLiteralHelper.isPotentialTypeLiteral(featureCall, null)) {
            return new DiagnosticMessage(msg, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[]{linkText, TYPE_LITERAL});
        }
        return new DiagnosticMessage(msg, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[]{linkText, FEATURE_CALL});
    }

    protected boolean isStaticMemberCallTarget(EObject contextObject) {
        XMemberFeatureCall memberFeatureCall;
        boolean candidate;
        boolean bl = candidate = contextObject instanceof XFeatureCall && contextObject.eContainingFeature() == XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET;
        return candidate && (memberFeatureCall = (XMemberFeatureCall)contextObject.eContainer()).isExplicitStatic();
    }

    protected String getTypeName(EClass c, EStructuralFeature referingFeature) {
        if (referingFeature == XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE) {
            return " to an annotation type";
        }
        if (c == TypesPackage.Literals.JVM_ENUMERATION_TYPE) {
            return " to an enum type";
        }
        if (EcoreUtil2.isAssignableFrom((EClass)TypesPackage.Literals.JVM_TYPE, (EClass)c)) {
            return " to a type";
        }
        if (c == TypesPackage.Literals.JVM_OPERATION) {
            return " to an operation";
        }
        return "";
    }
}

