/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.drivers.mdr4atl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmi.reflect.InvalidCallException;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import org.eclipse.m2m.atl.drivers.mdr4atl.ASMMDRModelElement;
import org.eclipse.m2m.atl.engine.vm.ModelLoader;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMCollection;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;
import org.netbeans.api.mdr.MDRManager;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.xmi.XMIInputConfig;
import org.netbeans.api.xmi.XMIReader;
import org.netbeans.api.xmi.XMIReaderFactory;
import org.netbeans.api.xmi.XMIReferenceResolver;
import org.netbeans.api.xmi.XMIWriter;
import org.netbeans.api.xmi.XMIWriterFactory;
import org.netbeans.mdr.util.DebugException;

public class ASMMDRModel
extends ASMModel {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private static int verboseLevel = 1;
    private static boolean persist = false;
    private static MDRepository rep = null;
    private static XMIReader reader;
    private static XMIWriter writer;
    private Map allModelElements = new HashMap();
    private Map classifiers = null;
    private RefPackage pack;
    private Map elementByXmiId;
    private Map xmiIdByElement;
    private static ASMMDRModel mofmm;
    static /* synthetic */ Class class$0;

    static {
        logger.info("Initializing MDR...");
        ASMMDRModel.initMDR();
    }

    private ASMMDRModel(String name, RefPackage pack, ASMModel metamodel, boolean isTarget, ModelLoader ml) {
        super(name, metamodel, isTarget, ml);
        this.pack = pack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASMModelElement getASMModelElement(RefObject object) {
        ASMModelElement ret = null;
        Map map = this.allModelElements;
        synchronized (map) {
            ret = (ASMModelElement)this.allModelElements.get(object);
            if (ret == null) {
                ret = new ASMMDRModelElement(this.allModelElements, this, object);
            }
        }
        return ret;
    }

    private ASMModelElement getClassifier(String name) {
        if (this.classifiers == null) {
            this.classifiers = new HashMap();
            RefClass cl = this.pack.refClass("Classifier");
            ASMMDRModel.initClassifiers(cl.refAllOfType().iterator(), this.classifiers);
        }
        ASMModelElement ret = null;
        RefObject ro = (RefObject)this.classifiers.get(name);
        if (ro != null) {
            ret = this.getASMModelElement(ro);
        }
        return ret;
    }

    private static String baseName(RefObject o) {
        RefObject parent = (RefObject)o.refGetValue("container");
        if (parent != null) {
            String name = (String)parent.refGetValue("name");
            return String.valueOf(ASMMDRModel.baseName(parent)) + name + "::";
        }
        return "";
    }

    private static void initClassifiers(Iterator i, Map classifiers) {
        while (i.hasNext()) {
            RefObject ro = (RefObject)i.next();
            String name = (String)ro.refGetValue("name");
            ASMMDRModel.register(classifiers, name, ro);
            String base = ASMMDRModel.baseName(ro);
            if (base.length() <= 0) continue;
            ASMMDRModel.register(classifiers, String.valueOf(base) + name, ro);
        }
    }

    private static void register(Map classifiers, String name, RefObject classifier) {
        if (classifiers.containsKey(name)) {
            logger.warning("metamodel contains several classifiers with same name: " + name);
        }
        classifiers.put(name, classifier);
    }

    public ASMModelElement findModelElement(String name) {
        ASMModelElement ret = null;
        ret = this.getClassifier(name);
        return ret;
    }

    public Set getElementsByType(ASMModelElement ame) {
        HashSet<ASMModelElement> ret = new HashSet<ASMModelElement>();
        RefObject o = ((ASMMDRModelElement)ame).getObject();
        Iterator i = this.findRefClass(this.pack, o).refAllOfType().iterator();
        while (i.hasNext()) {
            ret.add(this.getASMModelElement((RefObject)i.next()));
        }
        return ret;
    }

    public ASMModelElement newModelElement(ASMModelElement type) {
        ASMModelElement ret = null;
        ret = this.getASMModelElement(this.findRefClass(this.pack, ((ASMMDRModelElement)type).getObject()).refCreateInstance(null));
        return ret;
    }

    private RefClass findRefClass(RefPackage pack, RefObject object) {
        RefClass ret = null;
        try {
            ret = pack.refClass(object);
        }
        catch (InvalidCallException invalidCallException) {}
        if (ret == null) {
            Iterator i = pack.refAllPackages().iterator();
            while (i.hasNext() && ret == null) {
                ret = this.findRefClass((RefPackage)i.next(), object);
            }
        }
        return ret;
    }

    protected RefAssociation findRefAssociation(RefObject object) {
        return this.findRefAssociation(this.pack, object);
    }

    private RefAssociation findRefAssociation(RefPackage pack, RefObject object) {
        RefAssociation ret = null;
        try {
            ret = pack.refAssociation(object);
        }
        catch (InvalidCallException invalidCallException) {}
        if (ret == null) {
            Iterator i = pack.refAllPackages().iterator();
            while (i.hasNext() && ret == null) {
                ret = this.findRefAssociation((RefPackage)i.next(), object);
            }
        }
        return ret;
    }

    private void getAllAcquaintances() {
        if (this.getMetamodel().equals(ASMMDRModel.getMOF())) {
            ASMMDRModelElement assoType = (ASMMDRModelElement)ASMMDRModel.getMOF().findModelElement("Association");
            Iterator i = this.getElementsByType(assoType).iterator();
            while (i.hasNext()) {
                ASMMDRModelElement asso = (ASMMDRModelElement)((Object)i.next());
                ASMMDRModelElement type1 = null;
                String name1 = null;
                ASMModelElement ae1 = null;
                ASMMDRModelElement type2 = null;
                String name2 = null;
                ASMModelElement ae2 = null;
                Iterator j = ((ASMCollection)asso.get(null, "contents")).iterator();
                while (j.hasNext()) {
                    ASMModelElement ae = (ASMModelElement)j.next();
                    if (!ae.getMetaobject().get(null, "name").equals(new ASMString("AssociationEnd"))) continue;
                    ASMMDRModelElement type = (ASMMDRModelElement)ae.get(null, "type");
                    if (type1 == null) {
                        type1 = type;
                        name1 = ((ASMString)ae.get(null, "name")).getSymbol();
                        ae1 = ae;
                        continue;
                    }
                    type2 = type;
                    name2 = ((ASMString)ae.get(null, "name")).getSymbol();
                    ae2 = ae;
                }
                type2.addAcquaintance(name1, asso, ae1, true);
                type1.addAcquaintance(name2, asso, ae2, false);
            }
        }
    }

    public static ASMMDRModel newASMMDRModel(String name, ASMMDRModel metamodel, ModelLoader ml) throws Exception {
        return ASMMDRModel.newASMMDRModel(name, name, metamodel, ml);
    }

    public static ASMMDRModel newASMMDRModel(String name, String uri, ASMMDRModel metamodel, ModelLoader ml) throws Exception {
        RefPackage mextent = null;
        String modifiedName = name;
        int id = 0;
        while (rep.getExtent(modifiedName) != null) {
            modifiedName = String.valueOf(name) + "_" + id++;
        }
        if (metamodel.getName().equals("MOF")) {
            mextent = rep.createExtent(modifiedName);
        } else {
            RefPackage mmextent = metamodel.pack;
            RefObject pack = null;
            Iterator it = mmextent.refClass("Package").refAllOfClass().iterator();
            while (it.hasNext()) {
                pack = (RefObject)it.next();
                if (pack.refGetValue("name").equals(metamodel.getName())) break;
            }
            mextent = rep.createExtent(modifiedName, pack);
        }
        return new ASMMDRModel(name, mextent, metamodel, true, ml);
    }

    public static ASMMDRModel loadASMMDRModel(String name, ASMMDRModel metamodel, String url, ModelLoader ml) throws Exception {
        return ASMMDRModel.loadASMMDRModel(name, metamodel, new File(url).toURL(), ml);
    }

    public static ASMMDRModel loadASMMDRModel(String name, ASMMDRModel metamodel, URL url, ModelLoader ml) throws Exception {
        return ASMMDRModel.loadASMMDRModel(name, metamodel, url.openStream(), ml);
    }

    public static ASMMDRModel loadASMMDRModel(String name, ASMMDRModel metamodel, InputStream in, ModelLoader ml) throws Exception {
        ASMMDRModel ret = ASMMDRModel.newASMMDRModel(name, metamodel, ml);
        try {
            XMIInputConfig inputConfig = reader.getConfiguration();
            final XMIReferenceResolver originalReferenceResolver = inputConfig.getReferenceResolver();
            final HashMap elementByXmiId = new HashMap();
            final HashMap xmiIdByElement = new HashMap();
            inputConfig.setReferenceResolver(new XMIReferenceResolver(){

                public void register(String systemId, String xmiId, RefObject object) {
                    elementByXmiId.put(xmiId, object);
                    xmiIdByElement.put(object, xmiId);
                    if (originalReferenceResolver != null) {
                        originalReferenceResolver.register(systemId, xmiId, object);
                    }
                }

                public void resolve(XMIReferenceResolver.Client client, RefPackage extent, String systemId, XMIInputConfig configuration, Collection hrefs) throws MalformedXMIException, IOException {
                    if (originalReferenceResolver != null) {
                        originalReferenceResolver.resolve(client, extent, systemId, configuration, hrefs);
                    }
                }
            });
            reader.read(in, null, ret.pack);
            inputConfig.setReferenceResolver(originalReferenceResolver);
            ret.elementByXmiId = elementByXmiId;
            ret.xmiIdByElement = xmiIdByElement;
        }
        catch (Exception e) {
            throw new Exception("Error while reading " + name + ":" + e.getLocalizedMessage(), e);
        }
        ret.setIsTarget(false);
        ret.getAllAcquaintances();
        return ret;
    }

    public static ASMMDRModel createMOF(ModelLoader ml) {
        ASMMDRModel ret = null;
        try {
            mofmm = ret = new ASMMDRModel("MOF", rep.getExtent("MOF"), null, false, ml);
        }
        catch (DebugException de) {
            logger.log(Level.SEVERE, de.getLocalizedMessage(), de);
        }
        return ret;
    }

    public void save(String url) throws IOException {
        FileOutputStream out = new FileOutputStream(url);
        this.save(out);
    }

    public void save(OutputStream out) throws IOException {
        writer.write(out, this.pack, null);
    }

    public void save(String url, String xmiVersion) throws IOException {
        this.save(url, xmiVersion, null);
    }

    public void save(String url, String xmiVersion, String encoding) throws IOException {
        FileOutputStream out = new FileOutputStream(url);
        this.save(out, xmiVersion, encoding);
    }

    public void save(OutputStream out, String xmiVersion) throws IOException {
        this.save(out, xmiVersion, null);
    }

    public void save(OutputStream out, String xmiVersion, String encoding) throws IOException {
        if (encoding != null) {
            writer.getConfiguration().setEncoding(encoding);
        }
        writer.write(out, this.pack, xmiVersion);
    }

    private static void initMDR() {
        if (rep != null) {
            return;
        }
        if (verboseLevel < 1) {
            System.setProperty("org.netbeans.lib.jmi.Logger.fileName", "");
        }
        if (!persist) {
            System.setProperty("org.netbeans.mdr.storagemodel.StorageFactoryClassName", "org.netbeans.mdr.persistence.memoryimpl.StorageFactoryImpl");
        }
        System.setProperty("org.openide.util.Lookup", "org.openide.util.lookup.ATLLookup");
        Thread thread = Thread.currentThread();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.openide.util.lookup.ATLLookup");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        thread.setContextClassLoader(clazz.getClassLoader());
        rep = MDRManager.getDefault().getDefaultRepository();
        reader = XMIReaderFactory.getDefault().createXMIReader();
        writer = XMIWriterFactory.getDefault().createXMIWriter();
        rep.getExtent("MOF");
    }

    public RefPackage getPackage() {
        return this.pack;
    }

    public String xmiIdByElement(RefObject object) {
        return (String)this.xmiIdByElement.get(object);
    }

    public RefObject elementByXmiId(String xmiId) {
        return (RefObject)this.elementByXmiId.get(xmiId);
    }

    public static ASMModel getMOF() {
        return mofmm;
    }

    public void dispose() {
        if (this.pack != null) {
            this.pack.refDelete();
            this.pack = null;
            this.allModelElements = null;
            this.elementByXmiId = null;
            this.xmiIdByElement = null;
            this.classifiers = null;
        }
    }

    public void finalize() {
        this.dispose();
    }
}

