/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.am3.dsls.km3.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gmt.am3.dsls.km3.KM3Projector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class MOF142KM3
implements IObjectActionDelegate {
    private static final String pluginid = "org.eclipse.gmt.am3.dsls.km3";
    private static final String errorMsg = "An error was encountered while trying to get a KM3 file from a MOF-1.4 metamodel.";
    private AtlModelHandler amh = null;
    private ISelection selection;
    private KM3Projector kp = KM3Projector.getKM3Projector();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Job job = new Job("MOF-1.4 to KM3"){

            protected IStatus run(IProgressMonitor mon) {
                Status ret = null;
                mon.beginTask("MOF-1.4 to KM3", -1);
                if (MOF142KM3.this.amh == null) {
                    mon.subTask("Initializing MDR");
                    MOF142KM3.this.amh = AtlModelHandler.getDefault((String)"MDR");
                }
                try {
                    mon.subTask("Loading MOF-1.4 metamodel");
                    IFile file = (IFile)((IStructuredSelection)MOF142KM3.this.selection).getFirstElement();
                    InputStream in = file.getContents();
                    ASMModel model = MOF142KM3.this.amh.loadModel(file.getName(), MOF142KM3.this.amh.getMof(), in);
                    mon.subTask("Transforming MOF-1.4 metamodel into KM3 model");
                    ASMModel km3model = MOF142KM3.this.kp.getKM3FromMOF14(model);
                    mon.subTask("Serializing KM3 model");
                    String km3 = MOF142KM3.this.kp.getStringFromKM3(km3model);
                    String name = file.getName();
                    name = String.valueOf(name.substring(0, name.length() - file.getFileExtension().length())) + "km3";
                    if (km3 != null) {
                        mon.subTask("Writing KM3 file");
                        IWorkspace wks = ResourcesPlugin.getWorkspace();
                        IWorkspaceRoot wksroot = wks.getRoot();
                        IFile fileCreated = wksroot.getFile(file.getFullPath().removeLastSegments(1).append(name));
                        InputStream stream = MOF142KM3.this.openContentStream(km3);
                        if (fileCreated.exists()) {
                            fileCreated.setContents(stream, true, true, null);
                        } else {
                            fileCreated.create(stream, true, null);
                        }
                        try {
                            stream.close();
                            ret = new Status(0, MOF142KM3.pluginid, 0, file + " transformed into " + name, null);
                        }
                        catch (IOException e1) {
                            ret = new Status(4, MOF142KM3.pluginid, 0, MOF142KM3.errorMsg, (Throwable)e1);
                        }
                    } else {
                        ret = new Status(4, MOF142KM3.pluginid, 0, "Encountered an error while serializing KM3 model.", null);
                    }
                }
                catch (CoreException e) {
                    ret = new Status(4, MOF142KM3.pluginid, 0, MOF142KM3.errorMsg, (Throwable)e);
                }
                return ret;
            }
        };
        job.setPriority(40);
        job.schedule();
    }

    private InputStream openContentStream(String contents) {
        return new ByteArrayInputStream(contents.getBytes());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

