/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.flow.impl;

import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.eef.EEFGen.EEFGenModel;
import org.eclipse.emf.eef.codegen.core.initializer.PropertiesInitializer;
import org.eclipse.emf.eef.codegen.core.util.EMFHelper;
import org.eclipse.emf.eef.codegen.flow.Step;
import org.eclipse.emf.eef.codegen.flow.var.WorkflowVariable;

public class GenerateEEFModels
extends Step {
    private PropertiesInitializer propertiesInitializer;
    private Object modelURI;
    private Object editGenProject;
    private Object genmodelURI;
    private WorkflowVariable eefgenModelVar;
    private WorkflowVariable eefModelsFolderVar;
    private String modelsFolderPath;

    public GenerateEEFModels(String name, Object modelURI, Object editGenProject, Object genmodelURI, String modelsFolderPath) {
        super(name);
        this.modelURI = modelURI;
        this.editGenProject = editGenProject;
        this.genmodelURI = genmodelURI;
        this.modelsFolderPath = modelsFolderPath;
    }

    public IStatus execute(IProgressMonitor monitor) {
        try {
            IProject editProject = this.getEditProject();
            if (editProject != null) {
                this.propertiesInitializer = new PropertiesInitializer();
                IFolder modelsFolder = this.createEEFModelsFolder(editProject, monitor);
                this.initializeEEFModels(modelsFolder, this.getGenModelURI());
                EEFGenModel eefgenModel = this.generatedEEFGen(this.getModelURI(), modelsFolder);
                ((WorkflowVariable)this.getEEFGenModel()).setValue((Object)eefgenModel);
                return Status.OK_STATUS;
            }
            return new Status(4, "org.eclipse.emf.eef.codegen", "Unable to find edit project");
        }
        catch (IOException iOException) {
            return new Status(4, "org.eclipse.emf.eef.codegen", "An error occured during EEF models initialization.");
        }
        catch (CoreException coreException) {
            return new Status(4, "org.eclipse.emf.eef.codegen", "An error occured during EEF models initialization.");
        }
    }

    public Object getEEFGenModel() {
        if (this.eefgenModelVar == null) {
            this.eefgenModelVar = new WorkflowVariable(this.eefgenmodelVarName());
        }
        return this.eefgenModelVar;
    }

    private final String eefgenmodelVarName() {
        return "GEN_EEF_MODELS_" + this.name + "_EEFGENMODEL";
    }

    public Object getEEFModelsFolder() {
        if (this.eefModelsFolderVar == null) {
            this.eefModelsFolderVar = new WorkflowVariable(this.eefModelsFolderVarName());
        }
        return this.eefModelsFolderVar;
    }

    private final String eefModelsFolderVarName() {
        return "GEN_EEF_MODELS_" + this.name + "_EEFMODELSFOLDER";
    }

    private URI getModelURI() {
        if (this.modelURI instanceof URI) {
            return (URI)this.modelURI;
        }
        if (this.modelURI instanceof WorkflowVariable) {
            return (URI)((WorkflowVariable)this.modelURI).getValue();
        }
        return null;
    }

    private URI getGenModelURI() {
        if (this.genmodelURI instanceof URI) {
            return (URI)this.genmodelURI;
        }
        if (this.genmodelURI instanceof WorkflowVariable) {
            return (URI)((WorkflowVariable)this.genmodelURI).getValue();
        }
        return null;
    }

    private IProject getEditProject() {
        if (this.editGenProject instanceof IProject) {
            return (IProject)this.editGenProject;
        }
        if (this.editGenProject instanceof WorkflowVariable) {
            return (IProject)((WorkflowVariable)this.editGenProject).getValue();
        }
        return null;
    }

    private void initializeEEFModels(IFolder modelsFolder, URI genmodelURI) throws IOException, CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        this.propertiesInitializer.initialize(genmodelURI, (IContainer)modelsFolder);
        modelsFolder.refreshLocal(2, (IProgressMonitor)monitor);
    }

    private EEFGenModel generatedEEFGen(URI modelURI, IFolder modelsFolder) throws IOException {
        String eefgenPath = String.valueOf(modelsFolder.getFullPath().toString()) + "/" + modelURI.trimFileExtension().appendFileExtension("eefgen").lastSegment();
        EEFGenModel eefgenModel = null;
        URI eefgenURI = URI.createPlatformResourceURI((String)eefgenPath, (boolean)true);
        EObject extractedEEFGenModel = EMFHelper.load(eefgenURI, this.resourceSet);
        if (extractedEEFGenModel instanceof EEFGenModel) {
            eefgenModel = (EEFGenModel)extractedEEFGenModel;
        }
        return eefgenModel;
    }

    private IFolder createEEFModelsFolder(IProject editProject, IProgressMonitor monitor) throws CoreException {
        IFolder modelsFolder = editProject.getFolder((IPath)new Path(this.modelsFolderPath));
        if (!modelsFolder.exists()) {
            modelsFolder.create(true, true, monitor);
            editProject.refreshLocal(2, monitor);
        }
        ((WorkflowVariable)this.getEEFModelsFolder()).setValue((Object)modelsFolder);
        return modelsFolder;
    }
}

